/*******************************************************************************
 * @File: font.h
 * @Author: Milandr, L.
 * @Project: Generic
 * @Microcontroller: 1986VE92U
 * @Device: Evaluation Board For MCU 1986VE92U
 * @Date: 22.03.2017
 * @Purpose: Кодировка символов (8x8)
 *******************************************************************************/

#ifndef FONT_H
#define FONT_H

// Границы диапазона используемых кодировок
#define FONT_MIN_CODE 32
#define FONT_MAX_CODE 255

// Кодировка символов согласно таблице ASCII
static const char Font[] =
{
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Пробел    32         0x20
0x00, 0x00, 0x00, 0xDF, 0xDF, 0x00, 0x00, 0x00,  // !         33         0x21
0x00, 0x07, 0x07, 0x00, 0x07, 0x07, 0x00, 0x00,  // "         34         0x22
0x24, 0x24, 0xFF, 0x24, 0xFF, 0x24, 0x24, 0x00,  // #         35         0x23
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // $         36         0x24
0x00, 0x63, 0x33, 0x18, 0x0C, 0x66, 0x63, 0x00,  // %         37         0x25
0x60, 0xF6, 0x9F, 0x89, 0x9F, 0x76, 0xD8, 0x00,  // &         38         0x26
0x00, 0x00, 0x00, 0x07, 0x07, 0x00, 0x00, 0x00,  // '         39         0x27
0x00, 0x3C, 0x7E, 0xC3, 0x81, 0x81, 0x00, 0x00,  // (         40         0x28
0x00, 0x81, 0x81, 0xC3, 0x7E, 0x3C, 0x00, 0x00,  // )         41         0x29
0x08, 0x2A, 0x1C, 0x7F, 0x1C, 0x2A, 0x08, 0x00,  // *         42         0x2A
0x00, 0x18, 0x18, 0x7E, 0x7E, 0x18, 0x18, 0x00,  // +         43         0x2B
0x00, 0x00, 0x80, 0xE0, 0x60, 0x00, 0x00, 0x00,  // ,         44         0x2C
0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00,  // -         45         0x2D
0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00,  // .         46         0x2E
0x00, 0x00, 0xC0, 0xF0, 0x3C, 0x0F, 0x03, 0x00,  // /         47         0x2F

0x3E, 0x7F, 0x71, 0x59, 0x4D, 0x7F, 0x3E, 0x00,  // 0         48         0x30
0x40, 0x42, 0x7F, 0x7F, 0x40, 0x40, 0x00, 0x00,  // 1         49         0x31
0x62, 0x73, 0x59, 0x49, 0x6F, 0x66, 0x00, 0x00,  // 2         50         0x32
0x22, 0x63, 0x49, 0x49, 0x7F, 0x36, 0x00, 0x00,  // 3         51         0x33
0x18, 0x1C, 0x16, 0x53, 0x7F, 0x7F, 0x50, 0x00,  // 4         52         0x34
0x27, 0x67, 0x45, 0x45, 0x7D, 0x39, 0x00, 0x00,  // 5         53         0x35
0x3C, 0x7E, 0x4B, 0x49, 0x79, 0x30, 0x00, 0x00,  // 6         54         0x36
0x03, 0x03, 0x71, 0x79, 0x0F, 0x07, 0x00, 0x00,  // 7         55         0x37
0x36, 0x7F, 0x49, 0x49, 0x7F, 0x36, 0x00, 0x00,  // 8         56         0x38
0x06, 0x4F, 0x49, 0x69, 0x3F, 0x1E, 0x00, 0x00,  // 9         57         0x39

0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00,  // :         58         0x3A
0x00, 0x00, 0x80, 0x66, 0x66, 0x00, 0x00, 0x00,  // ;         59         0x3B
0x00, 0x00, 0x08, 0x14, 0x22, 0x41, 0x00, 0x00,  // <         60         0x3C
0x00, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00,  // =         61         0x3D
0x00, 0x00, 0x41, 0x22, 0x14, 0x08, 0x00, 0x00,  // >         62         0x3E
0x00, 0x02, 0x03, 0x69, 0x6D, 0x07, 0x02, 0x00,  // ?         63         0x3F
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // @         64         0x40

0x7C, 0x7E, 0x13, 0x13, 0x7E, 0x7C, 0x00, 0x00,  // A         65         0x41 
0x41, 0x7F, 0x7F, 0x49, 0x49, 0x7F, 0x36, 0x00,  // B         66         0x42
0x1C, 0x3E, 0x63, 0x41, 0x41, 0x63, 0x22, 0x00,  // C         67         0x43
0x41, 0x7F, 0x7F, 0x41, 0x63, 0x3E, 0x1C, 0x00,  // D         68         0x44
0x41, 0x7F, 0x7F, 0x49, 0x5D, 0x41, 0x63, 0x00,  // E         69         0x45
0x41, 0x7F, 0x7F, 0x49, 0x1D, 0x01, 0x03, 0x00,  // F         70         0x46
0x1C, 0x3E, 0x63, 0x41, 0x51, 0x73, 0x72, 0x00,  // G         71         0x47
0x7F, 0x7F, 0x08, 0x08, 0x7F, 0x7F, 0x00, 0x00,  // H         72         0x48
0x00, 0x41, 0x7F, 0x7F, 0x41, 0x00, 0x00, 0x00,  // I         73         0x49
0x30, 0x70, 0x40, 0x41, 0x7F, 0x3F, 0x01, 0x00,  // J         74         0x4A
0x41, 0x7F, 0x7F, 0x08, 0x1C, 0x77, 0x63, 0x00,  // K         75         0x4B
0x41, 0x7F, 0x7F, 0x41, 0x40, 0x60, 0x70, 0x00,  // L         76         0x4C
0x7F, 0x7F, 0x0E, 0x1C, 0x0E, 0x7F, 0x7F, 0x00,  // M         77         0x4D
0x7F, 0x7F, 0x06, 0x0C, 0x18, 0x7F, 0x7F, 0x00,  // N         78         0x4E
0x1C, 0x3E, 0x63, 0x41, 0x63, 0x3E, 0x1C, 0x00,  // O         79         0x4F
0x41, 0x7F, 0x7F, 0x49, 0x09, 0x0F, 0x06, 0x00,  // P         80         0x50
0x1E, 0x3F, 0x21, 0x71, 0x7F, 0x5E, 0x00, 0x00,  // Q         81         0x51
0x41, 0x7F, 0x7F, 0x09, 0x19, 0x7F, 0x66, 0x00,  // R         82         0x52
0x26, 0x6F, 0x4D, 0x59, 0x73, 0x32, 0x00, 0x00,  // S         83         0x53
0x03, 0x41, 0x7F, 0x7F, 0x41, 0x03, 0x00, 0x00,  // T         84         0x54
0x3F, 0x7F, 0x60, 0x60, 0x7F, 0x3F, 0x00, 0x00,  // U         85         0x55
0x1F, 0x3F, 0x60, 0x60, 0x3F, 0x1F, 0x00, 0x00,  // V         86         0x56
0x7F, 0x7F, 0x30, 0x18, 0x30, 0x7F, 0x7F, 0x00,  // W         87         0x57
0x63, 0x67, 0x3C, 0x18, 0x3C, 0x67, 0x63, 0x00,  // X         88         0x58
0x07, 0x4F, 0x78, 0x78, 0x4F, 0x07, 0x00, 0x00,  // Y         89         0x59
0x47, 0x63, 0x71, 0x59, 0x4D, 0x67, 0x73, 0x00,  // Z         90         0x5A

0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // [         91         0x5B
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // \         92         0x5C
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ]         93         0x5D
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ^         94         0x5E
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // _         95         0x5F
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // `         96         0x60

0x20, 0x74, 0x54, 0x54, 0x3C, 0x78, 0x40, 0x00,  // a         97         0x61
0x41, 0x7F, 0x3F, 0x48, 0x48, 0x78, 0x30, 0x00,  // b         98         0x62
 56, 124,  68,  68, 108,  40,   0,   0,          // c                    0x63
 48, 120,  72,  73,  63, 127,  64,   0,          // d                    0x64
 56, 124,  84,  84,  92,  24,   0,   0,          // e                    0x65
 72, 126, 127,  73,   3,   2,   0,   0,          // f                    0x66
 76,  94,  82,  82, 124,  62,   2,   0,          // g                    0x67
 65, 127, 127,   8,   4, 124, 120,   0,          // h                    0x68
  0,  68, 125, 125,  64,   0,   0,   0,          // i                    0x69
 48, 112,  64,  64, 125,  61,   0,   0,          // j                    0x6A
 65, 127, 127,  16,  56, 108,  68,   0,          // k                    0x6B        127 - 0x7F
  0,  65, 127, 127,  64,   0,   0,   0,          // l                    0x6C        65  - 0x41
124, 124,  24,  56,  28, 124, 120,   0,          // m                    0x6D
124, 124,   4,   4, 124, 120,   0,   0,          // n                    0x6E
 56, 124,  68,  68, 124,  56,   0,   0,          // o                    0x6F
 68, 120, 124,  84,  20,  28,   8,   0,          // p                    0x70
  8,  28,  20,  84, 120, 124,  64,   0,          // q                    0x71
 68, 124, 120,  76,   4,  28,  24,   0,          // r                    0x72
 72,  92,  84,  84, 116,  36,   0,   0,          // s                    0x73
  0,   4,  62, 127,  68,  36,   0,   0,          // t                    0x74
 60, 124,  64,  64,  60, 124,  64,   0,          // u                    0x75
 28,  60,  96,  96,  60,  28,   0,   0,          // v                    0x76
 60, 124, 112,  56, 112, 124,  60,   0,          // w                    0x77
 68, 108,  56,  16,  56, 108,  68,   0,          // x                    0x78
 76,  92,  80,  80, 124,  60,   0,   0,          // y                    0x79
 76, 100, 116,  92,  76, 100,   0,   0,          // z                    0x7A

0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // {                    0x7B
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // |                    0x7C
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // }                    0x7D
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ~                    0x7E
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //                      0x7F

0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // €                    0x80
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //                      0x81
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ‚                    0x82
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ƒ                    0x83
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // „                    0x84
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // …                    0x85
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // †                    0x86
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ‡                    0x87
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ˆ                    0x88
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ‰                    0x89
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Š                    0x8A
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ‹                    0x8B
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Œ                    0x8C
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //                      0x8D
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Ž                    0x8E
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //                      0x8F
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //                      0x90
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ‘                    0x91
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ’                    0x92
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // “                    0x93
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ”                    0x94 
0x00, 0x18, 0x3C, 0x7D, 0x7D, 0x3C, 0x18, 0x00,  // •                    0x95
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // –                    0x96
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // —                    0x97
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //                      0x98
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ™                    0x99
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // š                    0x9A
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ›                    0x9B
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // œ                    0x9C
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //                      0x9D
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ž                    0x9E
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Ÿ                    0x9F
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //                      0xA0
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ¡                    0xA1
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ¢                    0xA2
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // £                    0xA3
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ¤                    0xA4
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ¥                    0xA5
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ¦                    0xA6
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // §                    0xA7
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ¨                    0xA8
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ©                    0xA9
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ª                    0xAA
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // «                    0xAB
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ¬                    0xAC
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ­                    0xAD
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ®                    0xAE
0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00,  // ¯                    0xAF
0x00, 0x00, 0x06, 0x09, 0x09, 0x06, 0x00, 0x00,  // °                    0xB0
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ±                    0xB1
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ²                    0xB2
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ³                    0xB3
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ´                    0xB4
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // µ                    0xB5
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ¶                    0xB6
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ·                    0xB7
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ¸                    0xB8
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ¹                    0xB9
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // º                    0xBA
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // »                    0xBB
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ¼                    0xBC
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ½                    0xBD
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //                      0xBE 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //                      0xBF 

124, 126,  19,  19, 126, 124,   0,   0,          // А                    0xC0
 65, 127, 127,  73,  73, 121,  51,   0,          // Б                    0xC1
 65, 127, 127,  73,  73, 127,  54,   0,          // В                    0xC2
 65, 127, 127,  65,   1,   3,   3,   0,          // Г                    0xC3
120, 126,  55,  51,  55, 126, 120,   0,          // Д                    0xC4
 65, 127, 127,  73,  93,  65,  99,   0,          // Е                    0xC5
 99,  20, 127, 127,  20,  99,   0,   0,          // Ж                    0xC6
 99,  99,  73,  73, 107, 127,  54,   0,          // З                    0xC7
127, 127,  48,  24,  12, 127, 127,   0,          // И                    0xC8
127, 127,  48,  27,  12, 127, 127,   0,          // Й                    0xC9
 65, 127, 127,   8,  28, 119,  99,   0,          // К                    0xCA
 96, 127,  31,   3, 127, 127,  65,   0,          // Л                    0xCB
127, 127,  14,  28,  14, 127, 127,   0,          // М                    0xCC
127, 127,   8,   8, 127, 127,   0,   0,          // Н                    0xCD
 28,  62,  99,  65,  99,  62,  28,   0,          // О                    0xCE
127, 127,   3,   3, 127, 127,   0,   0,          // П                    0xCF
 65, 127, 127,  73,   9,  15,   6,   0,          // Р                    0xD0
 28,  62,  99,  65,  65,  99,  34,   0,          // С                    0xD1
  3,  65, 127, 127,  65,   3,   0,   0,          // Т                    0xD2
 99, 103,  60,  24,  12,   7,   3,   0,          // У                    0xD3
 30,  82, 127, 127,  82,  30,   0,   0,          // Ф                    0xD4
 99, 103,  60,  24,  60, 103,  99,   0,          // Х                    0xD5
 63,  63,  32,  32,  63,  63,  96,   0,          // Ц                    0xD6
 15,  31,  24,  88, 127, 127,  64,   0,          // Ч                    0xD7
127, 127,  96, 127,  96, 127, 127,   0,          // Ш                    0xD8
 63,  32,  63,  63,  32,  63,  96,   0,          // Щ                    0xD9
  1, 127, 127,  72,  72, 120,  48,   0,          // Ъ                    0xDA
127, 127,  72,  72, 120,   0, 127,   0,          // Ы                    0xDB
127, 127,  72,  72, 120,  48,   0,	 0,          // Ь                    0xDC
 54,  99,  73,  73, 107, 127,  62,   0,          // Э                    0xDD
127,   8,  62,  99,  65,  99,  62,   0,          // Ю                    0xDE
102, 127,  25,   9, 127, 127,  65,   0,          // Я                    0xDF
                                                       
 32, 116,  84,  84,  60, 120,  64,   0,          // а                    0xE0
 48, 124,  74,  74, 122,  49,   0,   0,          // б                    0xE1
 68, 124, 124,  84,  84,  40,   0,   0,          // в                    0xE2
 68, 124, 124,  68,  12,   8,   0,   0,          // г                    0xE3
 96,  56,  52,  52,  56,  96,   0,   0,          // д                    0xE4
 56, 124,  84,  84,  92,  24,   0,   0,          // е                    0xE5
 68,  40, 124, 124,  40,  68,   0,   0,          // ж                    0xE6
 46,  68,  84,  84, 124,  40,   0,   0,          // з                    0xE7
124, 124,  32,  16, 124, 124,   0,   0,          // и                    0xE8
124, 124,  33,  17, 124, 124,   0,   0,          // й                    0xE9
 68, 124, 124,  16,  56, 108,  68,   0,          // к                    0xEA
 64, 120,  12,   4, 124, 124,  64,   0,          // л                    0xEB
120, 124,   8,  16,   8, 124, 120,   0,          // м                    0xEC
124, 124,  16,  16, 124, 124,   0,   0,          // н                    0xED
 56, 124,  68,  68, 124,  56,   0,   0,          // о                    0xEE
124, 124,   4,   4, 124, 124,   0,   0,          // п                    0xEF
 68, 120, 124,  84,  20,  28,   8,   0,          // р                    0xF0
 56, 124,  68,  68, 108,  40,   0,   0,          // с                    0xF1
  8,  68, 124, 124,  68,   8,   0,   0,          // т                    0xF2
 76,  92,  80,  80, 124,  60,   0,   0,          // у                    0xF3
  8,  84, 124, 124,  84,   8,   0,   0,          // ф                    0xF4
 68, 108,  56,  16,  56, 108,  68,   0,          // х                    0xF5
 60,  60,  32,  60,  60,  96,   0,   0,          // ц                    0xF6
 28,  16,  80, 124, 124,  64,   0,   0,          // ч                    0xF7
124,  64, 124,  64, 124,   0,   0,   0,          // ш                    0xF8
 60,  32,  60,  32,  60,  96,   0,   0,          // щ                    0xF9
 68,  60,  80,  80, 112,  32,   0,   0,          // ъ                    0xFA
 64,  60,  80,  80,  32,   0, 124,   0,          // ы                    0xFB
 64,  60,  80,  80,  80,  32,   0,   0,          // ь                    0xFC
 40,  68,  84,  84,  56,   0,   0,   0,          // э                    0xFD
124,  16,  56,  68,  68,  56,   0,   0,          // ю                    0xFE
 64,  40,  20,  20, 124, 124,   0,   0           // я                    0xFF
};

#endif 
