
#include "MDR1986VE8T.h"
#include "spec.h"

#include "mdr32f8_config.h"
#include "mdr32f8_port.h"
#include "mdr32f8_clkctrl.h"

#define PRES_REG2 0
#define PRES_REG0 2

#define PRES_REG1 99
#define PRES_REG3 1

#define BASE_REG0 12
#define BASE_REG1 15
#define BASE_REG2 12
#define BASE_REG3 15

int main(void)
{
    // ----------------------------- System setup. -----------------------------

    // Key to access clock control.
    UNLOCK_UNIT(CLK_CNTR_key);
    // Key to access fault control.
    UNLOCK_UNIT(FT_CNTR_key);

    // Set CLKCTRL to default.
    CLKCTRL_DeInit();

    BKPCNTR_SRILOWconfig(BKPCNTR_SRILOW_upto_50MHz);

    // Enable HSE0 clock.
    CLKCTRL_HSEconfig(CLKCTRL_HSE0_CLK_ON);

    // Check HSE success, enable PLL0, check PLL0 success, select MAX_CLK source.
    while (CLKCTRL_HSEstatus(CLKCTRL_HSEn_STAT_HSE0_RDY) != SUCCESS) { }

    // Select PLL0 clk src, PLL0_N, PLL0_Q to get FINT = FIN*(PLLn_N)/(PLLn_Q+1)
    CLKCTRL_CPU_PLLconfig(PLL0, CLKCTRL_PLLn_CLK_SELECT_HSE0div1, PLL_DIVQ_Q_1, 8); // PLLn, SRC, Q, N
    while (CLKCTRL_CPU_PLLstatus(0) != SUCCESS) { }
    CLKCTRL_MAX_CLKSelection(CLKCTRL_MAX_CLK_PLL0);

    // ---------------------------- Checker setup. -----------------------------

    // Specify prescalers and compare values.
    CLK_CNTR->PLL0_CHK0 = PRES_REG0 << 16 | PRES_REG2 << 0;
    CLK_CNTR->PLL0_CHK1 = PRES_REG3 << 16 | PRES_REG1 << 0;
    CLK_CNTR->PLL0_CHK2 = BASE_REG3 << 24 | BASE_REG2 << 16 | BASE_REG1 << 8 | BASE_REG0 << 0;

    CLK_CNTR->PLL0_CLK |= 1 << 20; // Enable checker

    for (uint32_t i = 0; i < 40000; i++) { } // Delay before flags and shadow registers reset.

    CLK_CNTR->PLL0_CLK |= (63 << 21); // Reset all flags and shadow registers.

    // ----------------------- Diod switch on demoboard. -----------------------

    // Enable PORTC clock.
    CLKCTRL_PER0_CLKcmd(CLKCTRL_PER0_CLK_MDR_PORTC_EN, ENABLE);

    // Allow write to PORTC registers.
    UNLOCK_UNIT(PORTC_key);

    PORT_DeInit(PORTC);

    // Configure PC20 as digital output.
    PORT_InitTypeDef PORT_InitStructure;
    PORT_StructInit(&PORT_InitStructure);
    PORT_InitStructure.PORT_Pin     = PORT_Pin_20;
    PORT_InitStructure.PORT_SFUNC   = PORT_SFUNC_USER;
    PORT_InitStructure.PORT_SANALOG = PORT_SANALOG_DIGITAL;
    PORT_InitStructure.PORT_SOE     = PORT_SOE_OUT;
    PORT_InitStructure.PORT_SPWR    = PORT_SPWR_10;
    PORT_Init(PORTC, &PORT_InitStructure);

    while (1) {
        PORT_SetBits(PORTC, PORT_Pin_20);
        for (uint32_t i = 0; i < 40000; i++) { }
        PORT_ResetBits(PORTC, PORT_Pin_20);
        for (uint32_t i = 0; i < 40000; i++) { }
    }
}
