
#include "MDR32F9Qx_config.h"
#include "config.h"
#include "ethfunc.h"

const uint16_t MyMAC[3]           = { 0x3412, 0x7856, 0xBC9A }; // MAC- 
const uint16_t MyIPAddress[2]     = { 0xA8C0, 0x5801 };         // IP-  ( IP-): 192.168.1.88
const uint16_t RemoteIPAddress[2] = { 0xA8C0, 0x4101 };         // IP-    ARP-
uint32_t       ReplyICMPCounter   = 0;
uint16_t       Identification = 0, SequenceNumber = 0;
_Rec_Frame     Frame;
_Remote_Mac    Remote_MAC;

void     Request_ARP(void);
void     PacketAnaliser(void);
uint16_t CheckSum_IP(uint16_t*);
uint16_t CheckSum_ICMP(uint16_t, uint16_t*);
void     Request_ICMP(void);
void     RemoteMacInit(void);

void TIMER1_IRQHandler()
{
    static uint32_t Time = 5, Sec = 0, MilliSec = 0, Timeout = TIMEOUT;

    MDR_TIMER1->STATUS &= 0xFFFD; //   
    if (MilliSec++ == 19) {
        Sec++;
        MilliSec = 0;
    }

    if (Sec == Time) {
        if (Remote_MAC.hasMAC != 1) {
            Request_ARP();
            Timeout = 2 * TIMEOUT;
        } else {
            Request_ICMP();
            Timeout = TIMEOUT;
        }
        Time = Sec + Timeout;
    }
}

int main()
{
    SysTickInit();
    ClkConfig();
    PortConfig();
    RemoteMacInit();
    EthernetConfig();
    NVIC_EnableIRQ(ETHERNET_IRQn);
    NVIC_EnableIRQ(TIMER1_IRQn);
    Timer1Init();
    Identification = (uint16_t)SysTick->VAL;
    SequenceNumber = (uint16_t)SysTick->VAL;
    DisableSysTick();
    while (1) {
        if ((MDR_ETHERNET1->PHY_Status & 0x02) == 0x00)
            MDR_PORTB->SETTX = 1 << 15; //   LINK
        else
            MDR_PORTB->CLRTX = 1 << 15;

        if ((MDR_ETHERNET1->PHY_Status & 0x08) == 0x00)
            MDR_PORTB->SETTX = 1 << 14; // Full Duplex Mode
        else
            MDR_PORTB->CLRTX = 1 << 14;

        MDR_PORTD->RXTX = ReplyICMPCounter << 7;
    }
}

void ETHERNET_IRQHandler()
{
    uint16_t Status;

    Status                 = MDR_ETHERNET1->ETH_IFR;
    MDR_ETHERNET1->ETH_IFR = Status;
    Status &= 0x101;
    if ((Status & 0x01) == 0x01) {
        Frame.Counter = ReadPacket(&Frame);
        PacketAnaliser();
    }
}

//***    
void PacketAnaliser(void)
{
    switch (Frame.Data[6]) //    
    {
        case 0x0008: //  IP
            if (Remote_MAC.hasMAC == 0)
                break;                                                                    //    !
            if ((Frame.Data[15] == MyIPAddress[0]) && (Frame.Data[16] == MyIPAddress[1])) //  IP     
            {                                                                             //   ,     ,
                if (CheckSum_IP(Frame.Data) == Frame.Data[12])                            //       , 
                {                                                                         //  -  
                    //--------------------ICMP-------------------
                    if ((Frame.Data[11] & 0xFF00) == 0x0100) //   : ICMP
                    {
                        if (Frame.Data[17] == 0x0000) //   - Echo (ping) reply
                        {
                            if (Frame.Data[18] == CheckSum_ICMP(20, Frame.Data))
                                ReplyICMPCounter++;
                        }
                    }
                }
                //-------------------------------------------
            }
            break;

        case 0x0608: //  ARP
            if (Frame.Data[10] != 0x0200)
                break; // ARP-reply

            Remote_MAC.RmtMAC[0] = Frame.Data[3];
            Remote_MAC.RmtMAC[1] = Frame.Data[4];
            Remote_MAC.RmtMAC[2] = Frame.Data[5];

            Remote_MAC.RmtIP[0] = Frame.Data[14];
            Remote_MAC.RmtIP[1] = Frame.Data[15];

            Remote_MAC.hasMAC = 1;
            break;
    }
}

//***       IP-
uint16_t CheckSum_IP(uint16_t* Data)
{
    unsigned long a, cs = 0;
    for (a = 0; a < 10; a++) {
        if (a == 5)
            continue;
        else
            cs = cs + Data[7 + a];
    }
    cs = (cs >> 16) + (cs & 0xFFFF);
    return (uint16_t)(~cs);
}

//***       ICMP-
//*** size - - ,      
uint16_t CheckSum_ICMP(uint16_t size, uint16_t* Data)
{
    unsigned long a, cs = 0;
    for (a = 0; a < size; a++) {
        if (a == 1)
            continue;
        else
            cs += Data[a + 17];
    }
    cs = (cs >> 16) + (cs & 0xFFFF);
    return (uint16_t)(~cs);
}

void Request_ARP(void)
{
    uint16_t Buf[22];
    Buf[0]  = 0xFFFF;                   // MAC- 
    Buf[1]  = 0xFFFF;                   // MAC- 
    Buf[2]  = 0xFFFF;                   // MAC- 
    Buf[3]  = MDR_ETHERNET1->ETH_MAC_T; //  MAC-
    Buf[4]  = MDR_ETHERNET1->ETH_MAC_M; //  MAC-
    Buf[5]  = MDR_ETHERNET1->ETH_MAC_H; //  MAC-
    Buf[6]  = 0x0608;                   // type - ARP
    Buf[7]  = 0x0100;                   // Hardware type - Ethernet
    Buf[8]  = 0x0008;                   // Protocol type - IP
    Buf[9]  = 0x0406;                   // Hardware size - 6; Protocol size - 4
    Buf[10] = 0x0100;                   //   ARP
    Buf[11] = MDR_ETHERNET1->ETH_MAC_T; // Sender MAC-address
    Buf[12] = MDR_ETHERNET1->ETH_MAC_M; // Sender MAC-address
    Buf[13] = MDR_ETHERNET1->ETH_MAC_H; // Sender MAC-address
    Buf[14] = MyIPAddress[0];           // My_IP_Address[0];
    Buf[15] = MyIPAddress[1];           // My_IP_Address[1];
    Buf[16] = 0x0000;                   // Target MAC-address
    Buf[17] = 0x0000;                   // Target MAC-address
    Buf[18] = 0x0000;                   // Target MAC-address
    Buf[19] = RemoteIPAddress[0];       // Target IP-address
    Buf[20] = RemoteIPAddress[1];       // Target IP-address
    Buf[21] = 0;

    SendPacket(Buf, 42);
}

void Request_ICMP(void)
{
    uint16_t Buf[37];
    uint8_t  tmp[2];
    uint32_t i, j;

    //---- Eth2 ----
    Buf[0] = Remote_MAC.RmtMAC[0];     // MAC- 
    Buf[1] = Remote_MAC.RmtMAC[1];     // MAC- 
    Buf[2] = Remote_MAC.RmtMAC[2];     // MAC- 
    Buf[3] = MDR_ETHERNET1->ETH_MAC_T; //  MAC-
    Buf[4] = MDR_ETHERNET1->ETH_MAC_M; //  MAC-
    Buf[5] = MDR_ETHERNET1->ETH_MAC_H; //  MAC-
    Buf[6] = 0x0008;                   // type - IP
    //---- IP ----
    Buf[7]  = 0x0045;              // Version 4, length 20 bytes, Differentiated Services Field 0x00
    Buf[8]  = 0x3C00;              // Total length 60 bytes
    Buf[9]  = Identification;      // Identification
    Buf[10] = 0x0000;              // Flag = 0x00, Fragment offset = 0x00
    Buf[11] = 0x0180;              // Time To Live = 0x80, Protocol = 0x01 - ICMP
    Buf[12] = 0x0000;              // Checksum IP
    Buf[13] = MyIPAddress[0];      // Source IP-address[0]
    Buf[14] = MyIPAddress[1];      // Source IP-address[1]
    Buf[15] = Remote_MAC.RmtIP[0]; // Destination IP-address[0]
    Buf[16] = Remote_MAC.RmtIP[1]; // Destination IP-address[1]
    Buf[12] = CheckSum_IP(Buf);
    //---- ICMP ----
    Buf[17] = 0x0008;         // Type 0x08 (Echo (ping) request), Code 0x00
    Buf[18] = 0x0000;         // Checksum ICMP
    Buf[19] = 0x0002;         // Identifier
    Buf[20] = SequenceNumber; // Sequence Number

    for (i = 0, j = 0; i < 32; i += 2, j++) {
        tmp[0] = 0x61 + i;
        tmp[1] = 0x62 + i;

        Buf[j + 21] = (tmp[1] << 8) | (tmp[0]);
    }
    Buf[18] = CheckSum_ICMP(20, Buf);
    SendPacket(Buf, 74);

    tmp[0] = (Identification >> 8);
    tmp[1] = Identification;
    if (++tmp[0] == 0)
        tmp[1]++;
    Identification = (tmp[0] << 8) | tmp[1];

    tmp[0] = (SequenceNumber >> 8);
    tmp[1] = SequenceNumber;
    if (++tmp[0] == 0)
        tmp[1]++;
    SequenceNumber = (tmp[0] << 8) | tmp[1];
}

void RemoteMacInit(void)
{
    Remote_MAC.RmtMAC[0] = 0;
    Remote_MAC.RmtMAC[1] = 0;
    Remote_MAC.RmtMAC[2] = 0;

    Remote_MAC.RmtIP[0] = 0;
    Remote_MAC.RmtIP[1] = 0;

    Remote_MAC.hasMAC = 0;
}
