#include <sysreg.h>
void Delay(int waitTicks);

__attribute((interrupt))
void INT(void)
{
	 __builtin_sysreg_write(__FLAGREGST, 0x04); // FLAG2 ON
	 Delay (500000);
	 __builtin_sysreg_write(__FLAGREGCL, 0x00); // FLAGx OFF

	 __builtin_sysreg_write(__FLAGREGST, 0x08); // FLAG3 ON
	 Delay (500000);
	 __builtin_sysreg_write(__FLAGREGCL, 0x00); // FLAGx OFF
}

int main(void)
{
	__builtin_sysreg_write(__IVIRQ0, (int) INT); // Установить адрес функции прерывания
	__builtin_sysreg_write(__SQCTLST, 4);        // Включить глобальные прерывания
	__builtin_sysreg_write(__IMASKH, 1<<9);      // Разрешить прерывание по внешнему выводу IRQ0

   while(1)
   {
     __builtin_sysreg_write(__FLAGREGST, 0x01); // FLAG0 ON
     Delay (500000);
     __builtin_sysreg_write(__FLAGREGCL, 0x00); // FLAGx OFF

     __builtin_sysreg_write(__FLAGREGST, 0x02); // FLAG1 ON
     Delay (500000);
     __builtin_sysreg_write(__FLAGREGCL, 0x00); // FLAGx OFF
   }
}

// Функция задержки
void Delay(int waitTicks)
{
  int i;
  for (i = 0; i < waitTicks; i++);
}
