
#ifndef __CONFIG_C
#define __CONFIG_C

#include "MDR32F9Qx_config.h"
#include "config.h"

//--- Clock configuration ---
void ClkConfig()
{
#ifdef REVISION_2

#ifdef HSE2_GEN
    MDR_RST_CLK->HS_CONTROL = 0x0000000D; // HSE - On, Oscillator mode; HSE2 - On, Generator mode
#else
    MDR_RST_CLK->HS_CONTROL = 0x00000005; // HSE - On, Oscillator mode; HSE2 - On, Oscillator mode
#endif // HSE2_GEN

    while ((MDR_RST_CLK->CLOCK_STATUS & 0x0C) != 0x0C)
        ;                                // Wait until HSE and HSE2 not ready
    MDR_RST_CLK->CPU_CLOCK = 0x00000002; // CPU_C1 = HSE = 8 MHz

    MDR_RST_CLK->PLL_CONTROL = (11 << 8) | (1 << 2); // PLL CPU On, PLL_MULL = 11;
    while ((MDR_RST_CLK->CLOCK_STATUS & 0x02) != 0x02)
        ;                              // wait until PLL CPU not ready
    MDR_RST_CLK->PER_CLOCK |= 0x08;    // EEPROM_CTRL Clock enable
    MDR_EEPROM->CMD = 3 << 3;          // Delay = 3
    MDR_RST_CLK->PER_CLOCK &= (~0x08); // EEPROM_CTRL Clock disable

    MDR_RST_CLK->CPU_CLOCK |= 0x00000106;                       // CPU Clock = 12*8 MHz = 96 MHz
    MDR_RST_CLK->ETH_CLOCK = (3 << 28) | (1 << 27) | (1 << 24); // PHY_CLK_SEL = HSE2, ETH_CLK_EN=1, PHY_CLK_EN=1
#else
    MDR_RST_CLK->HS_CONTROL = 0x00000003; // HSE - On; Gen mode On
    while ((MDR_RST_CLK->CLOCK_STATUS & 0x04) != 0x04)
        ;                                // Wait until HSE not ready
    MDR_RST_CLK->CPU_CLOCK = 0x00000003; // HSE/2 = 12.5 MHz

    MDR_RST_CLK->PLL_CONTROL = (7 << 8) | (1 << 2); // PLL CPU On;
    while ((MDR_RST_CLK->CLOCK_STATUS & 0x02) != 0x02)
        ;                              // wait until PLL CPU not ready
    MDR_RST_CLK->PER_CLOCK |= 0x08;    // EEPROM_CTRL Clock enable
    MDR_EEPROM->CMD = 4 << 3;          // Delay = 4
    MDR_RST_CLK->PER_CLOCK &= (~0x08); // EEPROM_CTRL Clock disable

    MDR_RST_CLK->CPU_CLOCK |= 0x00000107;                       // CPU Clock = 8*12.5MHz = 100 MHz
    MDR_RST_CLK->ETH_CLOCK = (1 << 24) | (1 << 28) | (1 << 27); // PHY_CLK_SEL = HSE, ETH_CLK_EN=1, PHY_CLK_EN=1, ETH_CLK = 25MHz
#endif // REVISION_2

    MDR_RST_CLK->PER_CLOCK |= (1 << 24) | (1 << 22) | (1 << 23); // Enable clock for PORTD, PORTC and PORTB
}

//--- Ports configuration ---
void PortConfig()
{
    // PORTC_7 - FXEN, PORTC_8 - FTX
    MDR_PORTC->FUNC   = 0x003C000;
    MDR_PORTC->ANALOG = 0x0180;
    MDR_PORTC->PWR    = 0x003C000;

    // PORTD_11 - FRX, PORTD_15 - FSD
    MDR_PORTD->FUNC   = 0xC0C00000;
    MDR_PORTD->ANALOG = 0xFFFF;
    MDR_PORTD->RXTX   = 0;
    MDR_PORTD->OE |= 0x7780;
    MDR_PORTD->PWR |= 0xFFFFC000;

    MDR_PORTB->FUNC   = 0x00;
    MDR_PORTB->ANALOG = 0x3 << 14;
    MDR_PORTB->RXTX   = 0;
    MDR_PORTB->OE |= 0x3 << 14;
    MDR_PORTB->PWR |= 0xF << 28;
}

#endif //__CONFIG_C
