
#ifndef __ETHFUNC_C
#define __ETHFUNC_C

#include "MDR32F9Qx_config.h"
#include "config.h"
#include "ethfunc.h"

extern const uint16_t MyMAC[3];       // MAC- 
extern const uint16_t MyIPAddress[2]; // IP-  ( IP-): 192.168.1.65
/*-----------------------------------------------------
*------------------------------------------------------
*------------------------------------------------------
*---------------   PHY ---------------
*------------------------------------------------------
*------------------------------------------------------
------------------------------------------------------*/

//***    PHY   MDIO  ***
// Addr -   PHY
// Mode -    PHY
void PHYInit(uint8_t Addr)
{
    uint32_t tmp;

    tmp = MDR_ETHERNET1->PHY_Control;
    tmp &= 0x0770; //    PHY,    ,  FiberOptic

    //	  PHY address|FX  On|100Mb/s|PHY Enable
    tmp |= (Addr << 11) | (1 << 7) | (3 << 1) | 1;

    MDR_ETHERNET1->PHY_Control = tmp;
    while ((MDR_ETHERNET1->PHY_Status & 0x10) == 0)
        ; //      
}

//***     PHY   MDIO  ***
// Addr	-   PHY
// Num	-  ,    
// Data	-   
void SetPHYReg(uint8_t Addr, uint8_t Num, uint16_t Data)
{
    uint32_t i;
    MDR_ETHERNET1->ETH_MDIO_DATA = Data;
    i                            = 0xC000 | ((Addr & 0x1F) << 8) | (Num & 0x1F) | (0x01 << 5);
    MDR_ETHERNET1->ETH_MDIO_CTRL = (uint16_t)i;
    while ((MDR_ETHERNET1->ETH_MDIO_CTRL & 0x8000) == 0)
        ;
}

//***     PHY   MDIO  ***
// Addr	-   PHY
// Num	-  ,   
//      Num  Addr  PHY.
uint16_t GetPHYReg(uint8_t Addr, uint8_t Num)
{
    uint32_t i;
    i                            = 0xE000 | ((Addr & 0x1F) << 8) | (0x1 << 5) | (Num & 0x1F);
    MDR_ETHERNET1->ETH_MDIO_CTRL = (uint16_t)i;
    while ((MDR_ETHERNET1->ETH_MDIO_CTRL & 0x8000) == 0)
        ;
    return MDR_ETHERNET1->ETH_MDIO_DATA;
}

/*-----------------------------------------------------
*------------------------------------------------------
*------------------------------------------------------
*---------------   MAC ---------------
*------------------------------------------------------
*------------------------------------------------------
-----------------------------------------------------*/

//***    MAC  ***
void EthernetConfig()
{
    PHYInit(0x1C); // PHY address 0x1C, Mode 100BaseT_Full_Duplex

    MDR_ETHERNET1->ETH_MAC_T = MyMAC[0];
    MDR_ETHERNET1->ETH_MAC_M = MyMAC[1];
    MDR_ETHERNET1->ETH_MAC_H = MyMAC[2];

    MACReset();
    MDR_ETHERNET1->ETH_IMR = 0x0001; //      
}

//***    MAC      ***
void MACReset()
{
    MDR_ETHERNET1->ETH_G_CFGl |= 0x00030000; // RRST=1, XRST=1    

    ClearMemory();

    MDR_ETHERNET1->ETH_Dilimiter = 0x1000; // 4096   , 4096   

    MDR_ETHERNET1->ETH_HASH0 = 0;
    MDR_ETHERNET1->ETH_HASH1 = 0;
    MDR_ETHERNET1->ETH_HASH2 = 0;
    MDR_ETHERNET1->ETH_HASH3 = 0x8000;

    MDR_ETHERNET1->ETH_IPG       = 0x0060;
    MDR_ETHERNET1->ETH_PSC       = 0x0050;
    MDR_ETHERNET1->ETH_BAG       = 0x0200;
    MDR_ETHERNET1->ETH_JitterWnd = 0x0005;
    MDR_ETHERNET1->ETH_R_CFG     = 0x8406; //     MAC-
    MDR_ETHERNET1->ETH_X_CFG     = 0x81FA;

    MDR_ETHERNET1->ETH_G_CFGl = 0x30030080; //    .

    MDR_ETHERNET1->ETH_IMR = 0;
    MDR_ETHERNET1->ETH_IFR = 0xFFFF;

    MDR_ETHERNET1->ETH_R_Head = 0x0000;
    MDR_ETHERNET1->ETH_X_Tail = 0x1000;

    MDR_ETHERNET1->ETH_G_CFGl &= 0xFFFCBFFF; // RRST=0, XRST=0   
}

//***        MAC  ***
//   4096 
//   4096 
void ClearMemory()
{
    uint32_t  Temp;
    uint32_t* ptr;
    ptr = (uint32_t*)0x38000000;
    for (Temp = 0; Temp < 2048; Temp++)
        *ptr++ = 0;
}

/*---------------------------------------------------------------------------------------------------
*---------------          MAC ---------------
---------------------------------------------------------------------------------------------------*/

//***        ***
//*** *Frame -    
uint32_t ReadPacket(_Rec_Frame* Frame)
{
    uint16_t  space_start = 0, space_end = 0, tail, head;
    uint16_t  tmp[2];
    uint32_t *src, *dst;
    uint32_t  size, i;

    tail = MDR_ETHERNET1->ETH_R_Tail;
    head = MDR_ETHERNET1->ETH_R_Head;

    if (tail > head) {
        space_end   = tail - head;
        space_start = 0;
    } else {
        space_end   = 0x1000 - head;
        space_start = tail;
    }

    src = (uint32_t*)(0x38000000 + head);
    dst = (uint32_t*)(Frame->Data);

    *((uint32_t*)tmp) = *src++; //  -    
    space_end -= 4;
    if ((uint16_t)src > 0xFFF)
        src = (uint32_t*)0x38000000;

    size = (tmp[0] + 3) / 4;
    if (tmp[0] <= space_end) {
        for (i = 0; i < size; i++)
            *dst++ = *src++;
    } else {
        size = size - space_end / 4;
        for (i = 0; i < (space_end / 4); i++)
            *dst++ = *src++;
        src = (uint32_t*)0x38000000;
        for (i = 0; i < size; i++)
            *dst++ = *src++;
    }
    if ((uint16_t)src > 0xFFF)
        src = (uint32_t*)0x38000000;

    MDR_ETHERNET1->ETH_R_Head = (uint16_t)src;
    MDR_ETHERNET1->ETH_STAT -= 0x20;
    return tmp[0];
}

//***        ***
//*** *buffer -    
//*** size - -  
int SendPacket(void* buffer, int size)
{
    uint16_t  i;
    uint32_t  tmp, head, tail;
    uint32_t *src, *dst;
    uint16_t  space[2];

    head = MDR_ETHERNET1->ETH_X_Head;
    tail = MDR_ETHERNET1->ETH_X_Tail;

    //  -     
    if (head > tail) {
        space[0] = head - tail;
        space[1] = 0;
    } else {
        space[0] = 0x2000 - tail;
        space[1] = head - 0x1000;
    }
    //  -     

    if (size > (space[0] + space[1] - 8))
        return 0; //-8,   4       4     

    tmp = size;
    src = buffer;
    dst = (uint32_t*)(0x38000000 + tail);

    *dst++ = tmp;
    space[0] -= 4;
    if ((uint16_t)dst > 0x1FFC)
        dst = (uint32_t*)0x38001000;

    tmp = (size + 3) / 4;

    if (size <= space[0]) {
        for (i = 0; i < tmp; i++)
            *dst++ = *src++;
    } else {
        tmp -= space[0] / 4;
        for (i = 0; i < (space[0] / 4); i++)
            *dst++ = *src++;
        dst = (uint32_t*)0x38001000;
        for (i = 0; i < tmp; i++)
            *dst++ = *src++;
    }
    if ((uint16_t)dst > 0x1FFC)
        dst = (uint32_t*)0x38001000;
    tmp    = 0;
    *dst++ = tmp;
    if ((uint16_t)dst > 0x1FFC)
        dst = (uint32_t*)0x38001000;

    MDR_ETHERNET1->ETH_X_Tail = (uint16_t)dst;
    return size;
}

#endif //__ETHFUNC_C
