
#include "MDR32F9Qx_config.h"
#include "config.h"
#include "ethfunc.h"

const uint16_t MyMAC[3]       = { 0x0500, 0x1745, 0xBC9A }; // MAC- 
const uint16_t MyIPAddress[2] = { 0xA8C0, 0x4101 };         // IP-  ( IP-): 192.168.1.65
_Rec_Frame     Frame;
uint32_t       ReplyICMPCounter = 0;

void     Answear_ARP(void);
void     PacketAnaliser(void);
uint16_t CheckSum_IP(uint16_t*);
uint16_t CheckSum_ICMP(uint16_t, uint16_t*);
void     Answear_ICMP(void);

int main()
{
    ClkConfig();
    PortConfig();
    EthernetConfig();
    NVIC_EnableIRQ(ETHERNET_IRQn);
    while (1) {
        if ((MDR_ETHERNET1->PHY_Status & 0x02) == 0x00)
            MDR_PORTB->SETTX = 1 << 15; //   LINK
        else
            MDR_PORTB->CLRTX = 1 << 15;

        if ((MDR_ETHERNET1->PHY_Status & 0x08) == 0x00)
            MDR_PORTB->SETTX = 1 << 14; // Full Duplex Mode
        else
            MDR_PORTB->CLRTX = 1 << 14;

        MDR_PORTD->RXTX = ReplyICMPCounter << 7;
    }
}

void ETHERNET_IRQHandler()
{
    uint16_t Status;

    Status                 = MDR_ETHERNET1->ETH_IFR;
    MDR_ETHERNET1->ETH_IFR = Status;
    Status &= 0x101;

    MDR_PORTD->SETTX = 1 << 7;

    if ((Status & 0x01) == 0x01) {
        Frame.Counter = ReadPacket(&Frame);
        PacketAnaliser();
    }
    MDR_PORTD->CLRTX = 1 << 7;
}

//***    
void PacketAnaliser(void)
{
    switch (Frame.Data[6]) //    
    {
        case 0x0008:                                                                      //  IP
            if ((Frame.Data[15] == MyIPAddress[0]) && (Frame.Data[16] == MyIPAddress[1])) //  IP     
            {                                                                             //   ,     ,
                if (CheckSum_IP(Frame.Data) == Frame.Data[12])                            //       , 
                {                                                                         //  -  
                    //--------------------ICMP-------------------
                    if ((Frame.Data[11] & 0xFF00) == 0x0100) //   : ICMP
                    {
                        if (Frame.Data[17] == 0x0008) //   - Echo (ping) request
                            Answear_ICMP();           //     Echo (ping) request
                        ReplyICMPCounter++;
                    }
                }
                //-------------------------------------------
            }
            break;

        case 0x0608:                                                                      //  ARP
            if ((Frame.Data[19] == MyIPAddress[0]) && (Frame.Data[20] == MyIPAddress[1])) //  IP     
            {                                                                             //   ,     ,
                MDR_PORTD->SETTX = 4 << 7;
                Answear_ARP(); //    ARP-
            }
            break;
    }
}

//***     ARP-
void Answear_ARP(void)
{
    uint16_t Buf[22];
    Buf[0]  = Frame.Data[3];            // MAC- 
    Buf[1]  = Frame.Data[4];            // MAC- 
    Buf[2]  = Frame.Data[5];            // MAC- 
    Buf[3]  = MDR_ETHERNET1->ETH_MAC_T; //  MAC-
    Buf[4]  = MDR_ETHERNET1->ETH_MAC_M; //  MAC-
    Buf[5]  = MDR_ETHERNET1->ETH_MAC_H; //  MAC-
    Buf[6]  = Frame.Data[6];            // type - ARP
    Buf[7]  = Frame.Data[7];            // Hardware type - Ethernet
    Buf[8]  = Frame.Data[8];            // Protocol type - IP
    Buf[9]  = Frame.Data[9];            // Hardware size - 6; Protocol size - 4
    Buf[10] = 0x0200;                   //     Who has...
    Buf[11] = MDR_ETHERNET1->ETH_MAC_T; // Sender MAC-address: 	00.05.69.23.154.188
    Buf[12] = MDR_ETHERNET1->ETH_MAC_M; // Sender MAC-address: 	00.05.69.23.154.188
    Buf[13] = MDR_ETHERNET1->ETH_MAC_H; // Sender MAC-address: 	00.05.69.23.154.188
    Buf[14] = MyIPAddress[0];           // My_IP_Address[0]:		192.168.1.65
    Buf[15] = MyIPAddress[1];           // My_IP_Address[1]:		192.168.1.65
    Buf[16] = Frame.Data[3];            // Target MAC-address
    Buf[17] = Frame.Data[4];            // Target MAC-address
    Buf[18] = Frame.Data[5];            // Target MAC-address
    Buf[19] = Frame.Data[14];           // Target IP-address
    Buf[20] = Frame.Data[15];           // Target IP-address
    Buf[21] = 0;

    SendPacket(Buf, 42);
}

//***       IP-
uint16_t CheckSum_IP(uint16_t* Data)
{
    unsigned long a, cs = 0;
    for (a = 0; a < 10; a++) {
        if (a == 5)
            continue;
        else
            cs = cs + Data[7 + a];
    }
    cs = (cs >> 16) + (cs & 0xFFFF);
    return (uint16_t)(~cs);
}

//***       ICMP-
//*** size - - ,      
uint16_t CheckSum_ICMP(uint16_t size, uint16_t* Data)
{
    unsigned long a, cs = 0;
    for (a = 0; a < size; a++) {
        if (a == 1)
            continue;
        else
            cs += Data[a + 17];
    }
    cs = (cs >> 16) + (cs & 0xFFFF);
    return (uint16_t)(~cs);
}

//***       ICMP
void Answear_ICMP(void)
{
    unsigned long a;
    uint16_t      buffer[288];
    uint16_t      tmp;

    // -   ICMP-
    tmp = Frame.Counter - 34 - 4; // 34  -  Eth2  IP , 4  -   Eth2 .
    if ((tmp & 0x01) == 1) {
        tmp                  = (tmp + 1) >> 1; //  -   - 
        Frame.Data[tmp + 16] = Frame.Data[tmp + 16] & 0x00FF;
    } else
        tmp = tmp >> 1; //  -   - 

    //-------Ethernet 2 Protocol---------
    buffer[0] = Frame.Data[3];
    buffer[1] = Frame.Data[4];
    buffer[2] = Frame.Data[5];

    buffer[3] = MDR_ETHERNET1->ETH_MAC_T;
    buffer[4] = MDR_ETHERNET1->ETH_MAC_M;
    buffer[5] = MDR_ETHERNET1->ETH_MAC_H;

    buffer[6] = Frame.Data[6];
    //-------IP Protocol---------
    for (a = 7; a < 12; a++) {
        buffer[a] = Frame.Data[a];
    }
    //---------------------------
    buffer[12] = CheckSum_IP(Frame.Data);
    buffer[13] = Frame.Data[15]; // IP->DestinAddr[0];
    buffer[14] = Frame.Data[16]; // IP->DestinAddr[1];
    buffer[15] = Frame.Data[13]; // IP->SourceAddr[0];
    buffer[16] = Frame.Data[14]; // IP->SourceAddr[1];
    //-------ICMP Protocol---------
    buffer[17]     = 0x0000; // 
    Frame.Data[17] = 0x0000;
    //-----------------------------
    buffer[18] = CheckSum_ICMP(tmp, Frame.Data);
    for (a = 19; a < ((tmp - 2) + 19); a++) {
        buffer[a] = Frame.Data[a];
    }
    SendPacket(buffer, (tmp * 2 + 34));
}
