#include <sysreg.h>
#include <defts201.h>
#include "hal_1967VN044.h"
#include "tlv320aic23b.h"
#include <stdint.h>

#define FREQ			8000

#define BUSCLK_KHZ		80000
#define CORECLK_KHZ		200000

int main()
{
	int i = 0;
	HAL_PLL_CoreSetup(CORECLK_KHZ);
	HAL_Interrupt_GlobalEnable();

	// Clock I2S enable
	LX_CMU->CFG8.b.I2S0_DIS = 0;
	// GPIO for FLAGREG
	HAL_GPIO_Init(LX_GPIO_PC, 0xF, GPIO_PinMode_Alt);

	vTlv320Init(FREQ);

	while(1) {
		__builtin_sysreg_write(__FLAGREGST, 0x0F);
		for(i = 0; i < 1000000; i++);

		__builtin_sysreg_write(__FLAGREGCL, 0x00);
		for(i = 0; i < 1000000; i++);
	}
}
