/*
 * spi_soft.c
 *
 *  Created on: 21 ����� 2017 �.
 *      Author: sharavyev.d
 */

#include "spi_soft.h"
#include <sysreg.h>

#define SPI_CLK_0									SPI_DRV_PORT->DR.CLR = SPI_CLK_PIN
#define SPI_CLK_1									SPI_DRV_PORT->DR.SET = SPI_CLK_PIN
#define SPI_DO_0									SPI_DRV_PORT->DR.CLR = SPI_DO_PIN
#define SPI_DO_1									SPI_DRV_PORT->DR.SET = SPI_DO_PIN
#define SPI_CS_0									SPI_DRV_PORT->DR.CLR = SPI_CS_PIN
#define SPI_CS_1									SPI_DRV_PORT->DR.SET = SPI_CS_PIN

static uint32_t ucCPOL;
static uint32_t ucCPHA;
static uint32_t ucLen;
static uint32_t ulDelayClk;


static void vSpiDelay( void );

void vSpiDrvInit( SPI_SOFT_type xSpiConfStr )
{
	ucCPOL = xSpiConfStr.ulCPOL;
	ucCPHA = xSpiConfStr.ulCPHA;
	ucLen = xSpiConfStr.ulDataLen;

	ulDelayClk = xSpiConfStr.ulClkFreq / ( 2 * xSpiConfStr.ulSpiFreq );								// ��������� ���������� ������ ���������� �� ���������� ����� SPI

	HAL_GPIO_Init ( SPI_DRV_PORT, SPI_CLK_PIN | SPI_DO_PIN | SPI_CS_PIN, GPIO_PinMode_Out );

	if( ucCPOL )
		SPI_CLK_1;
	else
		SPI_CLK_0;

	SPI_CS_1;
}

void vSpiDrvWriteData( void* pvData )
{
	uint32_t ucI;
	uint32_t usData;

	SPI_CS_0;
	vSpiDelay();

	usData = *( uint32_t* )pvData;
	for ( ucI = 0; ucI < ucLen; ucI++ )
	{
		if ( usData & ( 1 << ( ucLen - 1 ) ) )
			SPI_DO_1;
		else
			SPI_DO_0;

		usData <<= 1;

		if ( !ucCPHA ) vSpiDelay();
		if ( ucCPOL ) SPI_CLK_0; else SPI_CLK_1;
		vSpiDelay();
		if ( ucCPOL ) SPI_CLK_1; else SPI_CLK_0;
		if ( ucCPHA ) vSpiDelay();
	}

	vSpiDelay();
	SPI_CS_1;
	vSpiDelay();
}

void vSpiDelay( void )
{
	uint64_t ullStop = __read_ccnt();
	ullStop += ulDelayClk;

	while( ( ( ( uint64_t ) ( __read_ccnt() ) ) - ullStop ) & ( ( uint64_t ) 1 << 63 ) )
		;
}
