/*
 * spi_soft.h
 *
 *  Created on: 21  2017 .
 *      Author: sharavyev.d
 */

#ifndef __SPI_SOFT_H__
#define __SPI_SOFT_H__

#include "hal_gpio.h"
#include "def1967VN044.h"
#include <stdint.h>

/* -----------------------    SPI ---------------------- */
#define SPI_DRV_PORT								LX_GPIO_PA

#define SPI_CLK_PIN									GPIO_PIN_19
#define SPI_DO_PIN									GPIO_PIN_22
//#define SPI_DI_PIN									GPIO_PIN_23
#define SPI_CS_PIN									GPIO_PIN_20

/*
 *     CPOL   CPHA
 *    0      0      0
 *    1      0      1
 *    2      1      0
 *    3      1      1
 */
typedef struct
{
	uint32_t ulClkFreq;																				//     
	uint32_t ulSpiFreq;																				//  SPI
	uint32_t ulCPOL;																				//   CLK (0 - , 1 - )
	uint32_t ulCPHA;																				//    (0 - , 1 - )
	uint32_t ulDataLen;																				//   8/16 
}SPI_SOFT_type;

void vSpiDrvInit( SPI_SOFT_type xSpiConfStr );
void vSpiDrvWriteData( void* pvData );

#endif /* __SPI_SOFT_H__ */
