/*
 * tlv320aic23b.h
 *
 *  Created on: 21 ����� 2017 �.
 *      Author: sharavyev.d
 */

#ifndef __TLV320AIC23B_H__
#define __TLV320AIC23B_H__

#include "hal_1967VN044.h"
#include "spi_soft.h"

/* ------------------------------------------- ��������� ������ -------------------------------- */
#define SIN_FREQ                			8000
#define SIN_MAX                 			5000
#define SIN_AUDIO_FREQ          			32000
#define SIN_STEPS               			( SIN_AUDIO_FREQ / ( SIN_FREQ ) )

typedef enum
{
	CH_L = 0,
	CH_R,
	CH_LR
}TLV320_CHANNEL_type;

#define DATA_16B							0x00
#define DATA_20B							0x01
#define DATA_24B							0x02
#define DATA_32B							0x03

#define FORMAT_DSP							0x03													// DSP ������
#define FORMAT_I2S							0x02													// i2s ������
#define FORMAT_LJ							0x01													// ������������ ������ �� ������ ���� ������ ������
#define FORMAT_RJ							0x00													// ������������ ������ �� ������� ���� ������ ������

typedef struct
{
	union
	{
		uint8_t ucReg;
		struct
		{
			uint32_t FOR :2;																		// ������ ������
			uint32_t IWL :2;																		// ����� ������
			uint32_t LRP :1;																		// 0 - LRCIN 1 - ������ �����, 1 - LRCIN 0 - ������ �����
			uint32_t LRSWAP :1;																		// 1 - �������� ������� ������
			uint32_t MS :1;																			// 1 - ������
		}b;
	};
} TLV320_DIGFORMAT_type;


void vTlv320Init( uint32_t ulClkFreq );
void vTlv320SetLineVolume( uint8_t ucVolume, TLV320_CHANNEL_type eCh );
void vTlv320SetHeadphoneVolume( uint8_t ucVolume, TLV320_CHANNEL_type eCh );

#endif /* __TLV320AIC23B_H__ */
