#include <sysreg.h>
#include <hal_1967VN044.h>

void Delay(int waitTicks);

unsigned int *host_buf_ptr = (unsigned int *) 0x4FFFF;

void IRQ_Handler_HOST(void) __attribute__((interrupt))
{
	unsigned int *read_addr;
	read_addr = (unsigned int *) *host_buf_ptr;
	*host_buf_ptr = *read_addr;
}

int main(void)
{
   HAL_SYS_FlagEnable();

   __builtin_sysreg_write(__IVHOST, (int) IRQ_Handler_HOST); // Установить адрес функции прерывания
   __builtin_sysreg_write(__SQCTLST, 1<<2);                     // Включить глобальные прерывания
   __builtin_sysreg_write(__IMASKH, 1<<6);                      // Разрешить прерывание от HOST-интерфейса

   // Основной цикл
   while(1)
   {
     __builtin_sysreg_write(__FLAGREGST, 0x01); // зажигаем светодиод FLAG0
     Delay (500000);
     __builtin_sysreg_write(__FLAGREGCL, 0x00); // гасим светодиод FLAG0
     Delay (500000);
   }
}

//Функция задержки
void Delay(int waitTicks)
{
  int i;
  for (i = 0; i < waitTicks; i++);
}
