#include "hal_1967VN044.h"
#include "config.h"
#include "filter.h"
#include "analyze_adc_data.h"

void repack_adc_data_float(void *data_in, float *data_out, uint32_t count);
uint32_t FindMax( float *pfBuff, uint32_t usSize );

// Буфер c данными АЦП после перепаковки
float adc_result_buf[ADC_DATA_SIZE] __attribute__((aligned(ADC_DATA_SIZE*2*(32/__CHAR_BIT__))));

// Переменные для БПФ
complex_float adc_fft_buf[ADC_DATA_SIZE/2];
float adc_fft_spectrum[ADC_DATA_SIZE/2];
uint32_t MaxIndex;

__attribute__((section(".data2")))
static complex_float twidftab[(ADC_DATA_SIZE)/2];

// Вычисляет спектр сигнала и зажигает светодиоды, если входной сигнал имеет частоту 2 МГц, 4 МГц или 8 МГц
void analyze_adc_data(void *data_buf)
{
	static int twidtab_complete = 0;

	if(twidtab_complete == 0)
	{
		twidtab_complete = 1;
		// Сгенерировать таблицу вращения для БПФ
		twidfftf(twidftab, ADC_DATA_SIZE);
	}

	// Перепаковка данных от АЦП (переводит значения отсчётов в буфере данных в float)
	repack_adc_data_float(data_buf, adc_result_buf, ADC_DATA_SIZE);
	// Сгенерировать БПФ для последовательности действительных чисел, используя функцию rfft
	rfftf(adc_result_buf, adc_fft_buf, twidftab, 1, ADC_DATA_SIZE);
	// Сгенерировать нормированный спектр мощности
	rfftf_mag(adc_fft_buf, adc_fft_spectrum, ADC_DATA_SIZE);
	// Поиск наибольшего значения в спектре
	MaxIndex = FindMax( adc_fft_spectrum, ADC_DATA_SIZE/2 );

	if( MaxIndex == ( uint32_t )( ( float )INPUT_FREQ_1 * ADC_DATA_SIZE / SAMPLE_RATE_CLK + 0.5 ) )
		HAL_GPIO_WritePin(LX_GPIO_PC, GPIO_PIN_1, GPIO_PinState_Reset);
	else if( MaxIndex == ( uint32_t )( ( float )INPUT_FREQ_2 * ADC_DATA_SIZE / SAMPLE_RATE_CLK + 0.5 ) )
		HAL_GPIO_WritePin(LX_GPIO_PC, GPIO_PIN_2, GPIO_PinState_Reset);
	else if( MaxIndex == ( uint32_t )( ( float )INPUT_FREQ_3 * ADC_DATA_SIZE / SAMPLE_RATE_CLK + 0.5 ) )
		HAL_GPIO_WritePin(LX_GPIO_PC, GPIO_PIN_3, GPIO_PinState_Reset);
	else
	{
		HAL_GPIO_WritePin(LX_GPIO_PC, GPIO_PIN_1, GPIO_PinState_Set);
		HAL_GPIO_WritePin(LX_GPIO_PC, GPIO_PIN_2, GPIO_PinState_Set);
		HAL_GPIO_WritePin(LX_GPIO_PC, GPIO_PIN_3, GPIO_PinState_Set);
	}
}

// Функция перепаковки данных от АЦП: переводит полученные значения отсчётов в float
void repack_adc_data_float(void *data_in, float *data_out, uint32_t count)
{
#if (__CHAR_BIT__ == 32) // Каждое слово данных (32 бита) содержит 2 отсчета АЦП
	uint32_t temp;
	int32_t s[2];
	uint32_t *data_in_u32 = (uint32_t *)data_in;

	while(count)
	{
		temp = *data_in_u32++;

		// Получение двух отсчетов от АЦП из одного слова
		s[0] = temp & 0xFFFF;
		s[1] = temp >> 16;

		// Определение знака новых отсчетов
		s[0] |= (s[0] & 0x8000) ? 0xFFFF0000 : 0;
		s[1] |= (s[1] & 0x8000) ? 0xFFFF0000 : 0;

		// Запись результата в data_out
		*data_out++ = (float) s[0];
		*data_out++ = (float) s[1];

		count -= 2;
	}
#elif (__CHAR_BIT__ == 8) // Каждое полуслово данных (16 бит) содержит 1 отсчет АЦП
	int16_t *data_in_i16 = (int16_t *)data_in;

	while(count)
	{
		// Запись результата в data_out
		*data_out++ = (float) *data_in_i16++;

		count--;
	}
#endif
}

// Поиск наибольшего значения в массиве pfBuff
uint32_t FindMax( float *pfBuff, uint32_t usSize )
{
	uint32_t usI, usY = 0;
	float fMax = 0;

	pfBuff++;
	for( usI = 1; usI < usSize; usI++ )
	{
		if( fMax < *pfBuff )
		{
			fMax = *pfBuff;
			usY = usI;
		}
		pfBuff++;
	}
	return usY;
}
