#include "hal_1967VN044.h"
#include "5101HB015.h"
#include "5101HB015_SPI_1967VN044.h"
#include "config.h"
#include "init.h"

void flush_link0_rxbuf(void);

// Буфер для записи конфигурации TCB
static uint32_t link_dma_rx_tcb[4] __attribute__((aligned(4*(32/__CHAR_BIT__))));
// Буфер c данными АЦП (каждое квадрослово данных (128 бит) содержит 8 отсчётов АЦП)
extern __builtin_quad adc_dma_buf[ADC_DMA_BUF_SIZE];
// Флаг готовности данных АЦП
extern uint32_t adc_dma_done;


// Инициализация процессора
void cpu_init(void)
{
	// Инициализация pll: установка частоты ядра и внешней шины
	HAL_PLL_CoreSetup(CCLK_HZ/1000);
	HAL_PLL_BusSetup(SCLK_HZ/1000);

	// Разрешение тактирования всей периферии
	LX_CMU->CFG8.word = 0;

	// Разрешение глобальных прерываний
	HAL_Interrupt_IMASKClear();
	HAL_Interrupt_ILATClear();
	HAL_Interrupt_GlobalEnable();
}


// Инициализация светодиодов
void leds_port_init(void)
{
	HAL_GPIO_Init (LX_GPIO_PC, GPIO_PIN_0 | GPIO_PIN_1 | GPIO_PIN_2 | GPIO_PIN_3, GPIO_PinMode_Out);
	HAL_GPIO_WritePins (LX_GPIO_PC, GPIO_PIN_0 | GPIO_PIN_1 | GPIO_PIN_2 | GPIO_PIN_3, 0xF); // Выключить светодиоды
}


// Инициализация АЦП 5101НВ015 по SPI
void adc_init(void)
{
	ADC5101HB015_config_t adc_cfg; 			// Структура для записи конфигурации АЦП
	ADC5101HB015_hw_config_t adc_spi_cfg; 	// Структура для настройки SPI АЦП

	// Задание выводов SPI интерфейса АЦП
	adc_spi_cfg.port = LX_GPIO_PA;
	adc_spi_cfg.cs_bit = GPIO_PIN_9;	// nCS
	adc_spi_cfg.clk_bit = GPIO_PIN_12;	// OEN (SCLK)
	adc_spi_cfg.mosi_bit = GPIO_PIN_11;	// CLARUN (SPIin)
	adc_spi_cfg.miso_bit = GPIO_PIN_10;	// OVFL (SPIout)
	adc_spi_cfg.core_freq_khz = PLL_Freq.CoreClk;

	// Задание значений регистров АЦП
	adc_cfg.reference_level = ADC5101HB015_REF_1P0;
	adc_cfg.output_format = ADC5101HB015_OUTPUT_LVDS;
	adc_cfg.lvdsen_pin_state = ADC5101HB015_LVDSEN_PIN_HIGH;
	adc_cfg.lvds_current_mode = ADC5101HB015_LVDS_CURRENT_NORMAL;
	adc_cfg.common_mode_sel = ADC5101HB015_COMMON_MODE_0P75;

	// Инициализация АЦП (сброс, калибровка, отправка конфигурации регистров по SPI, разрешение работы выходов OEN = 1)
	ADC5101HB015_init(ADC5101HB015_DO_RESET, ADC5101HB015_DO_CALIBRATION, &adc_spi_cfg);
	ADC5101HB015_config(&adc_cfg);
}


// Инициализация LINK-интерфейса для работы с АЦП
void link_dma_init(void)
{
	LinkRx_Init_type link_adc_ini_str; 	// Структура для инициализации приемника LINK порта
    LinkRxEx_type  link_rx_ini_str; 	// Структура для описания внешнего устройства с LINK интерфейсом (от кого принимаем)

	// Деинициализация приемника LINK порта 0
	HAL_LinkRx_Disable(ADC_LINK_NUM);

	// Установка параметров работы приемника LINK порта 0
	link_adc_ini_str.DataSize = Link_DataSize_8bit;
	link_adc_ini_str.CheckBCMPI = Link_CheckBCMP_Dis;
	link_adc_ini_str.CheckSum = Link_CheckSum_Dis;
	link_adc_ini_str.OVRIntEn = Link_OvrIT_Dis;
	link_adc_ini_str.TOIntEn = Link_TOIT_Dis;

	link_rx_ini_str.AdcDataSize = Link_AdcDataSize_12b;
	link_rx_ini_str.Rcode = Link_Rcode_En;
	link_rx_ini_str.BitOrder = Link_BitOrder_EvenFrontOddCut;
	link_rx_ini_str.GpsClk = Link_GpsClk_Dis;
	link_rx_ini_str.RxDest = Link_RxDest_Buff;

	// Инициализация приемника LINK порта 0
	HAL_LinkRx_Enable(ADC_LINK_NUM, &link_adc_ini_str,  &link_rx_ini_str);

	// Конфигурация регистра TCB DMA
	link_dma_rx_tcb[0] = (uint32_t) &adc_dma_buf;
	link_dma_rx_tcb[1] = ((ADC_DMA_BUF_SIZE*4) << 16) | 4;
	link_dma_rx_tcb[2] = 0;
	link_dma_rx_tcb[3] = TCB_INTMEM | TCB_QUAD | TCB_INT;

	// Разрешение прерывания от канала DMA 8 (LINK 0), передача указателя на функцию обработчик прерывания
	HAL_Interrupt_Enable(intDMA8, DMA_LINK_RX_Handler);

	// Запуск работы DMA
	HAL_LinkDMA_Receive(ADC_LINK_NUM, link_dma_rx_tcb);
}

// Запуск приёма данных от LINK порта 0 с помощью DMA
void link0_dma_receive_start(void)
{
	// Очистка буфера приёмника LINK порта 0
	flush_link0_rxbuf();
	// Запуск работы DMA
	HAL_LinkDMA_Receive(0, link_dma_rx_tcb);
}


// Очистка буфера приёмника LINK порта 0
void flush_link0_rxbuf(void)
{
	uint32_t ulLinkStat;
	__builtin_quad qData;

	ulLinkStat = __builtin_sysreg_read( __LRSTAT0 );

	while( ulLinkStat & 0x1 ) // Пока в буфере приемника есть данные
	{
			qData = __builtin_sysreg_read4( __LBUFRX0 );
			ulLinkStat = __builtin_sysreg_read( __LRSTAT0 );
	}
}
