#include "hal_1967VN044.h"
#include "config.h"
#include "init.h"
#include "analyze_adc_data.h"

// Буфер c данными АЦП (каждое квадрослово данных (128 бит) содержит 8 отсчётов АЦП)
__builtin_quad adc_dma_buf[ADC_DMA_BUF_SIZE];
// Флаг готовности данных АЦП
volatile uint32_t adc_dma_done;

// Обработчик прерывания DMA от LINK порта АЦП
__attribute__((interrupt))
void DMA_LINK_RX_Handler (void)
{
	if (!adc_dma_done) // Если флаг готовности был сброшен
	{
		adc_dma_done = 1; // Установка флага готовности данных АЦП
		HAL_GPIO_TogglePins (LX_GPIO_PC, GPIO_PIN_0); // Переключить состояние светодиода FLAG0
	}
}

int main()
{
	// Инициализация процессора
	cpu_init();
	// Инициализация светодиодов
	leds_port_init();
	// Инициализация АЦП по SPI
	adc_init();
	// Инициализация LINK порта и DMA
	link_dma_init();

	while(1)
	{
		if(adc_dma_done) // Если DMA завершил работу
		{
			adc_dma_done = 0;

			// Анализ полученных данных: если входной сигнал имеет частоту 2 МГц, 4 МГц или 8 МГц, то зажечь соответствующий светодиод FLAG1-3
			analyze_adc_data((void *)adc_dma_buf);

			// Запуск приёма данных от LINK порта 0 с помощью DMA
			link0_dma_receive_start();
		}
	}
}

