/**
 ******************************************************************************
 * @file    lcd_font_defs.h
 * @author  Milandr Application Team
 * @version V0.1.0
 * @date    15/10/2025
 * @brief   This file contains all the LCD fonts definition.
 ******************************************************************************
 * <br><br>
 *
 * THE PRESENT FIRMWARE IS FOR GUIDANCE ONLY. IT AIMS AT PROVIDING CUSTOMERS
 * WITH CODING INFORMATION REGARDING MILANDR'S PRODUCTS IN ORDER TO FACILITATE
 * THE USE AND SAVE TIME. MILANDR SHALL NOT BE HELD LIABLE FOR ANY
 * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES RESULTING
 * FROM THE CONTENT OF SUCH FIRMWARE AND/OR A USE MADE BY CUSTOMERS OF THE
 * CODING INFORMATION CONTAINED HEREIN IN THEIR PRODUCTS.
 *
 * <h2><center>&copy; COPYRIGHT 2025 Milandr</center></h2>
 ******************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef LCD_FONT_DEFS_H
#define LCD_FONT_DEFS_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include <stdint.h>

/** @addtogroup LCD_Driver LCD Driver
 * @{
 */

/** @addtogroup LCD_Font_Defs LCD Font Defs
 * @{
 */

/** @addtogroup LCD_Font_Exported_Types LCD Font Exported Types
 * @{
 */

/**
 * @brief  Font structure definition.
 */
typedef struct
{
    uint32_t       Height; /*!< Specifies the character height in pixels.          */
    uint32_t       Width;  /*!< Specifies the character width in pixels.           */
    uint32_t       Count;  /*!< Specifies the count of characters in the font - 1. */
    const uint8_t* pData;  /*!< Specifies the font table address.                  */
} LCD_Font;

/** @} */ /* End of group LCD_Font_Exported_Types */

/** @addtogroup LCD_Font_Exported_Variables LCD Font Exported Variables
 * @{
 */

extern LCD_Font Font_ASCII_6x8; /*!< Font 6x8 pixels. */

/** @} */ /* End of group LCD_Font_Exported_Variables */

/** @} */ /* End of group LCD_Font_Defs */

/** @} */ /* End of group LCD_Driver */

#ifdef __cplusplus
} // extern "C" block end
#endif

#endif /* LCD_FONT_DEFS_H */

/*********************** (C) COPYRIGHT 2025 Milandr ****************************
 *
 * END OF FILE lcd_font_defs.h */
