/**
 ******************************************************************************
 * @file    lcd_io_config.h
 * @author  Milandr Application Team
 * @version V0.1.0
 * @date    21/10/2025
 * @brief   LCD I/O configuration file.
 ******************************************************************************
 * <br><br>
 *
 * THE PRESENT FIRMWARE IS FOR GUIDANCE ONLY. IT AIMS AT PROVIDING CUSTOMERS
 * WITH CODING INFORMATION REGARDING MILANDR'S PRODUCTS IN ORDER TO FACILITATE
 * THE USE AND SAVE TIME. MILANDR SHALL NOT BE HELD LIABLE FOR ANY
 * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES RESULTING
 * FROM THE CONTENT OF SUCH FIRMWARE AND/OR A USE MADE BY CUSTOMERS OF THE
 * CODING INFORMATION CONTAINED HEREIN IN THEIR PRODUCTS.
 *
 * <h2><center>&copy; COPYRIGHT 2025 Milandr</center></h2>
 ******************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef LCD_IO_CONFIG_H_
#define LCD_IO_CONFIG_H_

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "MDR32VF0xI_rst_clk.h"
#include "MDR32VF0xI_port.h"

/** @addtogroup LCD_Driver LCD Driver
 * @{
 */

/** @addtogroup LCD_IO_Config LCD IO Config
 * @{
 */

/** @addtogroup LCD_IO_Exported_Defines LCD IO Exported Defines
 * @{
 */

/**
 * @brief LCD data port. The data pins must be consecutive without gaps.
 */
#define LCD_DATA_PORT       MDR_PORTB
#define LCD_DATA_PORT_CLK   RST_CLK_PCLK_PORTB
#define LCD_DATA_BUS_8_Pos  6
#define LCD_DATA_BUS_8_PINS (uint32_t)(PORT_PIN_6 | PORT_PIN_7 | PORT_PIN_8 | PORT_PIN_9 | \
                                       PORT_PIN_10 | PORT_PIN_11 | PORT_PIN_12 | PORT_PIN_13)

/**
 * @brief LCD crystals control. The crystals control pins must be consecutive without gaps.
 */
#define LCD_CRYSTAL_PORT     MDR_PORTB
#define LCD_CRYSTAL_PORT_CLK RST_CLK_PCLK_PORTB
#define LCD_CRYSTAL_Pos      4
#define LCD_CRYSTAL_PINS     (uint32_t)(PORT_PIN_4 | PORT_PIN_5)

/**
 * @brief LCD command/data switching.
 */
#define LCD_CMD_DATA_PORT     MDR_PORTB
#define LCD_CMD_DATA_PORT_CLK RST_CLK_PCLK_PORTB
#define LCD_CMD_DATA_PIN      (PORT_PIN_2)

/**
 * @brief LCD read/write switching.
 */
#define LCD_RD_WR_PORT     MDR_PORTB
#define LCD_RD_WR_PORT_CLK RST_CLK_PCLK_PORTB
#define LCD_RD_WR_PIN      (PORT_PIN_14)

/**
 * @brief LCD CLOCK signal control.
 */
#define LCD_CLOCK_PORT     MDR_PORTB
#define LCD_CLOCK_PORT_CLK RST_CLK_PCLK_PORTB
#define LCD_CLOCK_PIN      (PORT_PIN_3)

/**
 * @brief LCD RESET signal control.
 */
#define LCD_RESET_PORT     MDR_PORTA
#define LCD_RESET_PORT_CLK RST_CLK_PCLK_PORTA
#define LCD_RESET_PIN      (PORT_PIN_4)

/** @} */ /* End of the group LCD_IO_Exported_Defines */

/** @} */ /* End of the group LCD_IO_Config */

/** @} */ /* End of the group LCD_Driver */

#ifdef __cplusplus
} // extern "C" block end
#endif

#endif /* LCD_IO_CONFIG_H_ */

/*********************** (C) COPYRIGHT 2025 Milandr ****************************
 *
 * END OF FILE lcd_io_config.h */
