/**
 ******************************************************************************
 * @file    lcd_mdr_logo.h
 * @author  Milandr Application Team
 * @version V0.1.0
 * @date    15/10/2025
 * @brief   This file contains Milandr logo for the LCD driver.
 ******************************************************************************
 * <br><br>
 *
 * THE PRESENT FIRMWARE IS FOR GUIDANCE ONLY. IT AIMS AT PROVIDING CUSTOMERS
 * WITH CODING INFORMATION REGARDING MILANDR'S PRODUCTS IN ORDER TO FACILITATE
 * THE USE AND SAVE TIME. MILANDR SHALL NOT BE HELD LIABLE FOR ANY
 * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES RESULTING
 * FROM THE CONTENT OF SUCH FIRMWARE AND/OR A USE MADE BY CUSTOMERS OF THE
 * CODING INFORMATION CONTAINED HEREIN IN THEIR PRODUCTS.
 *
 * <h2><center>&copy; COPYRIGHT 2025 Milandr</center></h2>
 ******************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef LCD_MDR_LOGO_H
#define LCD_MDR_LOGO_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include <stdint.h>

/** @addtogroup LCD_MDR_Logo LCD MDR Logo
 * @{
 */

/** @addtogroup LCD_MDR_Logo_Exported_Defines LCD MDR Logo Exported Defines
 * @{
 */
#define LCD_MDR_LOGO_SIZE_X 112
#define LCD_MDR_LOGO_SIZE_Y 32

/** @} */ /* End of the group LCD_MDR_Logo_Exported_Defines */

/** @addtogroup LCD_MDR_Logo_Exported_Variables LCD MDR Logo Exported Variables
 * @{
 */
const uint8_t MilandrLogo[(LCD_MDR_LOGO_SIZE_X * LCD_MDR_LOGO_SIZE_Y) / 8] = {
    0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x0F, // Left side of logo 1.
    0x07, 0xC7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7,
    0x67, 0x27, 0x27, 0x67, 0xE7, 0xE7, 0xE7, 0xE7,
    0x67, 0x27, 0x27, 0x67, 0xE7, 0xE7, 0xC7, 0x07,
    0x0F, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xF8,
    0x80, 0xC0, 0x60, 0xC0, 0x80, 0xF8, 0x00, 0xF8,
    0x80, 0xC0, 0x60, 0xC0, 0x80, 0xF8, 0x00, 0xF8,

    0x80, 0xC0, 0x60, 0xC0, 0x80, 0xF8, 0x00, 0x00, // Right side of logo 1.
    0x00, 0xF8, 0x30, 0x60, 0x30, 0xF8, 0x00, 0xF8,
    0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0xE0, 0xB8,
    0x88, 0xB8, 0xE0, 0x00, 0xF8, 0x30, 0x60, 0xC0,
    0xF8, 0x00, 0xF8, 0x08, 0x98, 0xF0, 0x00, 0xF8,
    0x48, 0xC8, 0xB0, 0x00, 0x00, 0x00, 0xF8, 0x48,
    0xC8, 0xB0, 0x00, 0xF8, 0x80, 0x00, 0x00, 0xF8,

    0x60, 0x60, 0x60, 0x60, 0x7F, 0x7F, 0x7F, 0x00, // Left side of logo 2.
    0x00, 0x3F, 0x1F, 0x8F, 0xC7, 0xE3, 0xF1, 0xF8,
    0xFC, 0xFE, 0xF8, 0x00, 0x01, 0x0F, 0x83, 0xE0,
    0xF0, 0xFC, 0xFC, 0xC0, 0x01, 0x0F, 0x7F, 0x00,
    0x00, 0x7F, 0x7F, 0x7F, 0x60, 0x60, 0x60, 0x60,
    0x01, 0x00, 0xE0, 0xE0, 0xE1, 0xC0, 0x80, 0x80,
    0xC1, 0xE0, 0xE0, 0xE0, 0x01, 0x00, 0xE0, 0xE0,

    0x01, 0x00, 0x80, 0xC0, 0xE1, 0xE0, 0x00, 0x01, // Right side of logo 2.
    0x00, 0x81, 0xC0, 0xE0, 0x60, 0x61, 0xE0, 0xE1,
    0x00, 0x01, 0x01, 0x01, 0xC1, 0xE0, 0xE1, 0xC0,
    0x00, 0x00, 0x01, 0x00, 0xE1, 0xE0, 0x00, 0x00,
    0x01, 0x00, 0xE1, 0xE1, 0x01, 0x00, 0x00, 0x01,
    0x80, 0xC0, 0xE1, 0xE0, 0xE1, 0xE0, 0x01, 0x00,
    0x00, 0xE1, 0xE0, 0x60, 0x61, 0xE1, 0xC1, 0x81,

    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, // Left side of logo 3.
    0x00, 0x66, 0x67, 0x67, 0x67, 0x67, 0x67, 0x67,
    0x67, 0x67, 0x67, 0x66, 0x66, 0x67, 0x67, 0x67,
    0x67, 0x67, 0x67, 0x67, 0x66, 0x66, 0x66, 0x60,
    0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x00, 0x00, 0x7F, 0x7F, 0x00, 0x01, 0x07, 0x07,
    0x01, 0x00, 0x7F, 0x7F, 0x00, 0x00, 0x7F, 0x7F,

    0x0E, 0x07, 0x03, 0x01, 0x7F, 0x7F, 0x00, 0x00, // Right side of logo 3.
    0x7F, 0x7F, 0x01, 0x00, 0x00, 0x00, 0x7F, 0x7F,
    0x00, 0x00, 0x78, 0x7F, 0x07, 0x31, 0x31, 0x3F,
    0x7F, 0x78, 0x00, 0x00, 0x7F, 0x7F, 0x00, 0x06,
    0x06, 0x06, 0x7F, 0x7F, 0x00, 0x00, 0x60, 0x6F,
    0x6F, 0x63, 0x60, 0x60, 0x7F, 0x7F, 0x60, 0x00,
    0x00, 0x7F, 0x7F, 0x00, 0x0C, 0x0E, 0x07, 0x03,

    0x00, 0x00, 0x00, 0x00, 0xFE, 0xFE, 0xFE, 0xF0, // Left side of logo 4.
    0xE0, 0xE2, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6,
    0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6,
    0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE2, 0xE0,
    0xF0, 0xFE, 0xFE, 0xFE, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // Right side of logo 4.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/** @} */ /* End of the group LCD_MDR_Logo_Exported_Variables */

/** @} */ /* End of the group LCD_MDR_Logo */

#ifdef __cplusplus
} // extern "C" block end
#endif

#endif /* LCD_MDR_LOGO_H */

/*********************** (C) COPYRIGHT 2025 Milandr ****************************
 *
 * END OF FILE lcd_mdr_logo.h */
