/**
 ******************************************************************************
 * @file    stdio_uart.c
 * @author  Milandr Application Team
 * @version V0.1.0
 * @date    15/10/2025
 * @brief   STDIO retarget to UART.
 ******************************************************************************
 * <br><br>
 *
 * THE PRESENT FIRMWARE IS FOR GUIDANCE ONLY. IT AIMS AT PROVIDING CUSTOMERS
 * WITH CODING INFORMATION REGARDING MILANDR'S PRODUCTS IN ORDER TO FACILITATE
 * THE USE AND SAVE TIME. MILANDR SHALL NOT BE HELD LIABLE FOR ANY
 * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES RESULTING
 * FROM THE CONTENT OF SUCH FIRMWARE AND/OR A USE MADE BY CUSTOMERS OF THE
 * CODING INFORMATION CONTAINED HEREIN IN THEIR PRODUCTS.
 *
 * <h2><center>&copy; COPYRIGHT 2025 Milandr</center></h2>
 ******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MDR32VF0xI_port.h"
#include "MDR32VF0xI_rst_clk.h"
#include "MDR32VF0xI_uart.h"

#include "stdio_uart.h"
#include <stdio.h>

/** @addtogroup STDIO_UART STDIO UART
 * @{
 */

/** @addtogroup STDIO_UART_Private_Function Prototypes STDIO UART Private Function Prototypes
 * @{
 */
static void UART_Config(void);
static void UART_PinConfig(void);

/** @} */ /* End of the group STDIO_UART_Private_Function */

/** @addtogroup STDIO_UART_Exported_Functions STDIO UART Exported Functions
 * @{
 */
void STDIO_UART_Init(void)
{
    UART_Config();
    UART_PinConfig();
    UART_Cmd(STDIO_UART, ENABLE);
}

/** @} */ /* End of the group STDIO_UART_Exported_Functions */

/** @addtogroup STDIO_UART_Private_Functions STDIO UART Private Functions
 * @{
 */
static void UART_Config(void)
{
    static const UART_InitTypeDef UART_TxRx = {
        .UART_BaudRate            = STDIO_UART_BAUD,
        .UART_Mode                = UART_MODE_TX_RX,
        .UART_WordLength          = STDIO_UART_WORD,
        .UART_StopBits            = STDIO_UART_STOP_BITS,
        .UART_Parity              = STDIO_UART_PARITY,
        .UART_HardwareFlowControl = UART_HARDWARE_FLOW_CONTROL_NONE,
        .UART_LoopbackMode        = UART_LOOPBACK_DISABLE,

        .UART_FIFO_Mode        = UART_FIFO_MODE_ENABLE,
        .UART_FIFO_TxThreshold = UART_FIFO_TX_THRESHOLD_2WORD,
        .UART_FIFO_RxThreshold = UART_FIFO_RX_THRESHOLD_2WORD,

        .UART_IRDA_Mode      = UART_IRDA_MODE_DISABLE,
        .UART_IRDA_PowerMode = UART_IRDA_POWER_NORMAL,
    };

    RST_CLK_PER1_C2_SetPrescaler(STDIO_UART_PER1_C2, RST_CLK_PER1_PRESCALER_DIV_1);
    RST_CLK_PER1_C2_Cmd(STDIO_UART_PER1_C2, ENABLE);

    RST_CLK_PCLKCmd(STDIO_UART_PCLK, ENABLE);

    UART_DeInit(STDIO_UART);
    UART_Init(STDIO_UART, &UART_TxRx);
}

static void UART_PinConfig(void)
{
    PORT_InitTypeDef UART_Pin = {
        .PORT_Pin       = PORT_PIN_0,
        .PORT_Mode      = PORT_MODE_DIGITAL,
        .PORT_Direction = PORT_DIRECTION_INPUT,
        .PORT_Function  = PORT_FUNCTION_PORT,
        .PORT_Power     = PORT_POWER_NOMINAL_UPTO_2mA,
        .PORT_PullUp    = PORT_PULL_UP_OFF,
        .PORT_PullDown  = PORT_PULL_DOWN_OFF,
    };

    RST_CLK_PCLKCmd(STDIO_UART_TX_PORT_CLK | STDIO_UART_RX_PORT_CLK, ENABLE);

    UART_Pin.PORT_Pin      = STDIO_UART_TX_PIN;
    UART_Pin.PORT_Function = STDIO_UART_TX_PIN_FUNC;
    PORT_Init(STDIO_UART_TX_PORT, &UART_Pin);

    UART_Pin.PORT_Pin      = STDIO_UART_RX_PIN;
    UART_Pin.PORT_Function = STDIO_UART_RX_PIN_FUNC;
    PORT_Init(STDIO_UART_RX_PORT, &UART_Pin);
}

/** @} */ /* End of the group STDIO_UART_Private_Functions */

/** @} */ /* End of the group STDIO_UART */

/*********************** (C) COPYRIGHT 2025 Milandr ****************************
 *
 * END OF FILE stdio_uart.c */
