/**
 *******************************************************************************
 * @file    stdio_uart.h
 * @author  Milandr Application Team
 * @version V0.1.0
 * @date    15/10/2025
 * @brief   This file contains all the functions prototypes for the STDIO UART.
 *******************************************************************************
 * <br><br>
 *
 * THE PRESENT FIRMWARE IS FOR GUIDANCE ONLY. IT AIMS AT PROVIDING CUSTOMERS
 * WITH CODING INFORMATION REGARDING MILANDR'S PRODUCTS IN ORDER TO FACILITATE
 * THE USE AND SAVE TIME. MILANDR SHALL NOT BE HELD LIABLE FOR ANY
 * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES RESULTING
 * FROM THE CONTENT OF SUCH FIRMWARE AND/OR A USE MADE BY CUSTOMERS OF THE
 * CODING INFORMATION CONTAINED HEREIN IN THEIR PRODUCTS.
 *
 * <h2><center>&copy; COPYRIGHT 2025 Milandr</center></h2>
 *******************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef STDIO_UART_H
#define STDIO_UART_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "MDR32VF0xI_config.h"

/** @addtogroup STDIO_UART STDIO UART
 * @{
 */

/** @addtogroup STDIO_UART_Exported_Defines STDIO UART Exported Defines
 * @{
 */
#define STDIO_UART             MDR_UART1
#define STDIO_UART_BAUD        115200
#define STDIO_UART_WORD        UART_WORD_LENGTH_8BIT
#define STDIO_UART_STOP_BITS   UART_STOP_BITS_1BIT
#define STDIO_UART_PARITY      UART_PARITY_NONE

#define STDIO_UART_PCLK        RST_CLK_PCLK_UART1
#define STDIO_UART_PER1_C2     RST_CLK_PER1_C2_UART1

#define STDIO_UART_TX_PORT     MDR_PORTB
#define STDIO_UART_TX_PORT_CLK RST_CLK_PCLK_PORTB
#define STDIO_UART_TX_PIN      PORT_PIN_0
#define STDIO_UART_TX_PIN_FUNC PORT_FUNCTION_MAIN

#define STDIO_UART_RX_PORT     MDR_PORTB
#define STDIO_UART_RX_PORT_CLK RST_CLK_PCLK_PORTB
#define STDIO_UART_RX_PIN      PORT_PIN_1
#define STDIO_UART_RX_PIN_FUNC PORT_FUNCTION_MAIN

/** @} */ /* End of the group STDIO_UART_Exported_Defines */

/** @addtogroup STDIO_UART_Exported_Functions STDIO UART Exported Functions
 * @{
 */
void STDIO_UART_Init(void);

/** @} */ /* End of the group STDIO_UART_Exported_Functions */

/** @} */ /* End of the group STDIO_UART */

#ifdef __cplusplus
} // extern "C" block end
#endif

#endif /* STDIO_UART_H */

/*********************** (C) COPYRIGHT 2025 Milandr ****************************
 *
 * END OF FILE stdio_uart.h */
