
#include "MDR1986VE8T.h"
#include "spec.h"

#include "mdr32f8_config.h"
#include "mdr32f8_port.h"
#include "mdr32f8_clkctrl.h"
#include "mdr32f8_adc.h"

#include <stdbool.h>

PORT_InitTypeDef PORT_InitStructure;

#define CH0 0
#define CH1 1
#define CH2 2
#define CH3 3
#define CH4 4
#define CH5 5
#define CH6 6
#define CH7 7
#define CH16 16
#define CH17 17
#define CH18 18
#define CH19 19
#define CH22 22


#define sample 60000


#define LSI_ON true
#define HSI_ON true

#define USE_DUCC0
//#define USE_DUCC1
//#define USE_DUCC2
//#define USE_DUCC3


//#define voltage_DUCC0
#define current_DUCC0


//#define voltage_DUCC1
//#define current_DUCC1


#ifdef voltage_DUCC0
  #define CRNT_CH CH16
  #define CRNT_ADC ADC0
#elif defined(current_DUCC0)
  #define CRNT_CH CH18
  #define CRNT_ADC ADC1
#elif defined(voltage_DUCC1)
  #define CRNT_CH CH17
  #define CRNT_ADC ADC0
#elif defined(current_DUCC1)
  #define CRNT_CH CH19
  #define CRNT_ADC ADC1
#endif



ADCx_InitTypeDef ADCx_IS;
uint32_t result = 0;

uint32_t TestADCch(uint32_t ch);
void TestADC(void);



int main(void){
  
  /* ONLY REV2 MCU, errata 0015. Disable Power-on-Reset control. Hold the SW4 button down until operation complete */
  //POR_disable();
  
  // Key to access clock control
  UNLOCK_UNIT(CLK_CNTR_key);
  // Key to access fault control
  UNLOCK_UNIT(FT_CNTR_key);
  
  UNLOCK_UNIT(BKP_key);
   
  /* Set CLKCTRL to default */
  CLKCTRL_DeInit();
  
  BKPCNTR_SRILOWconfig (BKPCNTR_SRILOW_upto_50MHz);
  
  /* Enable HSE0 clock */
  CLKCTRL_HSEconfig(CLKCTRL_HSE0_CLK_ON);
  
  /* Check HSE success, enable PLL0, check PLL0 success, select MAX_CLK src */
  while(CLKCTRL_HSEstatus(CLKCTRL_HSEn_STAT_HSE0_RDY) != SUCCESS){}
  
  /* Select PLL0 clk src, PLL0_N, PLL0_Q to get FINT = FIN*(PLLn_N)/(PLLn_Q+1) */
  CLKCTRL_CPU_PLLconfig(PLL0, CLKCTRL_PLLn_CLK_SELECT_HSE0div1, PLL_DIVQ_Q_1_DV, 8);//PLLn, SRC, Q, N
  while(CLKCTRL_CPU_PLLstatus(0) != SUCCESS){}
  CLKCTRL_MAX_CLKSelection(CLKCTRL_MAX_CLK_PLL0);
  
  /* Enable PORTx clk */
  CLKCTRL_PER0_CLKcmd(CLKCTRL_PER0_CLK_MDR_PORTC_EN, ENABLE);
  
  if(CRNT_ADC == ADC0){
    CLKCTRL_PER1_CLKcmd(CLKCTRL_PER1_CLK_MDR_ADC0_EN, ENABLE);
  }else if (CRNT_ADC == ADC1){
    CLKCTRL_PER1_CLKcmd(CLKCTRL_PER1_CLK_MDR_ADC1_EN, ENABLE);
  }else{
    while(1);
  }
   
  /* Allow write to PORT regs */
  UNLOCK_UNIT(PORTC_key);
  
  /* Configure PortC[6:13] for analog input */
  PORT_InitStructure.PORT_Pin   = (PORT_Pin_6|PORT_Pin_7|PORT_Pin_8|PORT_Pin_9|PORT_Pin_10|PORT_Pin_11|PORT_Pin_12|PORT_Pin_13);
  PORT_InitStructure.PORT_CANALOG = PORT_CANALOG_DIGITAL;//Clear dig, set analog
  PORT_Init(PORTC, &PORT_InitStructure);
  
  if(CRNT_ADC == ADC0){
    UNLOCK_UNIT(ADC0_key);
  }else if (CRNT_ADC == ADC1){
    UNLOCK_UNIT(ADC1_key);
  }else{
    while(1);
  }
  
//  BKP->REG_63_TMR0 &= ~0x400000;
//  BKP->REG_63_TMR1 &= ~0x400000;
//  BKP->REG_63_TMR2 &= ~0x400000;

//  BKP->REG_63_TMR0 &= ~0x8000;
//  BKP->REG_63_TMR1 &= ~0x8000;
//  BKP->REG_63_TMR2 &= ~0x8000;
  
  ADCx_CLK_en(CRNT_ADC, ADCx_CLKSRC_HSE0, ADCx_CLKdiv32);
  
  if(HSI_ON != true){
    BKP->REG_63_TMR0 &= ~0x400000;
    BKP->REG_63_TMR1 &= ~0x400000;
    BKP->REG_63_TMR2 &= ~0x400000;
  }
  
  // LSI OFF
  if(LSI_ON != true){
    BKP->REG_63_TMR0 &= ~(1 << 15);
    BKP->REG_63_TMR1 &= ~(1 << 15);
    BKP->REG_63_TMR2 &= ~(1 << 15);
  }
  
  // 6 - EN_DUcc0, 14 - EN_DUcc1, 22 - EN_DUcc2, 30 - EN_DUcc3; 1 ЗАПРЕЩАЕТ РАБОТУ
  #if defined(USE_DUCC0) // использовать только DUcc0 - остальные отключить
  BKP->REG_61_TMR0 &= ~(1 << 6);
  BKP->REG_61_TMR1 &= ~(1 << 6);
  BKP->REG_61_TMR2 &= ~(1 << 6);
  BKP->REG_61_TMR0 |= (1 << 14) | (1 << 22) | (1 << 30);
  BKP->REG_61_TMR1 |= (1 << 14) | (1 << 22) | (1 << 30);
  BKP->REG_61_TMR2 |= (1 << 14) | (1 << 22) | (1 << 30);
  #elif defined(USE_DUCC1) // использовать только DUcc1 - остальные отключить
  BKP->REG_61_TMR0 &= ~(1 << 14);
  BKP->REG_61_TMR1 &= ~(1 << 14);
  BKP->REG_61_TMR2 &= ~(1 << 14);
  BKP->REG_61_TMR0 |= (1 << 6) | (1 << 22) | (1 << 30);
  BKP->REG_61_TMR1 |= (1 << 6) | (1 << 22) | (1 << 30);
  BKP->REG_61_TMR2 |= (1 << 6) | (1 << 22) | (1 << 30);
  #elif defined(USE_DUCC2) // использовать только DUcc2 - остальные отключить
  BKP->REG_61_TMR0 &= ~(1 << 22);
  BKP->REG_61_TMR1 &= ~(1 << 22);
  BKP->REG_61_TMR2 &= ~(1 << 22);
  BKP->REG_61_TMR0 |= (1 << 6) | (1 << 14) | (1 << 30);
  BKP->REG_61_TMR1 |= (1 << 6) | (1 << 14) | (1 << 30);
  BKP->REG_61_TMR2 |= (1 << 6) | (1 << 14) | (1 << 30);
  #elif defined(USE_DUCC3) // использовать только DUcc3 - остальные отключить
  BKP->REG_61_TMR0 &= ~(1 << 30);
  BKP->REG_61_TMR1 &= ~(1 << 30);
  BKP->REG_61_TMR2 &= ~(1 << 30);
  BKP->REG_61_TMR0 |= (1 << 6) | (1 << 14) | (1 << 22);
  BKP->REG_61_TMR1 |= (1 << 6) | (1 << 14) | (1 << 22);
  BKP->REG_61_TMR2 |= (1 << 6) | (1 << 14) | (1 << 22);
  #endif
  
  
  ADCx_IS.ADC_RH_MODE = ADCx_CONFIG0_RH_MODE_ADC_POW;
  ADCx_IS.ADC_WORKMODE = ADCx_CONFIG0_WORKMODE_CONT;
//  ADCx_IS.ADC_REFMODE = ADCx_CONFIG0_REFMODE_REFSEL;
//  ADCx_IS.ADC_REFSEL = 9;
  ADCx_IS.ADC_SETUP = 5;
  ADCx_IS.ADC_PAUSE = 5;
  ADCx_IS.ADC_FIFOEN_0_31 = FIEN16 | FIEN17 | FIEN22 | FIEN18 | FIEN19;
  ADCx_IS.ADC_SELR = ENABLE;
  
  ADC_Init(CRNT_ADC, &ADCx_IS);
  ADCx_Cmd(CRNT_ADC, ENABLE);
  
  while(1){
    TestADCch(CRNT_CH);
  }
}

uint32_t TestADCch(uint32_t ch){
  
  uint32_t i;
  result = 0;
  ADCx_SetChannel(CRNT_ADC, ch);
  ADCx_Start(CRNT_ADC);
  
  for(i = 0; i < sample; i++){
    while(ADC_GetFlagStatus(CRNT_ADC, ADC_FLAG_NE) == RESET){}
    result += ADCx_GetResult(CRNT_ADC) & 0xFFFF;
  }
  result = result / sample;
  return 0;
}
