/*
 * GF_library.c
 *
 *  Created on: 21 февр. 2025 г.
 *      Author: basov.g
 */
#include "GF_library.h"
#include "string.h"
#include "stdio.h"
#include "../utils/xprintf.h"
#define WIDTH 128
#define HEIGH 64
uint8_t *displayBuffer = 0;

const uint8_t _charMap[][5] = {
    {0x00, 0x00, 0x00, 0x00, 0x00}, //   0x20 32
    {0x00, 0x00, 0x6f, 0x00, 0x00}, // ! 0x21 33
    {0x00, 0x07, 0x00, 0x07, 0x00}, // " 0x22 34
    {0x14, 0x7f, 0x14, 0x7f, 0x14}, // # 0x23 35
    {0x8C, 0x92, 0xFF, 0x92, 0x62}, // $ 0x24 36
    {0x23, 0x13, 0x08, 0x64, 0x62}, // % 0x25 37
    {0x36, 0x49, 0x56, 0x20, 0x50}, // & 0x26 38
    {0x00, 0x00, 0x07, 0x00, 0x00}, // ' 0x27 39
    {0x00, 0x1c, 0x22, 0x41, 0x00}, // ( 0x28 40
    {0x00, 0x41, 0x22, 0x1c, 0x00}, // ) 0x29 41
    {0x14, 0x08, 0x3e, 0x08, 0x14}, // * 0x2a 42
    {0x08, 0x08, 0x3e, 0x08, 0x08}, // + 0x2b 43
    {0x00, 0x50, 0x30, 0x00, 0x00}, // , 0x2c 44
    {0x08, 0x08, 0x08, 0x08, 0x08}, // - 0x2d 45
    {0x00, 0x60, 0x60, 0x00, 0x00}, // . 0x2e 46
    {0x20, 0x10, 0x08, 0x04, 0x02}, // / 0x2f 47
    {0x3e, 0x51, 0x49, 0x45, 0x3e}, // 0 0x30 48
    {0x00, 0x42, 0x7f, 0x40, 0x00}, // 1 0x31 49
    {0x42, 0x61, 0x51, 0x49, 0x46}, // 2 0x32 50
    {0x21, 0x41, 0x45, 0x4b, 0x31}, // 3 0x33 51
    {0x18, 0x14, 0x12, 0x7f, 0x10}, // 4 0x34 52
    {0x27, 0x45, 0x45, 0x45, 0x39}, // 5 0x35 53
    {0x3c, 0x4a, 0x49, 0x49, 0x30}, // 6 0x36 54
    {0x01, 0x71, 0x09, 0x05, 0x03}, // 7 0x37 55
    {0x36, 0x49, 0x49, 0x49, 0x36}, // 8 0x38 56
    {0x06, 0x49, 0x49, 0x29, 0x1e}, // 9 0x39 57
    {0x00, 0x36, 0x36, 0x00, 0x00}, // : 0x3a 58
    {0x00, 0x56, 0x36, 0x00, 0x00}, // ; 0x3b 59
    {0x08, 0x14, 0x22, 0x41, 0x00}, // < 0x3c 60
    {0x14, 0x14, 0x14, 0x14, 0x14}, // = 0x3d 61
    {0x00, 0x41, 0x22, 0x14, 0x08}, // > 0x3e 62
    {0x02, 0x01, 0x51, 0x09, 0x06}, // ? 0x3f 63
    {0x3e, 0x41, 0x5d, 0x49, 0x4e}, // @ 0x40 64
    {0x7e, 0x09, 0x09, 0x09, 0x7e}, // A 0x41 65
    {0x7f, 0x49, 0x49, 0x49, 0x36}, // B 0x42 66
    {0x3e, 0x41, 0x41, 0x41, 0x22}, // C 0x43 67
    {0x7f, 0x41, 0x41, 0x41, 0x3e}, // D 0x44 68
    {0x7f, 0x49, 0x49, 0x49, 0x41}, // E 0x45 69
    {0x7f, 0x09, 0x09, 0x09, 0x01}, // F 0x46 70
    {0x3e, 0x41, 0x49, 0x49, 0x7a}, // G 0x47 71
    {0x7f, 0x08, 0x08, 0x08, 0x7f}, // H 0x48 72
    {0x00, 0x41, 0x7f, 0x41, 0x00}, // I 0x49 73
    {0x20, 0x40, 0x41, 0x3f, 0x01}, // J 0x4a 74
    {0x7f, 0x08, 0x14, 0x22, 0x41}, // K 0x4b 75
    {0x7f, 0x40, 0x40, 0x40, 0x40}, // L 0x4c 76
    {0x7f, 0x02, 0x0c, 0x02, 0x7f}, // M 0x4d 77
    {0x7f, 0x04, 0x08, 0x10, 0x7f}, // N 0x4e 78
    {0x3e, 0x41, 0x41, 0x41, 0x3e}, // O 0x4f 79
    {0x7f, 0x09, 0x09, 0x09, 0x06}, // P 0x50 80
    {0x3e, 0x41, 0x51, 0x21, 0x5e}, // Q 0x51 81
    {0x7f, 0x09, 0x19, 0x29, 0x46}, // R 0x52 82
    {0x46, 0x49, 0x49, 0x49, 0x31}, // S 0x53 83
    {0x01, 0x01, 0x7f, 0x01, 0x01}, // T 0x54 84
    {0x3f, 0x40, 0x40, 0x40, 0x3f}, // U 0x55 85
    {0x0f, 0x30, 0x40, 0x30, 0x0f}, // V 0x56 86
    {0x3f, 0x40, 0x30, 0x40, 0x3f}, // W 0x57 87
    {0x63, 0x14, 0x08, 0x14, 0x63}, // X 0x58 88
    {0x07, 0x08, 0x70, 0x08, 0x07}, // Y 0x59 89
    {0x61, 0x51, 0x49, 0x45, 0x43}, // Z 0x5a 90
    {0x00, 0x00, 0x7f, 0x41, 0x00}, // [ 0x5b 91
    {0x02, 0x04, 0x08, 0x10, 0x20}, // \ 0x5c 92
    {0x00, 0x41, 0x7f, 0x00, 0x00}, // ] 0x5d 93
    {0x04, 0x02, 0x01, 0x02, 0x04}, // ^ 0x5e 94
    {0x40, 0x40, 0x40, 0x40, 0x40}, // _ 0x5f 95
    {0x00, 0x00, 0x03, 0x04, 0x00}, // ` 0x60 96
    {0x20, 0x54, 0x54, 0x54, 0x78}, // a 0x61 97
    {0x7f, 0x48, 0x44, 0x44, 0x38}, // b 0x62 98
    {0x38, 0x44, 0x44, 0x44, 0x20}, // c 0x63 99
    {0x38, 0x44, 0x44, 0x48, 0x7f}, // d 0x64 100
    {0x38, 0x54, 0x54, 0x54, 0x18}, // e 0x65 101
    {0x08, 0x7e, 0x09, 0x01, 0x02}, // f 0x66 102
    {0x0c, 0x52, 0x52, 0x52, 0x3e}, // g 0x67 103
    {0x7f, 0x08, 0x04, 0x04, 0x78}, // h 0x68 104
    {0x00, 0x44, 0x7d, 0x40, 0x00}, // i 0x69 105
    {0x20, 0x40, 0x44, 0x3d, 0x00}, // j 0x6a 106
    {0x00, 0x7f, 0x10, 0x28, 0x44}, // k 0x6b 107
    {0x00, 0x41, 0x7f, 0x40, 0x00}, // l 0x6c 108
    {0x7c, 0x04, 0x18, 0x04, 0x78}, // m 0x6d 109
    {0x7c, 0x08, 0x04, 0x04, 0x78}, // n 0x6e 110
    {0x38, 0x44, 0x44, 0x44, 0x38}, // o 0x6f 111
    {0x7c, 0x14, 0x14, 0x14, 0x08}, // p 0x70 112
    {0x08, 0x14, 0x14, 0x18, 0x7c}, // q 0x71 113
    {0x7c, 0x08, 0x04, 0x04, 0x08}, // r 0x72 114
    {0x48, 0x54, 0x54, 0x54, 0x20}, // s 0x73 115
    {0x04, 0x3f, 0x44, 0x40, 0x20}, // t 0x74 116
    {0x3c, 0x40, 0x40, 0x20, 0x7c}, // u 0x75 117
    {0x1c, 0x20, 0x40, 0x20, 0x1c}, // v 0x76 118
    {0x3c, 0x40, 0x30, 0x40, 0x3c}, // w 0x77 119
    {0x44, 0x28, 0x10, 0x28, 0x44}, // x 0x78 120
    {0x0c, 0x50, 0x50, 0x50, 0x3c}, // y 0x79 121
    {0x44, 0x64, 0x54, 0x4c, 0x44}, // z 0x7a 122
    {0x00, 0x08, 0x36, 0x41, 0x41}, // { 0x7b 123
    {0x04, 0x02, 0x7f, 0x02, 0x04}, // | 0x7c 124
    {0x41, 0x41, 0x36, 0x08, 0x00}, // } 0x7d 125
    {0x04, 0x02, 0x04, 0x08, 0x04}, // ~ 0x7e 126

    {0x7E, 0x11, 0x11, 0x11, 0x7E},    //__А (0xC0).
    {0x7F, 0x49, 0x49, 0x49, 0x33},    //__Б (0xC1).
    {0x7F, 0x49, 0x49, 0x49, 0x36},    //__В (0xC2).
    {0x7F, 0x01, 0x01, 0x01, 0x03},    //__Г (0xC3).
    {0xE0, 0x51, 0x4F, 0x41, 0xFF},    //__Д (0xC4).
    {0x7F, 0x49, 0x49, 0x49, 0x41},    //__Е (0xC5).
    {0x77, 0x08, 0x7F, 0x08, 0x77},    //__Ж (0xC6).
    {0x41, 0x49, 0x49, 0x49, 0x36},    //__З (0xC7).
    {0x7F, 0x10, 0x08, 0x04, 0x7F},    //__И (0xC8).
    {0x7C, 0x21, 0x12, 0x09, 0x7C},    //__Й (0xC9).
    {0x7F, 0x08, 0x14, 0x22, 0x41},    //__К (0xCA).
    {0x20, 0x41, 0x3F, 0x01, 0x7F},    //__Л (0xCB).
    {0x7F, 0x02, 0x0C, 0x02, 0x7F},    //__М (0xCC).
    {0x7F, 0x08, 0x08, 0x08, 0x7F},    //__Н (0xCD).
    {0x3E, 0x41, 0x41, 0x41, 0x3E},    //__О (0xCE).
    {0x7F, 0x01, 0x01, 0x01, 0x7F},    //__П (0xCF).
    {0x7F, 0x09, 0x09, 0x09, 0x06},    //__Р (0xD0).
    {0x3E, 0x41, 0x41, 0x41, 0x22},    //__С (0xD1).
    {0x01, 0x01, 0x7F, 0x01, 0x01},    //__Т (0xD2).
    {0x47, 0x28, 0x10, 0x08, 0x07},    //__У (0xD3).
    {0x1C, 0x22, 0x7F, 0x22, 0x1C},    //__Ф (0xD4).
    {0x63, 0x14, 0x08, 0x14, 0x63},    //__Х (0xD5).
    {0x7F, 0x40, 0x40, 0x40, 0xFF},    //__Ц (0xD6).
    {0x07, 0x08, 0x08, 0x08, 0x7F},    //__Ч (0xD7).
    {0x7F, 0x40, 0x7F, 0x40, 0x7F},    //__Ш (0xD8).
    {0x7F, 0x40, 0x7F, 0x40, 0xFF},    //__Щ (0xD9).
    {0x01, 0x7F, 0x48, 0x48, 0x30},    //__Ъ (0xDA).
    {0x7F, 0x48, 0x30, 0x00, 0x7F},    //__Ы (0xDB).
    {0x00, 0x7F, 0x48, 0x48, 0x30},    //__Ь (0xDC).
    {0x22, 0x41, 0x49, 0x49, 0x3E},    //__Э (0xDD).
    {0x7F, 0x08, 0x3E, 0x41, 0x3E},    //__Ю (0xDE).
    {0x46, 0x29, 0x19, 0x09, 0x7F},    //__Я (0xDF).

    {0x20, 0x54, 0x54, 0x54, 0x78},    //__а (0xE0).
    {0x3C, 0x4A, 0x4A, 0x49, 0x31},    //__б (0xE1).
    {0x7C, 0x54, 0x54, 0x28, 0x00},    //__в (0xE2).
    {0x7C, 0x04, 0x04, 0x0C, 0x00},    //__г (0xE3).
    {0xE0, 0x54, 0x4C, 0x44, 0xFC},    //__д (0xE4).
    {0x38, 0x54, 0x54, 0x54, 0x18},    //__е (0xE5).
    {0x6C, 0x10, 0x7C, 0x10, 0x6C},    //__ж (0xE6).
    {0x44, 0x54, 0x54, 0x28, 0x00},    //__з (0xE7).
    {0x7C, 0x20, 0x10, 0x08, 0x7C},    //__и (0xE8).
    {0x78, 0x42, 0x24, 0x12, 0x78},    //__й (0xE9).
    {0x7C, 0x10, 0x28, 0x44, 0x00},    //__к (0xEA).
    {0x20, 0x44, 0x3C, 0x04, 0x7C},    //__л (0xEB).
    {0x7C, 0x08, 0x10, 0x08, 0x7C},    //__м (0xEC).
    {0x7C, 0x10, 0x10, 0x10, 0x7C},    //__н (0xED).
    {0x38, 0x44, 0x44, 0x44, 0x38},    //__о (0xEE).
    {0x7C, 0x04, 0x04, 0x04, 0x7C},    //__п (0xEF).
    {0x7C, 0x14, 0x14, 0x14, 0x08},    //__р (0xF0).
    {0x38, 0x44, 0x44, 0x44, 0x00},    //__с (0xF1).
    {0x04, 0x04, 0x7C, 0x04, 0x04},    //__т (0xF2).
    {0x0C, 0x50, 0x50, 0x50, 0x3C},    //__у (0xF3).
    {0x30, 0x48, 0xFE, 0x48, 0x30},    //__ф (0xF4).
    {0x44, 0x28, 0x10, 0x28, 0x44},    //__х (0xF5).
    {0x7C, 0x40, 0x40, 0x7C, 0xC0},    //__ц (0xF6).
    {0x0C, 0x10, 0x10, 0x10, 0x7C},    //__ч (0xF7).
    {0x7C, 0x40, 0x7C, 0x40, 0x7C},    //__ш (0xF8).
    {0x7C, 0x40, 0x7C, 0x40, 0xFC},    //__щ (0xF9).
    {0x04, 0x7C, 0x50, 0x50, 0x20},    //__ъ (0xFA).
    {0x7C, 0x50, 0x50, 0x20, 0x7C},    //__ы (0xFB).
    {0x7C, 0x50, 0x50, 0x20, 0x00},    //__ь (0xFC).
    {0x28, 0x44, 0x54, 0x54, 0x38},    //__э (0xFD).
    {0x7C, 0x10, 0x38, 0x44, 0x38},    //__ю (0xFE).
    {0x08, 0x54, 0x34, 0x14, 0x7C},    //__я (0xFF).
    {0x38, 0x55, 0x54, 0x55, 0x18},    //__ё (0xFF).
};

int constrain(int value, int min, int max)
{
	if(value<min) return min;
	if(value>max) return max;
	return value;
}

int abs(int a)
{
	if(a<0) return -a;
	return a;
}

void GF_SetBuffer(uint8_t *address)
{
	displayBuffer=address;
}

void GF_Clear(void)
{
	for(int i = 0; i < WIDTH*HEIGH/8; i++)
		displayBuffer[i] = 0;
}

void GF_Dot(int x, int y)
{
	if(displayBuffer==0) return;
	displayBuffer[(y/8)*128 + x] |= (uint8_t)(0x01<<(y%8));
}

void GF_FastLineH(int y, int x0, int x1) {
	if (x0 > x1) {
		int a = x0;
		x0=x1;
		x1=a;
	}
	if (y < 0 || y > HEIGH) return;
	if (x0 == x1) {
		GF_Dot(x0, y);
		return;
	}
	x1++;
	x0 = constrain(x0, 0, WIDTH);
	x1 = constrain(x1, 0, WIDTH);
	for (int x = x0; x < x1; x++) GF_Dot(x, y);
}

void GF_FastLineV(int x, int y0, int y1) {
	if (y0 > y1)
	{
		int a = y0;
		y0=y1;
		y1=a;
	}
	if (x < 0 || x > WIDTH) return;
	if (y0 == y1) {
		GF_Dot(x, y0);
		return;
	}
	y0 = constrain(y0, 0, HEIGH);
	y1 = constrain(y1, 0, HEIGH);
	for (int y = y0; y < y1; y++) GF_Dot(x, y);

}

void GF_Line(int x0, int y0, int x1, int y1)
{
	if (x0 == x1) GF_FastLineV(x0, y0, y1);
	else if (y0 == y1) GF_FastLineH(y0, x0, x1);
	else {
		int sx, sy, e2, err;
		int dx = abs(x1 - x0);
		int dy = abs(y1 - y0);
		sx = (x0 < x1) ? 1 : -1;
		sy = (y0 < y1) ? 1 : -1;
		err = dx - dy;
		for (;;) {
			GF_Dot(x0, y0);
			if (x0 == x1 && y0 == y1) return;
			e2 = err << 1;
			if (e2 > -dy) {
				err -= dy;
				x0 += sx;
			}
			if (e2 < dx) {
				err += dx;
				y0 += sy;
			}
		}
	}
}


void GF_Rect(int x0, int y0, int x1, int y1) {
	if (x0 > x1) {
		int a = x0;
		x0=x1;
		x1=a;
	}
	if (y0 > y1){
		int a = y0;
		y0=y1;
		y1=a;
	}
	if (x0 == x1 && y0 == y1) {
		GF_Dot(x0, y0);
		return;
	}
	if (x0 == x1) {
		GF_FastLineV(x0, y0, y1);
		return;
	}
	if (y0 == y1) {
		GF_FastLineH(y0, x0, x1);
		return;
	}

	for(int x = x0; x <= x1; x++)
		GF_FastLineV(x, y0, y1);
}

void GF_RectLine(int x0, int y0, int x1, int y1)
{
	if (x0 > x1) {
			int a = x0;
			x0=x1;
			x1=a;
		}
		if (y0 > y1){
			int a = y0;
			y0=y1;
			y1=a;
		}
		if (x0 == x1 && y0 == y1) {
			GF_Dot(x0, y0);
			return;
		}
		if (x0 == x1) {
			GF_FastLineV(x0, y0, y1);
			return;
		}
		if (y0 == y1) {
			GF_FastLineH(y0, x0, x1);
			return;
		}


		GF_FastLineV(x0, y0, y1);
		GF_FastLineV(x1, y0, y1);
		GF_FastLineH(y0, x0, x1);
		GF_FastLineH(y1, x0, x1);
}


void GF_RoundRect(int x0, int y0, int x1, int y1) {
	GF_FastLineV(x0, y0 + 2, y1 - 2);
	GF_FastLineV(x0 + 1, y0 + 1, y1 - 1);
	GF_FastLineV(x1 - 1, y0 + 1, y1 - 1);
	GF_FastLineV(x1, y0 + 2, y1 - 2);
	GF_Rect(x0 + 2, y0, x1 - 2, y1);
}

    // окружность (центр х, центр у, радиус, заливка)
void GF_Circle(int x, int y, int radius) {
	int f = 1 - radius;
	int ddF_x = 1;
	int ddF_y = -2 * radius;
	int x1 = 0;
	int y1 = radius;

	GF_Dot(x, y + radius);
	GF_Dot(x, y - radius);
	GF_Dot(x + radius, y);
	GF_Dot(x - radius, y);
	GF_FastLineV(x, y - radius, y + radius - 1);
	while (x1 < y1) {
		if (f >= 0) {
			y1--;
			ddF_y += 2;
			f += ddF_y;
		}
		x1++;
		ddF_x += 2;
		f += ddF_x;
		GF_FastLineV(x + x1, y - y1, y + y1);
		GF_FastLineV(x - x1, y - y1, y + y1);
		GF_FastLineV(x + y1, y - x1, y + x1);
		GF_FastLineV(x - y1, y - x1, y + x1);
	}
}

uint8_t getFont(uint8_t font, uint8_t row) {
   if (row > 4) return 0;
   font = font - '0' + 16;  // перевод код символа из таблицы ASCII
   if (font <= 95) {
	   return _charMap[font][row];  // для английских букв и символов
   } else if (font >= 96 && font <= 111) {
	   return _charMap[font + 47][row];
   } else if (font <= 159) {
	   return _charMap[font - 17][row];
   } else return _charMap[font - 1][row];  // для кастомных (ё)

}

void GF_DrawSymbol(int x, int y, char symbol)
{
	if(displayBuffer==0) return;
	for(uint8_t i = 0; i < 5;i++)
	{
		displayBuffer[y/8*128+x+i] |= (uint8_t)((getFont((uint8_t)symbol,i)<<y%8)&0xFF);
		if(y%8) displayBuffer[(y/8+1)*128+x+i] |= (uint8_t)((getFont((uint8_t)symbol,i)>>(8-y%8))&0xFF);
	}
}


void GF_DrawStr(int x, int y, char *str)
{
	if(displayBuffer==0) return;
	while((*str!='\r') && (*str!=0x00) )
	{
		if((uint8_t)(*str)< 0xD0)
		{
			GF_DrawSymbol(x,y,*str);
			x+=6;
			if(y>WIDTH) return;
		}
		str++;
	}
}

void GF_DrawSymbolGraph(int x, int y, uint8_t size)
{
	if(displayBuffer==0) return;
	for(int i = 0; i < 5;i++)
	{
		displayBuffer[y/8*128+x+i] |= size;
		if(y%8) displayBuffer[(y/8+1)*128+x+i] |= size;
	}
}

void GF_Printf(int x, int y, char const* fmt, ... )
{
	char buff[32] = {0};
	va_list arg_ptr;
	va_start(arg_ptr, fmt);
	xsvaprintf(buff, fmt, arg_ptr);
	va_end(arg_ptr);
	GF_DrawStr(x, y, buff);
}
