/*
 * drv_adcui.h
 *
 *  Created on: 24 февр. 2025 г.
 *      Author: basov.g
 */

#ifndef DRV_DRV_ADCUI_H_
#define DRV_DRV_ADCUI_H_

#include <stdint.h>

typedef enum
{
	adcuiChannelA = 0,
	adcuiChannelB = 1,
	adcuiChannelC = 2,
} ADCUIChannel;

typedef struct {
	ADCUIChannel channelNumber;
	int32_t voltage;	//mV
	int32_t current; 	//mA
	int32_t power;	 	//mW
	int32_t activeP;	//mW
	int32_t activeN;	//mW
	int32_t reactiveP;	//mW
	int32_t reactiveN;  //mW
	int32_t powerWH;	//W*Hour
	int32_t activePWH;	//W*Hour
	int32_t activeNWH;	//W*Hour
	int32_t reactivePWH;//W*Hour
	int32_t reactiveNWH;//W*Hour
	int32_t maxVoltage; //mV
	int32_t maxCurrent; //mA
	int32_t freq;		//mHz

}ADCUIChannelDataStruct;

void drv_adcui_init(void);
int64_t drv_adcui_getVoltage(ADCUIChannel channel);
int64_t drv_adcui_getCurrent(ADCUIChannel channel);
int64_t drv_adcui_getCurrentNull(void);
int64_t drv_adcui_getEnergy(ADCUIChannel channel);
void drv_adcui_getChannelData(ADCUIChannel channel, ADCUIChannelDataStruct *_return);
int64_t drv_adcui_getActivePower(ADCUIChannel channel);
int64_t drv_adcui_getActivePowerWatt(ADCUIChannel channel);
int64_t drv_adcui_getReactivePower(ADCUIChannel channel);
int64_t drv_adcui_getReactivePowerWatt(ADCUIChannel channel);

int32_t drv_adcui_getActiveImp(void);
int32_t drv_adcui_getReactiveImp(void);
void drv_adcui_callibrate(void);
#endif /* DRV_DRV_ADCUI_H_ */
