/*
 * drv_button.h
 *
 *  Created on: 11 мар. 2025 г.
 *      Author: basov.g
 */

#ifndef DRV_DRV_BUTTON_H_
#define DRV_DRV_BUTTON_H_

#ifdef __cplusplus
extern "C" {
#endif
#include "stdint.h"

#define BUTTONSCOUNT 2

typedef enum {
	ButtonUp			= 0x00,	//state when button up
	ButtonDown			= 0x01,	//state when button down
	ButtonPress			= 0x02,	//state when button press short time
	ButtonLongPress		= 0x03,	//state when button press short time
	ButtonClick			= 0x04,	//state when falling edge
	ButtonRelease		= 0x05,	//state when rising edge
}ButtonState;

typedef enum {
	ButtonFirst			= 0x00,
	ButtonSecond		= 0x01,
	ButtonThird     	= 0x02,
	ButtonForth			= 0x03,
	ButtonFives			= 0x04,
}ButtonNum;

void drv_Button_Init(void);
void drv_Button_Update(void);

ButtonState drv_Button_GetState(ButtonNum num);
void drv_Button_SetEvent(ButtonNum num, ButtonState event, void (*function) (void));

#ifdef __cplusplus
}
#endif

#endif /* DRV_DRV_BUTTON_H_ */
