/*
 * drv_clock.h
 *
 *  Created on: 24 февр. 2025 г.
 *      Author: basov.g
 */

#ifndef DRV_DRV_CLOCK_H_
#define DRV_DRV_CLOCK_H_

#include "stdbool.h"
#include "stdint.h"

void drv_clock_init(void);
void drv_clock_update(void);

void drv_clock_setDate(int day, int month,int year);
void drv_clock_setTime(int hour, int minutes, int seconds);
void drv_clock_setCalibration(void);

int drv_clock_getSeconds(void);
int drv_clock_getMinutes(void);
int drv_clock_getHour(void);
int drv_clock_getDay(void);
int drv_clock_getMonth(void);
int drv_clock_getYear(void);

bool drv_getStatusTampers(void);
bool drv_getStatusTamperNumber(uint8_t number);
int drv_clock_getTamperSeconds(uint8_t number);
int drv_clock_getTamperMinutes(uint8_t number);
int drv_clock_getTamperHour(uint8_t number);
int drv_clock_getTamperDay(uint8_t number);
int drv_clock_getTamperMonth(uint8_t number);
int drv_clock_getTamperYear(uint8_t number);

uint8_t drv_clock_getCalibValue(void);
uint8_t drv_clock_getTempRes(void);
uint8_t drv_clock_getTempConst(uint8_t number);
#endif /* DRV_DRV_CLOCK_H_ */
