/*
 * drv_display.h
 *
 *  Created on: 20 февр. 2025 г.
 *      Author: basov.g
 */

#ifndef DRV_DRV_DISPLAY_H_
#define DRV_DRV_DISPLAY_H_
#include <stdbool.h>
#include <stdint.h>
typedef enum
{
	DisplayPageMain,
	DisplayPagePhaseA,
	DisplayPagePhaseB,
	DisplayPagePhaseC,
	DisplayPageTamper,
	DisplayPageClock,
	DisplayPagePower,
	DisplayPageCalibrate
}enumDisplayPage;

typedef enum
{
	DisplayPageCalibrateMain,
	DisplayPageCalibrateVoltageLowPoint,
	DisplayPageCalibrateVoltageHighPoint,
	DisplayPageCalibrateCurrentLowPoint,
	DisplayPageCalibrateCurrentHighPoint,
	DisplayPageCalibratePhase,
	DisplayPageCalibratePowerActiveZero,
	DisplayPageCalibratePowerActiveCoef,
	DisplayPageCalibratePowerReactiveZero,
	DisplayPageCalibratePowerReactiveCoef,
	DisplayPageCalibrateStartCurrent,
}enumDisplayCalibratePage;


typedef enum
{
	DisplayPageClockSetMain,
	DisplayPageClockSetDay,
	DisplayPageClockSetMonth,
	DisplayPageClockSetYear,
	DisplayPageClockSetHour,
	DisplayPageClockSetMinutes,
	DisplayPageClockSetSeconds
}enumDisplayClockSetPage;

void drv_display_init(void);
void drv_display_update(void);

void drv_display_setCurrentDisplay(enumDisplayPage page);
void drv_display_setNextDisplay(void);
void drv_display_setNextSubDisplay(void);
uint8_t drv_display_getDisplaySubPage(void);
void drv_display_ledOn(void);
void drv_display_ledOff(void);

void drv_display_drawCapture(void);
void drv_display_drawCalibrateDisplay(enumDisplayCalibratePage page);
#endif /* DRV_DRV_DISPLAY_H_ */
