/*
 * drv_displayCalibrate.c
 *
 *  Created on: 27 мар. 2025 г.
 *      Author: basov.g
 */

#include "drv_display.h"

#include <stdbool.h>
#include <stdint.h>
#include "MDR32VF0xI_port.h"
#include "MDR32VF0xI_ssp.h"
#include "GF_Library.h"
#include "drv_adcui.h"
#include "drv_clock.h"
#include "drv_adc.h"
#include "../utils/xprintf.h"
#include "../utils/utils.h"



void drv_display_drawCalibrateDisplayMain(void)
{
	GF_Printf(2, 12, "Calibrate     4 LSB");
	GF_Printf(2, 20, "FxAC:%04X %04X %04X",(uint16_t)MDR_ADCUI->F0AC,  (uint16_t)MDR_ADCUI->F1AC,  (uint16_t)MDR_ADCUI->F2AC);
	GF_Printf(2, 28, "CALx:%04X %04X %04X",(uint16_t)MDR_ADCUI->CCAL1, (uint16_t)MDR_ADCUI->CCAL2, (uint16_t)MDR_ADCUI->CCAL3);
	GF_Printf(2, 36, "xCTR:%04X %04X %04X",(uint16_t)MDR_ADCUI->F0CTR, (uint16_t)MDR_ADCUI->F1CTR, (uint16_t)MDR_ADCUI->F2CTR);
	GF_Printf(2, 44, "FxWC:%04X %04X %04X",(uint16_t)MDR_ADCUI->F0WC,  (uint16_t)MDR_ADCUI->F1WC,  (uint16_t)MDR_ADCUI->F2WC);
	GF_Printf(2, 52, "FxVS:%04X %04X %04X",(uint16_t)MDR_ADCUI->F0VC,  (uint16_t)MDR_ADCUI->F1VC,  (uint16_t)MDR_ADCUI->F2VC);
}

void drv_display_drawCalibrateDisplayVoltageLowPoint(void)
{
	GF_Printf(2, 12, "Cal. voltage 190V");
	GF_Printf(2, 20, "V0: %8lu %6ld",MDR_ADCUI->F0VRMS, (int32_t)drv_adcui_getVoltage(adcuiChannelA));
	GF_Printf(2, 28, "V1: %8lu %6ld",MDR_ADCUI->F1VRMS, (int32_t)drv_adcui_getVoltage(adcuiChannelB));
	GF_Printf(2, 36, "V2: %8lu %6ld",MDR_ADCUI->F2VRMS, (int32_t)drv_adcui_getVoltage(adcuiChannelC));
	GF_Printf(2, 44, "OS0:%4d OS1:%4d", (int16_t)((MDR_ADCUI->F0AC&0xFFF)),
									  (int16_t)((MDR_ADCUI->F1AC&0xFFF)));
	GF_Printf(2, 52, "OS2:%4d", (int16_t)((MDR_ADCUI->F2AC&0xFFF)));
}

void drv_display_drawCalibrateDisplayVoltageHighPoint(void)
{
	GF_Printf(2, 12, "Cal. voltage 240V");
	GF_Printf(2, 20, "V0: %8lu %6ld",MDR_ADCUI->F0VRMS, (int32_t)drv_adcui_getVoltage(adcuiChannelA));
	GF_Printf(2, 28, "V1: %8lu %6ld",MDR_ADCUI->F1VRMS, (int32_t)drv_adcui_getVoltage(adcuiChannelB));
	GF_Printf(2, 36, "V2: %8lu %6ld",MDR_ADCUI->F2VRMS, (int32_t)drv_adcui_getVoltage(adcuiChannelC));
	GF_Printf(2, 44, "C1:%6d C2:%6d", (int16_t)(MDR_ADCUI->CCAL1&0x0000FFFF), (int16_t)(MDR_ADCUI->CCAL2&0x0000FFFF));
	GF_Printf(2, 52, "C3:%6d", (int16_t)(MDR_ADCUI->CCAL3&0x0000FFFF));
}

void drv_display_drawCalibrateDisplayCurrentLowPoint(void)
{
	GF_Printf(2, 12, "Cal. current 25mA");
	GF_Printf(2, 20, "I1: %8lu %6lu",MDR_ADCUI->F0IRMS, (int32_t)drv_adcui_getCurrent(adcuiChannelA));// 1 / 0.003 / 2^24 * 1000
	GF_Printf(2, 28, "I2: %8lu %6lu",MDR_ADCUI->F1IRMS, (int32_t)drv_adcui_getCurrent(adcuiChannelB));
	GF_Printf(2, 36, "I3: %8lu %6lu",MDR_ADCUI->F2IRMS, (int32_t)drv_adcui_getCurrent(adcuiChannelC));
	GF_Printf(2, 44, "OS0:%4d OS1:%4d", (int16_t)((MDR_ADCUI->F0CTR&0xFFF00000)>>20),
									  (int16_t)((MDR_ADCUI->F1CTR&0xFFF00000)>>20));
	GF_Printf(2, 52, "OS2:%4d", (int16_t)((MDR_ADCUI->F2CTR&0xFFF00000)>>20));
}

void drv_display_drawCalibrateDisplayCurrentHighPoint(void)
{
	GF_Printf(2, 12, "Cal. current 2.5A");
	GF_Printf(2, 20, "I1: %8lu %6lu",MDR_ADCUI->F0IRMS, (int32_t)drv_adcui_getCurrent(adcuiChannelA));
	GF_Printf(2, 28, "I2: %8lu %6lu",MDR_ADCUI->F1IRMS, (int32_t)drv_adcui_getCurrent(adcuiChannelB));
	GF_Printf(2, 36, "I3: %8lu %6lu",MDR_ADCUI->F2IRMS, (int32_t)drv_adcui_getCurrent(adcuiChannelC));
	GF_Printf(2, 44, "C1:%6d C2:%6d", (int16_t)((MDR_ADCUI->CCAL1>>16)&0x0000FFFF),
									(int16_t)((MDR_ADCUI->CCAL2>>16)&0x0000FFFF));
	GF_Printf(2, 52, "C3:%6d", (int16_t)((MDR_ADCUI->CCAL3>>16)&0x0000FFFF));
}

void drv_display_drawCalibratePhase(void)
{
	int8_t corr[3] = {0};
	corr[0] = (int8_t)(MDR_ADCUI->F0CTR>>10&0xFF);
	corr[1] = (int8_t)(MDR_ADCUI->F1CTR>>10&0xFF);
	corr[2] = (int8_t)(MDR_ADCUI->F2CTR>>10&0xFF);
	GF_Printf(2, 12, "AA: %9lli Cal.",drv_adcui_getActivePower(adcuiChannelA));
	GF_Printf(2, 20, "AR: %9lli phase",drv_adcui_getReactivePower(adcuiChannelA));
	GF_Printf(2, 28, "BA: %9lli C1 %3d",drv_adcui_getActivePower(adcuiChannelB),  (int8_t)corr[0]);
	GF_Printf(2, 36, "BR: %9lli C2 %3d",drv_adcui_getReactivePower(adcuiChannelB),(int8_t)corr[1]);
	GF_Printf(2, 44, "CA: %9lli C3 %3d",drv_adcui_getActivePower(adcuiChannelC),  (int8_t)corr[2]);
	GF_Printf(2, 52, "CR: %9lli",drv_adcui_getReactivePower(adcuiChannelC));
}

void drv_display_drawCalibrateDisplayActiveZero(void)
{
	char buff[32];
	int16_t corr[3] = {0};
	corr[0] = (int16_t)(MDR_ADCUI->F0WC&0xFFFF);
	corr[1] = (int16_t)(MDR_ADCUI->F1WC&0xFFFF);
	corr[2] = (int16_t)(MDR_ADCUI->F2WC&0xFFFF);
	GF_Printf(2, 12, "Cal. act zero");
	GF_Printf(2, 20, "AA: %8lli; %7lli",drv_adcui_getActivePower(adcuiChannelA), drv_adcui_getActivePowerWatt(adcuiChannelA));
	GF_Printf(2, 28, "BA: %8lli; %7lli",drv_adcui_getActivePower(adcuiChannelB), drv_adcui_getActivePowerWatt(adcuiChannelB));
	GF_Printf(2, 36, "CA: %8lli; %7lli",drv_adcui_getActivePower(adcuiChannelC), drv_adcui_getActivePowerWatt(adcuiChannelC));
	GF_Printf(2, 44, "C1 %4d, C2 %4d",corr[0], corr[1]);
	GF_Printf(2, 52, "C3 %4d",corr[2]);
}

void drv_display_drawCalibrateDisplayActiveCoef(void)
{

	char buff[32];
	int16_t corr[3] = {0};
	corr[0] = (int16_t)(((MDR_ADCUI->F0WC)&0xFFF0000)>>16);
	corr[1] = (int16_t)(((MDR_ADCUI->F1WC)&0xFFF0000)>>16);
	corr[2] = (int16_t)(((MDR_ADCUI->F2WC)&0xFFF0000)>>16);
	corr[0] = corr[0]&0x800 ? (int16_t)(corr[0] | 0xF000): corr[0];
	corr[1] = corr[1]&0x800 ? (int16_t)(corr[1] | 0xF000): corr[1];
	corr[2] = corr[2]&0x800 ? (int16_t)(corr[2] | 0xF000): corr[2];
	GF_Printf(2, 12, "Cal. active coef");
	GF_Printf(2, 20, "AA: %8lli; %7lli",drv_adcui_getActivePower(adcuiChannelA), drv_adcui_getActivePowerWatt(adcuiChannelA));
	GF_Printf(2, 28, "BA: %8lli; %7lli",drv_adcui_getActivePower(adcuiChannelB), drv_adcui_getActivePowerWatt(adcuiChannelB));
	GF_Printf(2, 36, "CA: %8lli; %7lli",drv_adcui_getActivePower(adcuiChannelC), drv_adcui_getActivePowerWatt(adcuiChannelC));
	GF_Printf(2, 44, "C1 %4d, C2 %4d",corr[0], corr[1]);
	GF_Printf(2, 52, "C3 %4d",corr[2]);
}

void drv_display_drawCalibrateDisplayReactiveZero(void)
{
	int16_t corr[3] = {0};
	corr[0] = (int16_t)(MDR_ADCUI->F0VC&0xFFFF);
	corr[1] = (int16_t)(MDR_ADCUI->F1VC&0xFFFF);
	corr[2] = (int16_t)(MDR_ADCUI->F2VC&0xFFFF);
	GF_Printf(2, 12, "Cal. reactive zero");
	GF_Printf(2, 20, "AA: %8lli; %7lli",drv_adcui_getReactivePower(adcuiChannelA), drv_adcui_getReactivePowerWatt(adcuiChannelA));
	GF_Printf(2, 28, "BA: %8lli; %7lli",drv_adcui_getReactivePower(adcuiChannelB), drv_adcui_getReactivePowerWatt(adcuiChannelB));
	GF_Printf(2, 36, "CA: %8lli; %7lli",drv_adcui_getReactivePower(adcuiChannelC), drv_adcui_getReactivePowerWatt(adcuiChannelC));
	GF_Printf(2, 44, "C1 %4d, C2 %4d",corr[0], corr[1]);
	GF_Printf(2, 52, "C3 %4d",corr[2]);
}

void drv_display_drawCalibrateDisplayReactiveCoef(void)
{
	int16_t corr[3] = {0};
	corr[0] = (int16_t)(((MDR_ADCUI->F0VC)&0xFFF0000)>>16);
	corr[1] = (int16_t)(((MDR_ADCUI->F1VC)&0xFFF0000)>>16);
	corr[2] = (int16_t)(((MDR_ADCUI->F2VC)&0xFFF0000)>>16);
	corr[0] = corr[0]&0x800 ? (int16_t)(corr[0] | 0xF000): corr[0];
	corr[1] = corr[1]&0x800 ? (int16_t)(corr[1] | 0xF000): corr[1];
	corr[2] = corr[2]&0x800 ? (int16_t)(corr[2] | 0xF000): corr[2];
	GF_Printf(2, 12, "Cal. reactive coef");
	GF_Printf(2, 20, "AA: %8lli; %7lli",drv_adcui_getReactivePower(adcuiChannelA), drv_adcui_getReactivePowerWatt(adcuiChannelA));
	GF_Printf(2, 28, "BA: %8lli; %7lli",drv_adcui_getReactivePower(adcuiChannelB), drv_adcui_getReactivePowerWatt(adcuiChannelB));
	GF_Printf(2, 36, "CA: %8lli; %7lli",drv_adcui_getReactivePower(adcuiChannelC), drv_adcui_getReactivePowerWatt(adcuiChannelC));
	GF_Printf(2, 44, "C1 %4d, C2 %4d",corr[0], corr[1]);
	GF_Printf(2, 52, "C3 %4d",corr[2]);
}

void drv_display_drawCalibrateDisplayStartCurrent(void)
{
	GF_Printf(2, 12, "Cal. start current");
}

void drv_display_drawCalibrateDisplay(enumDisplayCalibratePage page)
{
	GF_Clear();
	drv_display_drawCapture();
	switch(page)
	{
		case DisplayPageCalibrateMain				: drv_display_drawCalibrateDisplayMain(); 				break;
		case DisplayPageCalibrateVoltageLowPoint	: drv_display_drawCalibrateDisplayVoltageLowPoint();	break;
		case DisplayPageCalibrateVoltageHighPoint	: drv_display_drawCalibrateDisplayVoltageHighPoint(); 	break;
		case DisplayPageCalibrateCurrentLowPoint	: drv_display_drawCalibrateDisplayCurrentLowPoint(); 	break;
		case DisplayPageCalibrateCurrentHighPoint	: drv_display_drawCalibrateDisplayCurrentHighPoint(); 	break;
		case DisplayPageCalibratePhase				: drv_display_drawCalibratePhase();			 			break;
		case DisplayPageCalibratePowerActiveZero	: drv_display_drawCalibrateDisplayActiveZero(); 		break;
		case DisplayPageCalibratePowerActiveCoef	: drv_display_drawCalibrateDisplayActiveCoef(); 		break;
		case DisplayPageCalibratePowerReactiveZero	: drv_display_drawCalibrateDisplayReactiveZero(); 		break;
		case DisplayPageCalibratePowerReactiveCoef	: drv_display_drawCalibrateDisplayReactiveCoef(); 		break;
		case DisplayPageCalibrateStartCurrent		: drv_display_drawCalibrateDisplayStartCurrent(); 		break;
	}
}
