/*
 * drv_flash.h
 *
 *  Created on: 28 мар. 2025 г.
 *      Author: basov.g
 */

#ifndef DRV_DRV_FLASH_H_
#define DRV_DRV_FLASH_H_

#include "stdint.h"


typedef struct
{
	uint32_t magicValue;
	uint32_t registerF0AC;
	uint32_t registerF1AC;
	uint32_t registerF2AC;
	uint32_t registerCCAL1;
	uint32_t registerCCAL2;
	uint32_t registerCCAL3;
	uint32_t registerCCAL4;
	uint32_t registerF0CTR;
	uint32_t registerF1CTR;
	uint32_t registerF2CTR;
	uint32_t registerF0WC;
	uint32_t registerF1WC;
	uint32_t registerF2WC;
	uint32_t registerF0VC;
	uint32_t registerF1VC;
	uint32_t registerF2VC;
}flashAdcuiSaveStruct;

typedef struct
{
	uint32_t magicValue;
	uint32_t yaer;
	uint32_t month;
	uint32_t day;
	uint32_t hours;
	uint32_t minutes;
	uint32_t tamperStates;
}flashTimeSaveStruct;

void drv_flash_init(void);
void drv_flash_update(void);

void drv_flash_save(void);
void drv_flash_load(void);
uint16_t drv_flash_getId(void);
#endif /* DRV_DRV_FLASH_H_ */
