/**
  ******************************************************************************
  * @file    MDR32F9Qx_IT.c
  * @author  Milandr Application Team
  * @version V2.0.1
  * @date    31/05/2023
  * @brief   Main Interrupt Service Routines for MPU MDR1986VE9x.
  ******************************************************************************
  * <br><br>
  *
  * THE PRESENT FIRMWARE IS FOR GUIDANCE ONLY. IT AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING MILANDR'S PRODUCTS IN ORDER TO FACILITATE
  * THE USE AND SAVE TIME. MILANDR SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES RESULTING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR A USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2024 Milandr</center></h2>
  */

/* Includes ------------------------------------------------------------------*/
#include "MDR32F9Qx_IT.h"

/** @addtogroup __MDR32Fx_StdPeriph_Driver MDR32Fx Standard Peripherial Driver
  * @{
  */

/** @defgroup MDR1986VE9x_IT MDR1986VE9x IT
  * @{
  */

#if defined (USE_MDR1986VE9x)

#if defined (_USE_DEBUG_UART_)

/** @defgroup MDR1986VE9x_IT_Private_Defines MDR1986VE9x IT Private Defines
  * @{
  */
#define DEBUG_PRINTF(...) printf(__VA_ARGS__)

/** @} */ /* End of group MDR1986VE9x_IT_Private_Defines */

/** @defgroup MDR1986VE9x_IT_Private_Function_Prototypes MDR1986VE9x IT Private Function Prototypes
  * @{
  */
void Hard_fault_handler_c(unsigned int* hardfault_args);

/** @} */ /* End of group MDR1986VE9x_IT_Private_Function_Prototypes */

#endif /* #if defined (_USE_DEBUG_UART_) */

/** @defgroup MDR1986VE9x_IT_Exported_Functions MDR1986VE9x IT Exported Functions
  * @{
  */

/**
  * @brief  Hard Fault exception handler.
  * @param  None
  * @retval None
  */
void HardFault_Handler(void)
{
#if defined (_USE_DEBUG_UART_)
    unsigned int contr_reg;
    contr_reg = __get_CONTROL();
    if(contr_reg & 2)
    {
#if defined ( __CMCARM__ )
        __ASM MRS R0, PSP;
#else
        __ASM("MRS R0, PSP");
#endif
    }
    else
    {
#if defined ( __CMCARM__ )
        __ASM MRS R0, MSP;
#else
        __ASM("MRS R0, MSP");
#endif
    }
    //top of stack is in R0. It is passed to C-function.
#if defined ( __CMCARM__ )
    __ASM BL (Hard_fault_handler_c);
#else
    __ASM("BL (Hard_fault_handler_c)");
#endif

    /* Go to infinite loop when Hard Fault exception occurs */
    while (1);

#endif /* #if defined (_USE_DEBUG_UART_) */
}

/**
  * @brief  Memory Mamagement Fault exception handler.
  * @param  None
  * @retval None
  */
void MemManage_Handler(void)
{
}

/**
  * @brief  Bus Fault Handler exception.
  * @param  None
  * @retval None
  */
void BusFault_Handler(void)
{
}

/**
  * @brief  Usage Fault exception handler.
  * @param  None
  * @retval None
  */
void UsageFault_Handler(void)
{
}

/**
  * @brief  SVCall exception handler.
  * @param  None
  * @retval None
  */
void SVC_Handler(void)
{
}

/**
  * @brief  Debug Monitor exception handler.
  * @param  None
  * @retval None
  */
void DebugMon_Handler(void)
{
}

/**
  * @brief  Debug PendSV exception handler.
  * @param  None
  * @retval None
  */
void PendSV_Handler(void)
{
}

/**
  * @brief  SysTick handler.
  * @param  None
  * @retval None
  */
void SysTick_Handler(void)
{
}

/**
  * @brief  CAN1 interrupt request handler.
  * @param  None
  * @retval None
  */
void CAN1_IRQHandler(void)
{
}

/**
  * @brief  CAN2 interrupt request handler.
  * @param  None
  * @retval None
  */
void CAN2_IRQHandler(void)
{
}

/**
  * @brief  USB interrupt request handler.
  * @param  None
  * @retval None
  */
void USB_IRQHandler(void)
{
}

/**
  * @brief  DMA interrupt request handler.
  * @param  None
  * @retval None
  */
void DMA_IRQHandler(void)
{
}

/**
  * @brief  UART1 interrupt request handler.
  * @param  None
  * @retval None
  */
void UART1_IRQHandler(void)
{
}

/**
  * @brief  UART2 interrupt request handler.
  * @param  None
  * @retval None
  */
void UART2_IRQHandler(void)
{
}

/**
  * @brief  SSP1 interrupt request handler.
  * @param  None
  * @retval None
  */
void SSP1_IRQHandler(void)
{
}

/**
  * @brief  I2C interrupt request handler.
  * @param  None
  * @retval None
  */
void I2C_IRQHandler(void)
{
}

/**
  * @brief  POWER interrupt request handler.
  * @param  None
  * @retval None
  */
void POWER_IRQHandler(void)
{
}

/**
  * @brief  WWDG interrupt request handler.
  * @param  None
  * @retval None
  */
void WWDG_IRQHandler(void)
{
}

/**
  * @brief  TIMER1 interrupt request handler.
  * @param  None
  * @retval None
  */
void Timer1_IRQHandler(void)
{
}

/**
  * @brief  TIMER2 interrupt request handler.
  * @param  None
  * @retval None
  */
void Timer2_IRQHandler(void)
{
}

/**
  * @brief  TIMER3 interrupt request handler.
  * @param  None
  * @retval None
  */
void Timer3_IRQHandler(void)
{
}

/**
  * @brief  ADC interrupt request handler.
  * @param  None
  * @retval None
  */
void ADC_IRQHandler(void)
{
}

/**
  * @brief  COMPARATOR interrupt request handler.
  * @param  None
  * @retval None
  */
void COMPARATOR_IRQHandler(void)
{
}

/**
  * @brief  SSP2 interrupt request handler.
  * @param  None
  * @retval None
  */
void SSP2_IRQHandler(void)
{
}

/**
  * @brief  BKP RTC interrupt request handler.
  * @param  None
  * @retval None
  */
void BACKUP_IRQHandler(void)
{
}

/**
  * @brief  EXT_INT1 interrupt request handler.
  * @param  None
  * @retval None
  */
void EXT_INT1_IRQHandler(void)
{
}

/**
  * @brief  EXT_INT2 interrupt request handler.
  * @param  None
  * @retval None
  */
void EXT_INT2_IRQHandler(void)
{
}

/**
  * @brief  EXT_INT3 interrupt request handler.
  * @param  None
  * @retval None
  */
void EXT_INT3_IRQHandler(void)
{
}

/**
  * @brief  EXT_INT4 interrupt request handler.
  * @param  None
  * @retval None
  */
void EXT_INT4_IRQHandler(void)
{
}

/** @} */ /* End of group MDR1986VE9x_IT_Exported_Functions */

/** @defgroup MDR1986VE9x_IT_Private_Functions MDR1986VE9x IT Private Functions
  * @{
  */

#if defined (_USE_DEBUG_UART_)
/**
  * @brief  Handles hard fault exception, stores stack and prints stack via UART
  * @param  hardfault_args: MCU stack
  * @retval None
  */
void Hard_fault_handler_c(unsigned int* hardfault_args)
{
    unsigned int stacked_r0;
    unsigned int stacked_r1;
    unsigned int stacked_r2;
    unsigned int stacked_r3;
    unsigned int stacked_r12;
    unsigned int stacked_lr;
    unsigned int stacked_pc;
    unsigned int stacked_psr;

    stacked_r0 = ((unsigned long) hardfault_args[0]);
    stacked_r1 = ((unsigned long) hardfault_args[1]);
    stacked_r2 = ((unsigned long) hardfault_args[2]);
    stacked_r3 = ((unsigned long) hardfault_args[3]);

    stacked_r12 = ((unsigned long) hardfault_args[4]);
    stacked_lr  = ((unsigned long) hardfault_args[5]);
    stacked_pc  = ((unsigned long) hardfault_args[6]);
    stacked_psr = ((unsigned long) hardfault_args[7]);

    DEBUG_PRINTF("[Hard fault handler]\r\n");
    DEBUG_PRINTF("R0 = 0x%x\r\n", stacked_r0);
    DEBUG_PRINTF("R1 = 0x%x\r\n", stacked_r1);
    DEBUG_PRINTF("R2 = 0x%x\r\n", stacked_r2);
    DEBUG_PRINTF("R3 = 0x%x\r\n", stacked_r3);
    DEBUG_PRINTF("R12 = 0x%x\r\n", stacked_r12);
    DEBUG_PRINTF("LR = 0x%x\r\n", stacked_lr);
    DEBUG_PRINTF("PC = 0x%x\r\n", stacked_pc);
    DEBUG_PRINTF("PSR = 0x%x\r\n", stacked_psr);

    /* Go to infinite loop when Hard Fault exception occurs */
    while (1);
}

#endif /* #if defined (_USE_DEBUG_UART_) */

/** @} */ /* End of group MDR1986VE9x_IT_Exported_Functions */

#endif /* #if defined (USE_MDR1986VE9x) */

/** @} */ /* End of group MDR1986VE9x_IT */

/** @} */ /* End of group __MDR32Fx_StdPeriph_Driver */

/*********************** (C) COPYRIGHT 2024 Milandr ****************************
*
* END OF FILE MDR32F9Qx_IT.c */

