/**
  ******************************************************************************
  * @file    ringbuf.h
  * @author  Milandr Application Team
  * @version V0.0.3
  * @date    26/08/2022
  * @brief   This file contains the defines and typedef and functions prototypes.
  *
  ******************************************************************************
  * <br><br>
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, MILANDR SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
  * OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2024 Milandr</center></h2>
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __RINGBUF_H
#define __RINGBUF_H

#include <stdint.h>

typedef struct
{
    uint32_t *buf;         /* Pointer to an array for ring buffer       */
    uint32_t size;         /* Ring buffer size                          */
    uint32_t wr;           /* Position number to write to ring buffer   */
    uint32_t rd;           /* Position number to read from ring buffer  */
} RingBuf_TypeDef;

void RingBuf_Init(RingBuf_TypeDef *ringbuf, uint32_t *ptr_buf, uint32_t size);
void RingBuf_WriteWord(RingBuf_TypeDef *ringbuf, uint32_t data);
void RingBuf_Write(RingBuf_TypeDef *ringbuf, uint32_t *data, uint32_t size);
uint32_t RingBuf_ReadWord(RingBuf_TypeDef *ringbuf);
void RingBuf_Read(RingBuf_TypeDef *ringbuf, uint32_t *data, uint32_t size);


#endif /* __RINGBUF_H */

/******************* (C) COPYRIGHT 2024 Milandr *******************************/

/* END OF FILE ringbuf.h */

