/**
  ******************************************************************************
  * @file    MDR32F8_it.c
  * @author  Milandr Application Team
  * @version V1.5.0
  * @date    21.09.2022
  * @brief   Main Interrupt Service Routines.
  *
  ******************************************************************************
  * <br><br>
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, MILANDR SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2024 Milandr </center></h2>
  */
/* Includes ------------------------------------------------------------------*/

#include "mdr32f8_it.h"


/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/


void INT_UART0_Handler(void)
{
    uint32_t temp_1;

    if (UART_GetITStatusMasked(MDR_UART0, UART_IT_RX) == SET)
    {
        temp_1 = UART_ReceiveData(MDR_UART0);	

        UART_ClearITPendingBit(MDR_UART0, UART_IT_RX);

        while (UART_GetFlagStatus (MDR_UART0, UART_FLAG_TXFE)!= SET)
            {
            }
        UART_SendData (MDR_UART0,temp_1);
    }
}

/******************* (C) COPYRIGHT 2024 Milandr *******************************/

/* END OF FILE MDR32F8_it.c */


