/**********************************************************************************************************************
  Copyright (C) 2016-2020 JSC "ICC Milandr" 

**********************************************************************************************************************/

#ifndef __DEF1967VN044_H_
#define __DEF1967VN044_H_

#include <defts201.h>

//-------------------------------------------------------//
// Bits Masks
#define IS_SET_BIT(x, BITPOS) ((x & (1 << BITPOS)) == (1 << BITPOS))

#define FIRST_BIT(x) (                                                                                                                                                     \
      IS_SET_BIT(x,  0)?  0   :     IS_SET_BIT(x,  1)?  1   :     IS_SET_BIT(x,  2)?  2       :     IS_SET_BIT(x,  3)?  3   :                 \
      IS_SET_BIT(x,  4)?  4   :     IS_SET_BIT(x,  5)?  5   :     IS_SET_BIT(x,  6)?  6       :     IS_SET_BIT(x,  7)?  7   :                 \
      IS_SET_BIT(x,  8)?  8   :     IS_SET_BIT(x,  9)?  9   :     IS_SET_BIT(x, 10)? 10       :     IS_SET_BIT(x, 11)? 11   :                 \
      IS_SET_BIT(x, 12)? 12   :     IS_SET_BIT(x, 13)? 13   :     IS_SET_BIT(x, 14)? 14       :     IS_SET_BIT(x, 15)? 15   :                 \
      IS_SET_BIT(x, 16)? 16   :     IS_SET_BIT(x, 17)? 17   :     IS_SET_BIT(x, 18)? 18       :     IS_SET_BIT(x, 19)? 19   :                 \
      IS_SET_BIT(x, 20)? 20   :     IS_SET_BIT(x, 21)? 21   :     IS_SET_BIT(x, 22)? 22       :     IS_SET_BIT(x, 23)? 23   :                 \
      IS_SET_BIT(x, 24)? 24   :     IS_SET_BIT(x, 25)? 25   :     IS_SET_BIT(x, 26)? 26       :     IS_SET_BIT(x, 27)? 27   :                 \
      IS_SET_BIT(x, 28)? 28   :     IS_SET_BIT(x, 29)? 29   :     IS_SET_BIT(x, 30)? 30       :     IS_SET_BIT(x, 31)? 31   :     32          \
)

#define LAST_BIT(x) (                                                                                                                                                      \
      IS_SET_BIT(x, 31)? 31   :     IS_SET_BIT(x, 30)? 30   :     IS_SET_BIT(x, 29)? 29       :     IS_SET_BIT(x, 28)? 28   :                 \
      IS_SET_BIT(x, 27)? 27   :     IS_SET_BIT(x, 26)? 26   :     IS_SET_BIT(x, 25)? 25       :     IS_SET_BIT(x, 24)? 24   :                 \
      IS_SET_BIT(x, 23)? 23   :     IS_SET_BIT(x, 22)? 22   :     IS_SET_BIT(x, 21)? 21       :     IS_SET_BIT(x, 20)? 20   :                 \
      IS_SET_BIT(x, 19)? 19   :     IS_SET_BIT(x, 18)? 18   :     IS_SET_BIT(x, 17)? 17       :     IS_SET_BIT(x, 16)? 16   :                 \
      IS_SET_BIT(x, 15)? 15   :     IS_SET_BIT(x, 14)? 14   :     IS_SET_BIT(x, 13)? 13       :     IS_SET_BIT(x, 12)? 12   :                 \
      IS_SET_BIT(x, 11)? 11   :     IS_SET_BIT(x, 10)? 10   :     IS_SET_BIT(x,  9)?  9       :     IS_SET_BIT(x,  8)?  8   :                 \
      IS_SET_BIT(x,  7)?  7   :     IS_SET_BIT(x,  6)?  6   :     IS_SET_BIT(x,  5)?  5       :     IS_SET_BIT(x,  4)?  4   :                 \
      IS_SET_BIT(x,  3)?  3   :     IS_SET_BIT(x,  2)?  2   :     IS_SET_BIT(x,  1)?  1       :     IS_SET_BIT(x,  0)?  0   :     32          \
)

#define BITSIZEOF(x) ( LAST_BIT(x) - FIRST_BIT(x) + 1)
#define CREATE_BIT_MASK(e, s) ( ((1 << (1 + (e - s))) - 1) << s )

/*-------------------------------- BASE ADDRESSES --------------------------------*/
#define base_DMACFGL  		0x80000078
#define base_DMACFGH  		0x80000079
#define base_EBIU     		0x80000080
#define base_GPX     		0x80000090

#define base_UART0    		0x80000100
#define base_UART1    		0x80000120
#define base_SPI0      		0x80000140
#define base_LCD  			0x80000160
#define base_VBUF     		0x80000180
#define base_VIDEO   		0x800001a0
#define base_CMU      		0x800001c0
#define base_RTC      		0x800001e0
#define base_I2S0    		0x80000200
#define base_I2S1    		0x80000220
#define base_NAND    		0x80000240
#define base_UDDC0     		0x80000280
#define base_UDDC1     		0x80000260
#define base_UDDC2     		0x800002A0
#define base_UDDC3     		0x800002C0
#define base_I2C			0x800002E0
#define base_INTCTL			0x80000300
#define base_TIMER			0x8000034E
#define base_SPI1    		0x80000360
#define base_SPI2   		0x80000380
#define base_GTIMER0		0x80000400
#define base_GTIMER1		0x80000440
#define base_GPA      		0x80001000
#define base_GPB      		0x80001040
#define base_GPC      		0x80001080
#define base_ARINC_RX 		0x80002000
#define base_ARINC_TX		0x80003000
#define base_ARINC_RX_MEM 	0x80002400
#define base_ARINC_TX_MEM 	0x80003400
#define base_ARINC_LAB0 	0x800027e0
#define base_DIGCORR  		0x80005000
#define base_MILSTD0  		0x80006000
#define base_MILSTD1  		0x80007000
#define base_BROM     		0x80008000

#define base_IVT			(base_INTCTL + 0x00)

#define DIGCORR_BASE		base_DIGCORR
#define MILSTD0_BASE 		base_MILSTD0
#define MILSTD1_BASE 		base_MILSTD1
#define IVT_BASE			base_IVT
#define RTC_BASE 			base_RTC
#define GPA_BASE			base_GPA
#define GPB_BASE 			base_GPB
#define NAND_BASE			base_NAND
#define UART0_BASE			base_UART0
#define UART1_BASE			base_UART1
#define LCD_BASE			base_LCD
#define VIDEO_BASE			base_VIDEO
#define UDDC0_BASE			base_UDDC0
#define UDDC1_BASE			base_UDDC1
#define UDDC2_BASE			base_UDDC2
#define UDDC3_BASE			base_UDDC3
/*----------------------------------  REGISTERS  ----------------------------------*/

//-------------------------------------------------------//
// Digital Correlator
#define DIGCORR_CH0_BASE	(DIGCORR_BASE+0x000)
#define DIGCORR_CH1_BASE	(DIGCORR_BASE+0x008)
#define DIGCORR_CH2_BASE	(DIGCORR_BASE+0x010)
#define DIGCORR_CH3_BASE	(DIGCORR_BASE+0x018)
#define DIGCORR_CH4_BASE	(DIGCORR_BASE+0x020)
#define DIGCORR_CH5_BASE	(DIGCORR_BASE+0x028)
#define DIGCORR_CH6_BASE	(DIGCORR_BASE+0x030)
#define DIGCORR_CH7_BASE	(DIGCORR_BASE+0x038)
#define DIGCORR_CH8_BASE	(DIGCORR_BASE+0x040)
#define DIGCORR_CH9_BASE	(DIGCORR_BASE+0x048)
#define DIGCORR_CH10_BASE	(DIGCORR_BASE+0x050)
#define DIGCORR_CH11_BASE	(DIGCORR_BASE+0x058)
#define DIGCORR_CH12_BASE	(DIGCORR_BASE+0x060)
#define DIGCORR_CH13_BASE	(DIGCORR_BASE+0x068)
#define DIGCORR_CH14_BASE	(DIGCORR_BASE+0x070)
#define DIGCORR_CH15_BASE	(DIGCORR_BASE+0x078)
#define DIGCORR_GENREG_BASE	(DIGCORR_BASE+0x080)

#define DIGCORR_CH0_SC0_CNT_LOC			(DIGCORR_CH0_BASE+0x000)
#define DIGCORR_CH0_SC0_STEP_LOC		(DIGCORR_CH0_BASE+0x001)
#define DIGCORR_CH0_DZ0_CNT_LOC			(DIGCORR_CH0_BASE+0x002)
#define DIGCORR_CH0_DZ0_STEP_LOC		(DIGCORR_CH0_BASE+0x003)
#define DIGCORR_CH0_SC1_CNT_LOC			(DIGCORR_CH0_BASE+0x004)
#define DIGCORR_CH0_SC1_STEP_LOC		(DIGCORR_CH0_BASE+0x005)
#define DIGCORR_CH0_DZ1_CNT_LOC			(DIGCORR_CH0_BASE+0x006)
#define DIGCORR_CH0_DZ1_STEP_LOC		(DIGCORR_CH0_BASE+0x007)

#define DIGCORR_CH1_SC0_CNT_LOC			(DIGCORR_CH1_BASE+0x000)
#define DIGCORR_CH1_SC0_STEP_LOC		(DIGCORR_CH1_BASE+0x001)
#define DIGCORR_CH1_DZ0_CNT_LOC			(DIGCORR_CH1_BASE+0x002)
#define DIGCORR_CH1_DZ0_STEP_LOC		(DIGCORR_CH1_BASE+0x003)
#define DIGCORR_CH1_SC1_CNT_LOC			(DIGCORR_CH1_BASE+0x004)
#define DIGCORR_CH1_SC1_STEP_LOC		(DIGCORR_CH1_BASE+0x005)
#define DIGCORR_CH1_DZ1_CNT_LOC			(DIGCORR_CH1_BASE+0x006)
#define DIGCORR_CH1_DZ1_STEP_LOC		(DIGCORR_CH1_BASE+0x007)

#define DIGCORR_CH2_SC0_CNT_LOC			(DIGCORR_CH2_BASE+0x000)
#define DIGCORR_CH2_SC0_STEP_LOC		(DIGCORR_CH2_BASE+0x001)
#define DIGCORR_CH2_DZ0_CNT_LOC			(DIGCORR_CH2_BASE+0x002)
#define DIGCORR_CH2_DZ0_STEP_LOC		(DIGCORR_CH2_BASE+0x003)
#define DIGCORR_CH2_SC1_CNT_LOC			(DIGCORR_CH2_BASE+0x004)
#define DIGCORR_CH2_SC1_STEP_LOC		(DIGCORR_CH2_BASE+0x005)
#define DIGCORR_CH2_DZ1_CNT_LOC			(DIGCORR_CH2_BASE+0x006)
#define DIGCORR_CH2_DZ1_STEP_LOC		(DIGCORR_CH2_BASE+0x007)

#define DIGCORR_CH3_SC0_CNT_LOC			(DIGCORR_CH3_BASE+0x000)
#define DIGCORR_CH3_SC0_STEP_LOC		(DIGCORR_CH3_BASE+0x001)
#define DIGCORR_CH3_DZ0_CNT_LOC			(DIGCORR_CH3_BASE+0x002)
#define DIGCORR_CH3_DZ0_STEP_LOC		(DIGCORR_CH3_BASE+0x003)
#define DIGCORR_CH3_SC1_CNT_LOC			(DIGCORR_CH3_BASE+0x004)
#define DIGCORR_CH3_SC1_STEP_LOC		(DIGCORR_CH3_BASE+0x005)
#define DIGCORR_CH3_DZ1_CNT_LOC			(DIGCORR_CH3_BASE+0x006)
#define DIGCORR_CH3_DZ1_STEP_LOC		(DIGCORR_CH3_BASE+0x007)

#define DIGCORR_CH4_SC0_CNT_LOC			(DIGCORR_CH4_BASE+0x000)
#define DIGCORR_CH4_SC0_STEP_LOC		(DIGCORR_CH4_BASE+0x001)
#define DIGCORR_CH4_DZ0_CNT_LOC			(DIGCORR_CH4_BASE+0x002)
#define DIGCORR_CH4_DZ0_STEP_LOC		(DIGCORR_CH4_BASE+0x003)
#define DIGCORR_CH4_SC1_CNT_LOC			(DIGCORR_CH4_BASE+0x004)
#define DIGCORR_CH4_SC1_STEP_LOC		(DIGCORR_CH4_BASE+0x005)
#define DIGCORR_CH4_DZ1_CNT_LOC			(DIGCORR_CH4_BASE+0x006)
#define DIGCORR_CH4_DZ1_STEP_LOC		(DIGCORR_CH4_BASE+0x007)

#define DIGCORR_CH5_SC0_CNT_LOC			(DIGCORR_CH5_BASE+0x000)
#define DIGCORR_CH5_SC0_STEP_LOC		(DIGCORR_CH5_BASE+0x001)
#define DIGCORR_CH5_DZ0_CNT_LOC			(DIGCORR_CH5_BASE+0x002)
#define DIGCORR_CH5_DZ0_STEP_LOC		(DIGCORR_CH5_BASE+0x003)
#define DIGCORR_CH5_SC1_CNT_LOC			(DIGCORR_CH5_BASE+0x004)
#define DIGCORR_CH5_SC1_STEP_LOC		(DIGCORR_CH5_BASE+0x005)
#define DIGCORR_CH5_DZ1_CNT_LOC			(DIGCORR_CH5_BASE+0x006)
#define DIGCORR_CH5_DZ1_STEP_LOC		(DIGCORR_CH5_BASE+0x007)

#define DIGCORR_CH6_SC0_CNT_LOC			(DIGCORR_CH6_BASE+0x000)
#define DIGCORR_CH6_SC0_STEP_LOC		(DIGCORR_CH6_BASE+0x001)
#define DIGCORR_CH6_DZ0_CNT_LOC			(DIGCORR_CH6_BASE+0x002)
#define DIGCORR_CH6_DZ0_STEP_LOC		(DIGCORR_CH6_BASE+0x003)
#define DIGCORR_CH6_SC1_CNT_LOC			(DIGCORR_CH6_BASE+0x004)
#define DIGCORR_CH6_SC1_STEP_LOC		(DIGCORR_CH6_BASE+0x005)
#define DIGCORR_CH6_DZ1_CNT_LOC			(DIGCORR_CH6_BASE+0x006)
#define DIGCORR_CH6_DZ1_STEP_LOC		(DIGCORR_CH6_BASE+0x007)

#define DIGCORR_CH7_SC0_CNT_LOC			(DIGCORR_CH7_BASE+0x000)
#define DIGCORR_CH7_SC0_STEP_LOC		(DIGCORR_CH7_BASE+0x001)
#define DIGCORR_CH7_DZ0_CNT_LOC			(DIGCORR_CH7_BASE+0x002)
#define DIGCORR_CH7_DZ0_STEP_LOC		(DIGCORR_CH7_BASE+0x003)
#define DIGCORR_CH7_SC1_CNT_LOC			(DIGCORR_CH7_BASE+0x004)
#define DIGCORR_CH7_SC1_STEP_LOC		(DIGCORR_CH7_BASE+0x005)
#define DIGCORR_CH7_DZ1_CNT_LOC			(DIGCORR_CH7_BASE+0x006)
#define DIGCORR_CH7_DZ1_STEP_LOC		(DIGCORR_CH7_BASE+0x007)

#define DIGCORR_CH8_SC0_CNT_LOC			(DIGCORR_CH8_BASE+0x000)
#define DIGCORR_CH8_SC0_STEP_LOC		(DIGCORR_CH8_BASE+0x001)
#define DIGCORR_CH8_DZ0_CNT_LOC			(DIGCORR_CH8_BASE+0x002)
#define DIGCORR_CH8_DZ0_STEP_LOC		(DIGCORR_CH8_BASE+0x003)
#define DIGCORR_CH8_SC1_CNT_LOC			(DIGCORR_CH8_BASE+0x004)
#define DIGCORR_CH8_SC1_STEP_LOC		(DIGCORR_CH8_BASE+0x005)
#define DIGCORR_CH8_DZ1_CNT_LOC			(DIGCORR_CH8_BASE+0x006)
#define DIGCORR_CH8_DZ1_STEP_LOC		(DIGCORR_CH8_BASE+0x007)

#define DIGCORR_CH9_SC0_CNT_LOC			(DIGCORR_CH9_BASE+0x000)
#define DIGCORR_CH9_SC0_STEP_LOC		(DIGCORR_CH9_BASE+0x001)
#define DIGCORR_CH9_DZ0_CNT_LOC			(DIGCORR_CH9_BASE+0x002)
#define DIGCORR_CH9_DZ0_STEP_LOC		(DIGCORR_CH9_BASE+0x003)
#define DIGCORR_CH9_SC1_CNT_LOC			(DIGCORR_CH9_BASE+0x004)
#define DIGCORR_CH9_SC1_STEP_LOC		(DIGCORR_CH9_BASE+0x005)
#define DIGCORR_CH9_DZ1_CNT_LOC			(DIGCORR_CH9_BASE+0x006)
#define DIGCORR_CH9_DZ1_STEP_LOC		(DIGCORR_CH9_BASE+0x007)

#define DIGCORR_CH10_SC0_CNT_LOC		(DIGCORR_CH10_BASE+0x000)
#define DIGCORR_CH10_SC0_STEP_LOC		(DIGCORR_CH10_BASE+0x001)
#define DIGCORR_CH10_DZ0_CNT_LOC		(DIGCORR_CH10_BASE+0x002)
#define DIGCORR_CH10_DZ0_STEP_LOC		(DIGCORR_CH10_BASE+0x003)
#define DIGCORR_CH10_SC1_CNT_LOC		(DIGCORR_CH10_BASE+0x004)
#define DIGCORR_CH10_SC1_STEP_LOC		(DIGCORR_CH10_BASE+0x005)
#define DIGCORR_CH10_DZ1_CNT_LOC		(DIGCORR_CH10_BASE+0x006)
#define DIGCORR_CH10_DZ1_STEP_LOC		(DIGCORR_CH10_BASE+0x007)

#define DIGCORR_CH11_SC0_CNT_LOC		(DIGCORR_CH11_BASE+0x000)
#define DIGCORR_CH11_SC0_STEP_LOC		(DIGCORR_CH11_BASE+0x001)
#define DIGCORR_CH11_DZ0_CNT_LOC		(DIGCORR_CH11_BASE+0x002)
#define DIGCORR_CH11_DZ0_STEP_LOC		(DIGCORR_CH11_BASE+0x003)
#define DIGCORR_CH11_SC1_CNT_LOC		(DIGCORR_CH11_BASE+0x004)
#define DIGCORR_CH11_SC1_STEP_LOC		(DIGCORR_CH11_BASE+0x005)
#define DIGCORR_CH11_DZ1_CNT_LOC		(DIGCORR_CH11_BASE+0x006)
#define DIGCORR_CH11_DZ1_STEP_LOC		(DIGCORR_CH11_BASE+0x007)

#define DIGCORR_CH12_SC0_CNT_LOC		(DIGCORR_CH12_BASE+0x000)
#define DIGCORR_CH12_SC0_STEP_LOC		(DIGCORR_CH12_BASE+0x001)
#define DIGCORR_CH12_DZ0_CNT_LOC		(DIGCORR_CH12_BASE+0x002)
#define DIGCORR_CH12_DZ0_STEP_LOC		(DIGCORR_CH12_BASE+0x003)
#define DIGCORR_CH12_SC1_CNT_LOC		(DIGCORR_CH12_BASE+0x004)
#define DIGCORR_CH12_SC1_STEP_LOC		(DIGCORR_CH12_BASE+0x005)
#define DIGCORR_CH12_DZ1_CNT_LOC		(DIGCORR_CH12_BASE+0x006)
#define DIGCORR_CH12_DZ1_STEP_LOC		(DIGCORR_CH12_BASE+0x007)

#define DIGCORR_CH13_SC0_CNT_LOC		(DIGCORR_CH13_BASE+0x000)
#define DIGCORR_CH13_SC0_STEP_LOC		(DIGCORR_CH13_BASE+0x001)
#define DIGCORR_CH13_DZ0_CNT_LOC		(DIGCORR_CH13_BASE+0x002)
#define DIGCORR_CH13_DZ0_STEP_LOC		(DIGCORR_CH13_BASE+0x003)
#define DIGCORR_CH13_SC1_CNT_LOC		(DIGCORR_CH13_BASE+0x004)
#define DIGCORR_CH13_SC1_STEP_LOC		(DIGCORR_CH13_BASE+0x005)
#define DIGCORR_CH13_DZ1_CNT_LOC		(DIGCORR_CH13_BASE+0x006)
#define DIGCORR_CH13_DZ1_STEP_LOC		(DIGCORR_CH13_BASE+0x007)

#define DIGCORR_CH14_SC0_CNT_LOC		(DIGCORR_CH14_BASE+0x000)
#define DIGCORR_CH14_SC0_STEP_LOC		(DIGCORR_CH14_BASE+0x001)
#define DIGCORR_CH14_DZ0_CNT_LOC		(DIGCORR_CH14_BASE+0x002)
#define DIGCORR_CH14_DZ0_STEP_LOC		(DIGCORR_CH14_BASE+0x003)
#define DIGCORR_CH14_SC1_CNT_LOC		(DIGCORR_CH14_BASE+0x004)
#define DIGCORR_CH14_SC1_STEP_LOC		(DIGCORR_CH14_BASE+0x005)
#define DIGCORR_CH14_DZ1_CNT_LOC		(DIGCORR_CH14_BASE+0x006)
#define DIGCORR_CH14_DZ1_STEP_LOC		(DIGCORR_CH14_BASE+0x007)

#define DIGCORR_CH15_SC0_CNT_LOC		(DIGCORR_CH15_BASE+0x000)
#define DIGCORR_CH15_SC0_STEP_LOC		(DIGCORR_CH15_BASE+0x001)
#define DIGCORR_CH15_DZ0_CNT_LOC		(DIGCORR_CH15_BASE+0x002)
#define DIGCORR_CH15_DZ0_STEP_LOC		(DIGCORR_CH15_BASE+0x003)
#define DIGCORR_CH15_SC1_CNT_LOC		(DIGCORR_CH15_BASE+0x004)
#define DIGCORR_CH15_SC1_STEP_LOC		(DIGCORR_CH15_BASE+0x005)
#define DIGCORR_CH15_DZ1_CNT_LOC		(DIGCORR_CH15_BASE+0x006)
#define DIGCORR_CH15_DZ1_STEP_LOC		(DIGCORR_CH15_BASE+0x007)

#define DIGCORR_CR_LOC					(DIGCORR_GENREG_BASE+0x000)
#define DIGCORR_SR_LOC					(DIGCORR_GENREG_BASE+0x001)
#define DIGCORR_LEN_LOC					(DIGCORR_GENREG_BASE+0x002)
#define DIGCORR_TST_LOC					(DIGCORR_GENREG_BASE+0x003)
#define DIGCORR_IRQ_LOC					(DIGCORR_GENREG_BASE+0x004)
#define DIGCORR_CFG_LOC					(DIGCORR_GENREG_BASE+0x005)
// DIGCORR REG
#define DIGCORR_CR_EN0_MASK				CREATE_BIT_MASK (0,0)
#define DIGCORR_CR_EN1_MASK				CREATE_BIT_MASK (1,1)
#define DIGCORR_CR_EN2_MASK				CREATE_BIT_MASK (2,2)
#define DIGCORR_CR_EN3_MASK				CREATE_BIT_MASK (3,3)
#define DIGCORR_CR_EN4_MASK				CREATE_BIT_MASK (4,4)
#define DIGCORR_CR_EN5_MASK				CREATE_BIT_MASK (5,5)
#define DIGCORR_CR_EN6_MASK				CREATE_BIT_MASK (6,6)
#define DIGCORR_CR_EN7_MASK				CREATE_BIT_MASK (7,7)
#define DIGCORR_CR_EN8_MASK				CREATE_BIT_MASK (8,8)
#define DIGCORR_CR_EN9_MASK				CREATE_BIT_MASK (9,9)
#define DIGCORR_CR_EN10_MASK			CREATE_BIT_MASK (10,10)
#define DIGCORR_CR_EN11_MASK			CREATE_BIT_MASK (11,11)
#define DIGCORR_CR_EN12_MASK			CREATE_BIT_MASK (12,12)
#define DIGCORR_CR_EN13_MASK			CREATE_BIT_MASK (13,13)
#define DIGCORR_CR_EN14_MASK			CREATE_BIT_MASK (14,14)
#define DIGCORR_CR_EN15_MASK			CREATE_BIT_MASK (15,15)
#define DIGCORR_CR_IE0_MASK				CREATE_BIT_MASK (16,16)
#define DIGCORR_CR_IE1_MASK				CREATE_BIT_MASK (17,17)
#define DIGCORR_CR_IE2_MASK				CREATE_BIT_MASK (18,18)
#define DIGCORR_CR_IE3_MASK				CREATE_BIT_MASK (19,19)
#define DIGCORR_CR_IE4_MASK				CREATE_BIT_MASK (20,20)
#define DIGCORR_CR_IE5_MASK				CREATE_BIT_MASK (21,21)
#define DIGCORR_CR_IE6_MASK				CREATE_BIT_MASK (22,22)
#define DIGCORR_CR_IE7_MASK				CREATE_BIT_MASK (23,23)
#define DIGCORR_CR_IE8_MASK				CREATE_BIT_MASK (24,24)
#define DIGCORR_CR_IE9_MASK				CREATE_BIT_MASK (25,25)
#define DIGCORR_CR_IE10_MASK			CREATE_BIT_MASK (26,26)
#define DIGCORR_CR_IE11_MASK			CREATE_BIT_MASK (27,27)
#define DIGCORR_CR_IE12_MASK			CREATE_BIT_MASK (28,28)
#define DIGCORR_CR_IE13_MASK			CREATE_BIT_MASK (29,29)
#define DIGCORR_CR_IE14_MASK			CREATE_BIT_MASK (30,30)
#define DIGCORR_CR_IE15_MASK			CREATE_BIT_MASK (31,31)

#define DIGCORR_SR_PPS0_MASK			CREATE_BIT_MASK (0,0)
#define DIGCORR_SR_PPS1_MASK			CREATE_BIT_MASK (1,1)
#define DIGCORR_SR_PPS2_MASK			CREATE_BIT_MASK (2,2)
#define DIGCORR_SR_PPS3_MASK			CREATE_BIT_MASK (3,3)
#define DIGCORR_SR_PPS4_MASK			CREATE_BIT_MASK (4,4)
#define DIGCORR_SR_PPS5_MASK			CREATE_BIT_MASK (5,5)
#define DIGCORR_SR_PPS6_MASK			CREATE_BIT_MASK (6,6)
#define DIGCORR_SR_PPS7_MASK			CREATE_BIT_MASK (7,7)
#define DIGCORR_SR_PPS8_MASK			CREATE_BIT_MASK (8,8)
#define DIGCORR_SR_PPS9_MASK			CREATE_BIT_MASK (9,9)
#define DIGCORR_SR_PPS10_MASK			CREATE_BIT_MASK (10,10)
#define DIGCORR_SR_PPS11_MASK			CREATE_BIT_MASK (11,11)
#define DIGCORR_SR_PPS12_MASK			CREATE_BIT_MASK (12,12)
#define DIGCORR_SR_PPS13_MASK			CREATE_BIT_MASK (13,13)
#define DIGCORR_SR_PPS14_MASK			CREATE_BIT_MASK (14,14)
#define DIGCORR_SR_PPS15_MASK			CREATE_BIT_MASK (15,15)
#define DIGCORR_SR_ERR0_MASK			CREATE_BIT_MASK (16,16)
#define DIGCORR_SR_ERR1_MASK			CREATE_BIT_MASK (17,17)
#define DIGCORR_SR_ERR2_MASK			CREATE_BIT_MASK (18,18)
#define DIGCORR_SR_ERR3_MASK			CREATE_BIT_MASK (19,19)
#define DIGCORR_SR_ERR4_MASK			CREATE_BIT_MASK (20,20)
#define DIGCORR_SR_ERR5_MASK			CREATE_BIT_MASK (21,21)
#define DIGCORR_SR_ERR6_MASK			CREATE_BIT_MASK (22,22)
#define DIGCORR_SR_ERR7_MASK			CREATE_BIT_MASK (23,23)
#define DIGCORR_SR_ERR8_MASK			CREATE_BIT_MASK (24,24)
#define DIGCORR_SR_ERR9_MASK			CREATE_BIT_MASK (25,25)
#define DIGCORR_SR_ERR10_MASK			CREATE_BIT_MASK (26,26)
#define DIGCORR_SR_ERR11_MASK			CREATE_BIT_MASK (27,27)
#define DIGCORR_SR_ERR12_MASK			CREATE_BIT_MASK (28,28)
#define DIGCORR_SR_ERR13_MASK			CREATE_BIT_MASK (29,29)
#define DIGCORR_SR_ERR14_MASK			CREATE_BIT_MASK (30,30)
#define DIGCORR_SR_ERR15_MASK			CREATE_BIT_MASK (31,31)

#define DIGCORR_CFG_TESTM_MASK			CREATE_BIT_MASK (0,0)
#define DIGCORR_CFG_NPS0_MASK			CREATE_BIT_MASK (1,1)
#define DIGCORR_CFG_NPS1_MASK			CREATE_BIT_MASK (2,2)
#define DIGCORR_CFG_GENBIT_MASK			CREATE_BIT_MASK (3,3)
#define DIGCORR_CFG_RSV_MASK			CREATE_BIT_MASK (31,4)

#define DIGCORR_IRQ_RQST0_MASK			CREATE_BIT_MASK (0,0)
#define DIGCORR_IRQ_RQST1_MASK			CREATE_BIT_MASK (1,1)
#define DIGCORR_IRQ_RQST2_MASK			CREATE_BIT_MASK (2,2)
#define DIGCORR_IRQ_RQST3_MASK			CREATE_BIT_MASK (3,3)
#define DIGCORR_IRQ_RQST4_MASK			CREATE_BIT_MASK (4,4)
#define DIGCORR_IRQ_RQST5_MASK			CREATE_BIT_MASK (5,5)
#define DIGCORR_IRQ_RQST6_MASK			CREATE_BIT_MASK (6,6)
#define DIGCORR_IRQ_RQST7_MASK			CREATE_BIT_MASK (7,7)
#define DIGCORR_IRQ_RQST8_MASK			CREATE_BIT_MASK (8,8)
#define DIGCORR_IRQ_RQST9_MASK			CREATE_BIT_MASK (9,9)
#define DIGCORR_IRQ_RQST10_MASK			CREATE_BIT_MASK (10,10)
#define DIGCORR_IRQ_RQST11_MASK			CREATE_BIT_MASK (11,11)
#define DIGCORR_IRQ_RQST12_MASK			CREATE_BIT_MASK (12,12)
#define DIGCORR_IRQ_RQST13_MASK			CREATE_BIT_MASK (13,13)
#define DIGCORR_IRQ_RQST14_MASK			CREATE_BIT_MASK (14,14)
#define DIGCORR_IRQ_RQST15_MASK			CREATE_BIT_MASK (15,15)
#define DIGCORR_IRQ_RSV_MASK			CREATE_BIT_MASK (31,16)

//-------------------------------------------------------//
// MILSTD
#define MILSTD0_DT_LOC			(MILSTD0_BASE + 0x000)
#define MILSTD0_CONTROL_LOC 	(MILSTD0_BASE + 0x400)
#define MILSTD0_STATUS_LOC 		(MILSTD0_BASE + 0x401)
#define MILSTD0_ERROR_LOC 		(MILSTD0_BASE + 0x402)
#define MILSTD0_COMMWORD1_LOC 	(MILSTD0_BASE + 0x403)
#define MILSTD0_COMMWORD2_LOC 	(MILSTD0_BASE + 0x404)
#define MILSTD0_MODEDATA_LOC 	(MILSTD0_BASE + 0x405)
#define MILSTD0_STATWORD1_LOC 	(MILSTD0_BASE + 0x406)
#define MILSTD0_STATWORD2_LOC 	(MILSTD0_BASE + 0x407)
#define MILSTD0_INTEN_LOC 		(MILSTD0_BASE + 0x408)
#define MILSTD0_MSG_LOC 		(MILSTD0_BASE + 0x409)
#define MILSTD0_DR_LOC	  		(MILSTD0_BASE + 0x800)

#define MILSTD1_DT_LOC			(MILSTD1_BASE + 0x000)
#define MILSTD1_CONTROL_LOC 	(MILSTD1_BASE + 0x400)
#define MILSTD1_STATUS_LOC 		(MILSTD1_BASE + 0x401)
#define MILSTD1_ERROR_LOC 		(MILSTD1_BASE + 0x402)
#define MILSTD1_COMMWORD1_LOC 	(MILSTD1_BASE + 0x403)
#define MILSTD1_COMMWORD2_LOC 	(MILSTD1_BASE + 0x404)
#define MILSTD1_MODEDATA_LOC 	(MILSTD1_BASE + 0x405)
#define MILSTD1_STATWORD1_LOC 	(MILSTD1_BASE + 0x406)
#define MILSTD1_STATWORD2_LOC 	(MILSTD1_BASE + 0x407)
#define MILSTD1_INTEN_LOC 		(MILSTD1_BASE + 0x408)
#define MILSTD1_MSG_LOC 		(MILSTD1_BASE + 0x409)
#define MILSTD1_DR_LOC	  		(MILSTD1_BASE + 0x800)

#define MILSTD_CONTROL_MR_MASK					CREATE_BIT_MASK (0,0)
#define MILSTD_CONTROL_BCSTART_MASK				CREATE_BIT_MASK (1,1)
#define MILSTD_CONTROL_MODE_MASK				CREATE_BIT_MASK (3,2)
#define MILSTD_CONTROL_TRA_MASK					CREATE_BIT_MASK (4,4)
#define MILSTD_CONTROL_TRB_MASK					CREATE_BIT_MASK (5,5)
#define MILSTD_CONTROL_RTA_MASK					CREATE_BIT_MASK (10,6)
#define MILSTD_CONTROL_DIV6_0_MASK   			CREATE_BIT_MASK (17,11)
#define MILSTD_CONTROL_RERR_MASK				CREATE_BIT_MASK (18,18)
#define MILSTD_CONTROL_INVTR_MASK				CREATE_BIT_MASK (19,19)
#define MILSTD_CONTROL_ENFILTER_MASK			CREATE_BIT_MASK (20,20)
#define MILSTD_CONTROL_AUTOTUNE_MASK			CREATE_BIT_MASK (21,21)
#define MILSTD_CONTROL_ENFILTER3_MASK   		CREATE_BIT_MASK (22,22)
#define MILSTD_CONTROL_EN_XRTA_MASK   			CREATE_BIT_MASK (23,23)
#define MILSTD_CONTROL_DIV7_MASK 				CREATE_BIT_MASK (24,24)
#define MILSTD_CONTROL_SYNC_DM_MASK   			CREATE_BIT_MASK (25,25)
#define MILSTD_CONTROL_RSV_MASK 				CREATE_BIT_MASK (31,26)

#define MILSTD_STATUS_IDLE_MASK					CREATE_BIT_MASK (0,0)
#define MILSTD_STATUS_RFLAGN_MASK				CREATE_BIT_MASK (1,1)
#define MILSTD_STATUS_VALMESS_MASK				CREATE_BIT_MASK (2,2)
#define MILSTD_STATUS_ERR_MASK					CREATE_BIT_MASK (3,3)
#define MILSTD_STATUS_RCVA_MASK					CREATE_BIT_MASK (4,4)
#define MILSTD_STATUS_RCVB_MASK					CREATE_BIT_MASK (5,5)
#define MILSTD_STATUS_RSV_MASK 					CREATE_BIT_MASK (31,6)

#define MILSTD_ERROR_NORCV_MASK					CREATE_BIT_MASK (0,0)
#define MILSTD_ERROR_MANERR_MASK				CREATE_BIT_MASK (1,1)
#define MILSTD_ERROR_SYNCERR_MASK				CREATE_BIT_MASK (2,2)
#define MILSTD_ERROR_DSYCERR_MASK				CREATE_BIT_MASK (2,2)
#define MILSTD_ERROR_CSYCERR_MASK				CREATE_BIT_MASK (3,3)
#define MILSTD_ERROR_SEQERR_MASK				CREATE_BIT_MASK (3,3)
#define MILSTD_ERROR_GAPERR_MASK				CREATE_BIT_MASK (4,4)
#define MILSTD_ERROR_CONERR_MASK				CREATE_BIT_MASK (5,5)
#define MILSTD_ERROR_PROERR_MASK				CREATE_BIT_MASK (6,6)
#define MILSTD_ERROR_RTAERR_MASK				CREATE_BIT_MASK (7,7)
#define MILSTD_ERROR_RSV_MASK 					CREATE_BIT_MASK (31,8)

#define MILSTD_COMMWORD_CODECOMM_MASK			CREATE_BIT_MASK (4,0)
#define MILSTD_COMMWORD_SUBADDR_MASK			CREATE_BIT_MASK (9,5)
#define MILSTD_COMMWORD_TXRX_MASK				CREATE_BIT_MASK (10,10)
#define MILSTD_COMMWORD_RTA_MASK				CREATE_BIT_MASK (15,11)
#define MILSTD_COMMWORD_RSV_MASK				CREATE_BIT_MASK (31,16)

#define MILSTD_COMMWORD1_CODECOMM_MASK			MILSTD_COMMWORD_CODECOMM_MASK
#define MILSTD_COMMWORD1_SUBADDR_MASK			MILSTD_COMMWORD_SUBADDR_MASK
#define MILSTD_COMMWORD1_TXRX_MASK				MILSTD_COMMWORD_TXRX_MASK
#define MILSTD_COMMWORD1_RTA_MASK				MILSTD_COMMWORD_RTA_MASK
#define MILSTD_COMMWORD1_RSV_MASK				MILSTD_COMMWORD_RSV_MASK

#define MILSTD_COMMWORD2_CODECOMM_MASK			MILSTD_COMMWORD_CODECOMM_MASK
#define MILSTD_COMMWORD2_SUBADDR_MASK			MILSTD_COMMWORD_SUBADDR_MASK
#define MILSTD_COMMWORD2_TXRX_MASK				MILSTD_COMMWORD_TXRX_MASK
#define MILSTD_COMMWORD2_RTA_MASK				MILSTD_COMMWORD_RTA_MASK
#define MILSTD_COMMWORD2_RSV_MASK				MILSTD_COMMWORD_RSV_MASK

#define MILSTD_STATWORD_RT_FAIL_MASK			CREATE_BIT_MASK (0,0)
#define MILSTD_STATWORD_CFG_INTF_ACCEPT_MASK	CREATE_BIT_MASK (1,1)
#define MILSTD_STATWORD_SUB_FAIL_MASK			CREATE_BIT_MASK (2,2)
#define MILSTD_STATWORD_SUB_BUSY_MASK			CREATE_BIT_MASK (3,3)
#define MILSTD_STATWORD_GROUP_COMM_ACCEPT_MASK	CREATE_BIT_MASK (4,4)
#define MILSTD_STATWORD_RSV0_MASK				CREATE_BIT_MASK (7,5)
#define MILSTD_STATWORD_SERVICE_RQST_MASK		CREATE_BIT_MASK (8,8)
#define MILSTD_STATWORD_TRAN_ANSWER_WORD_MASK	CREATE_BIT_MASK (9,9)
#define MILSTD_STATWORD_MSG_ERR_MASK			CREATE_BIT_MASK (10,10)
#define MILSTD_STATWORD_RTA_MASK				CREATE_BIT_MASK (15,11)
#define MILSTD_STATWORD_RSV1_MASK				CREATE_BIT_MASK (31,16)

#define MILSTD_STATWORD1_RT_FAIL_MASK			MILSTD_STATWORD_RT_FAIL_MASK
#define MILSTD_STATWORD1_CFG_INTF_ACCEPT_MASK	MILSTD_STATWORD_CFG_INTF_ACCEPT_MASK
#define MILSTD_STATWORD1_SUB_FAIL_MASK			MILSTD_STATWORD_SUB_FAIL_MASK
#define MILSTD_STATWORD1_SUB_BUSY_MASK			MILSTD_STATWORD_SUB_BUSY_MASK
#define MILSTD_STATWORD1_GROUP_COMM_ACCEPT_MASK	MILSTD_STATWORD_GROUP_COMM_ACCEPT_MASK
#define MILSTD_STATWORD1_SERVICE_RQST_MASK		MILSTD_STATWORD_SERVICE_RQST_MASK
#define MILSTD_STATWORD1_TRAN_ANSWER_WORD_MASK	MILSTD_STATWORD_TRAN_ANSWER_WORD_MASK
#define MILSTD_STATWORD1_MSG_ERR_MASK			MILSTD_STATWORD_MSG_ERR_MASK
#define MILSTD_STATWORD1_RTA_MASK				MILSTD_STATWORD_RTA_MASK
#define MILSTD_STATWORD1_RSV_MASK				MILSTD_STATWORD_RSV_MASK

#define MILSTD_STATWORD2_RT_FAIL_MASK			MILSTD_STATWORD_RT_FAIL_MASK
#define MILSTD_STATWORD2_CFG_INTF_ACCEPT_MASK	MILSTD_STATWORD_CFG_INTF_ACCEPT_MASK
#define MILSTD_STATWORD2_SUB_FAIL_MASK			MILSTD_STATWORD_SUB_FAIL_MASK
#define MILSTD_STATWORD2_SUB_BUSY_MASK			MILSTD_STATWORD_SUB_BUSY_MASK
#define MILSTD_STATWORD2_GROUP_COMM_ACCEPT_MASK	MILSTD_STATWORD_GROUP_COMM_ACCEPT_MASK
#define MILSTD_STATWORD2_SERVICE_RQST_MASK		MILSTD_STATWORD_SERVICE_RQST_MASK
#define MILSTD_STATWORD2_TRAN_ANSWER_WORD_MASK	MILSTD_STATWORD_TRAN_ANSWER_WORD_MASK
#define MILSTD_STATWORD2_MSG_ERR_MASK			MILSTD_STATWORD_MSG_ERR_MASK
#define MILSTD_STATWORD2_RT_ADDR_MASK			MILSTD_STATWORD_RT_ADDR_MASK
#define MILSTD_STATWORD2_RSV_MASK				MILSTD_STATWORD_RSV_MASK

#define MILSTD_INTEN_IDLEIE_MASK				CREATE_BIT_MASK (0,0)
#define MILSTD_INTEN_RFLAGNIE_MASK				CREATE_BIT_MASK (1,1)
#define MILSTD_INTEN_VALMESSIE_MASK				CREATE_BIT_MASK (2,2)
#define MILSTD_INTEN_ERRIE_MASK					CREATE_BIT_MASK (3,3)
#define MILSTD_INTEN_RTAIE_MASK					CREATE_BIT_MASK (4,4)
#define MILSTD_INTEN_RSV_MASK					CREATE_BIT_MASK (31,5)

/*------------------------------------- ARINC ------------------------------------*/
// ARINC RX
#define base_ARINT_RX_CH0			(base_ARINC_RX+0x000)
#define base_ARINT_RX_CH1			(base_ARINC_RX+0x004)
#define base_ARINT_RX_CH2			(base_ARINC_RX+0x008)
#define base_ARINT_RX_CH3			(base_ARINC_RX+0x00C)
#define base_ARINT_RX_CH4			(base_ARINC_RX+0x010)
#define base_ARINT_RX_CH5			(base_ARINC_RX+0x014)
#define base_ARINT_RX_CH6			(base_ARINC_RX+0x018)
#define base_ARINT_RX_CH7			(base_ARINC_RX+0x01C)

#define ARINC_RX_CH0_CR_LOC			(base_ARINC_RX_CH0+0x000)
#define ARINC_RX_CH0_RSV_LOC		(base_ARINC_RX_CH0+0x001)
#define ARINC_RX_CH0_DATA_LOC		(base_ARINC_RX_CH0+0x002)
#define ARINC_RX_CH0_STATUS_LOC		(base_ARINC_RX_CH0+0x003)

#define ARINC_RX_CH1_CR_LOC			(base_ARINC_RX_CH1+0x000)
#define ARINC_RX_CH1_RSV_LOC		(base_ARINC_RX_CH1+0x001)
#define ARINC_RX_CH1_DATA_LOC		(base_ARINC_RX_CH1+0x002)
#define ARINC_RX_CH1_STATUS_LOC		(base_ARINC_RX_CH1+0x003)

#define ARINC_RX_CH2_CR_LOC			(base_ARINC_RX_CH2+0x000)
#define ARINC_RX_CH2_RSV_LOC		(base_ARINC_RX_CH2+0x001)
#define ARINC_RX_CH2_DATA_LOC		(base_ARINC_RX_CH2+0x002)
#define ARINC_RX_CH2_STATUS_LOC		(base_ARINC_RX_CH2+0x003)

#define ARINC_RX_CH3_CR_LOC			(base_ARINC_RX_CH3+0x000)
#define ARINC_RX_CH3_RSV_LOC		(base_ARINC_RX_CH3+0x001)
#define ARINC_RX_CH3_DATA_LOC		(base_ARINC_RX_CH3+0x002)
#define ARINC_RX_CH3_STATUS_LOC		(base_ARINC_RX_CH3+0x003)

#define ARINC_RX_CH4_CR_LOC			(base_ARINC_RX_CH4+0x000)
#define ARINC_RX_CH4_RSV_LOC		(base_ARINC_RX_CH4+0x001)
#define ARINC_RX_CH4_DATA_LOC		(base_ARINC_RX_CH4+0x002)
#define ARINC_RX_CH4_STATUS_LOC		(base_ARINC_RX_CH4+0x003)

#define ARINC_RX_CH5_CR_LOC			(base_ARINC_RX_CH5+0x000)
#define ARINC_RX_CH5_RSV_LOC		(base_ARINC_RX_CH5+0x001)
#define ARINC_RX_CH5_DATA_LOC		(base_ARINC_RX_CH5+0x002)
#define ARINC_RX_CH5_STATUS_LOC		(base_ARINC_RX_CH5+0x003)

#define ARINC_RX_CH6_CR_LOC			(base_ARINC_RX_CH6+0x000)
#define ARINC_RX_CH6_RSV_LOC		(base_ARINC_RX_CH6+0x001)
#define ARINC_RX_CH6_DATA_LOC		(base_ARINC_RX_CH6+0x002)
#define ARINC_RX_CH6_STATUS_LOC		(base_ARINC_RX_CH6+0x003)

#define ARINC_RX_CH7_CR_LOC			(base_ARINC_RX_CH7+0x000)
#define ARINC_RX_CH7_RSV_LOC		(base_ARINC_RX_CH7+0x001)
#define ARINC_RX_CH7_DATA_LOC		(base_ARINC_RX_CH7+0x002)
#define ARINC_RX_CH7_STATUS_LOC		(base_ARINC_RX_CH7+0x003)

#define ARINC_RX_MEM0_LOC			(base_ARINC_RX_MEM+0x000)
#define ARINC_RX_MEM1_LOC			(base_ARINC_RX_MEM+0x100)
#define ARINC_RX_MEM2_LOC			(base_ARINC_RX_MEM+0x200)
#define ARINC_RX_MEM3_LOC			(base_ARINC_RX_MEM+0x240)
#define ARINC_RX_MEM4_LOC			(base_ARINC_RX_MEM+0x280)
#define ARINC_RX_MEM5_LOC			(base_ARINC_RX_MEM+0x2C0)
#define ARINC_RX_MEM6_LOC			(base_ARINC_RX_MEM+0x300)
#define ARINC_RX_MEM7_LOC			(base_ARINC_RX_MEM+0x320)
#define ARINC_RX_LABEL0_LOC			(base_ARINC_RX_MEM+0x3C0)
#define ARINC_RX_LABEL1_LOC			(base_ARINC_RX_MEM+0x3C8)
#define ARINC_RX_LABEL2_LOC			(base_ARINC_RX_MEM+0x3D0)
#define ARINC_RX_LABEL3_LOC			(base_ARINC_RX_MEM+0x3D8)
#define ARINC_RX_LABEL4_LOC			(base_ARINC_RX_MEM+0x3E0)
#define ARINC_RX_LABEL5_LOC			(base_ARINC_RX_MEM+0x3E8)
#define ARINC_RX_LABEL6_LOC			(base_ARINC_RX_MEM+0x3F0)
#define ARINC_RX_LABEL7_LOC			(base_ARINC_RX_MEM+0x3F8)

// ARINC TX
#define base_ARINT_TX_CH0			(base_ARINC_TX+0x000)
#define base_ARINT_TX_CH1			(base_ARINC_TX+0x004)
#define base_ARINT_TX_CH2			(base_ARINC_TX+0x008)
#define base_ARINT_TX_CH3			(base_ARINC_TX+0x00C)

#define ARINC_TX_CH0_CR_LOC			(base_ARINC_TX_CH0+0x000)
#define ARINC_TX_CH0_RSV_LOC		(base_ARINC_TX_CH0+0x001)
#define ARINC_TX_CH0_DATA_LOC		(base_ARINC_TX_CH0+0x002)
#define ARINC_TX_CH0_STATUS_LOC		(base_ARINC_TX_CH0+0x003)

#define ARINC_TX_CH1_CR_LOC			(base_ARINC_TX_CH1+0x000)
#define ARINC_TX_CH1_RSV_LOC		(base_ARINC_TX_CH1+0x001)
#define ARINC_TX_CH1_DATA_LOC		(base_ARINC_TX_CH1+0x002)
#define ARINC_TX_CH1_STATUS_LOC		(base_ARINC_TX_CH1+0x003)

#define ARINC_TX_CH2_CR_LOC			(base_ARINC_TX_CH2+0x000)
#define ARINC_TX_CH2_RSV_LOC		(base_ARINC_TX_CH2+0x001)
#define ARINC_TX_CH2_DATA_LOC		(base_ARINC_TX_CH2+0x002)
#define ARINC_TX_CH2_STATUS_LOC		(base_ARINC_TX_CH2+0x003)

#define ARINC_TX_CH3_CR_LOC			(base_ARINC_TX_CH3+0x000)
#define ARINC_TX_CH3_RSV_LOC		(base_ARINC_TX_CH3+0x001)
#define ARINC_TX_CH3_DATA_LOC		(base_ARINC_TX_CH3+0x002)
#define ARINC_TX_CH3_STATUS_LOC		(base_ARINC_TX_CH3+0x003)

#define ARINC_TX_MEM0_LOC			(base_ARINC_TX_MEM+0x000)
#define ARINC_TX_MEM1_LOC			(base_ARINC_TX_MEM+0x100)
#define ARINC_TX_MEM2_LOC			(base_ARINC_TX_MEM+0x140)
#define ARINC_TX_MEM3_LOC			(base_ARINC_TX_MEM+0x180)

// ARINC RX REG MASK
#define ARINC_RX_CONTROL_CH_EN_MASK			CREATE_BIT_MASK (0,0)
#define ARINC_RX_CONTROL_CLK_MASK			CREATE_BIT_MASK (1,1)
#define ARINC_RX_CONTROL_LB_EN_MASK			CREATE_BIT_MASK (2,2)
#define ARINC_RX_CONTROL_SD_EN_MASK			CREATE_BIT_MASK (3,3)
#define ARINC_RX_CONTROL_DA_MASK			CREATE_BIT_MASK (4,4)
#define ARINC_RX_CONTROL_SDI1_MASK			CREATE_BIT_MASK (5,5)
#define ARINC_RX_CONTROL_SDI2_MASK			CREATE_BIT_MASK (6,6)
#define ARINC_RX_CONTROL_ENSYNC_MASK		CREATE_BIT_MASK (7,7)
#define ARINC_RX_CONTROL_ENPAR_MASK			CREATE_BIT_MASK (8,8)
#define ARINC_RX_CONTROL_ODD_MASK			CREATE_BIT_MASK (9,9)
#define ARINC_RX_CONTROL_RSV0_MASK			CREATE_BIT_MASK (11,10)
#define ARINC_RX_CONTROL_INTEDR_MASK		CREATE_BIT_MASK (12,12)
#define ARINC_RX_CONTROL_INTEER_MASK		CREATE_BIT_MASK (13,13)
#define ARINC_RX_CONTROL_INTEFF_MASK		CREATE_BIT_MASK (14,14)
#define ARINC_RX_CONTROL_INTEHF_MASK		CREATE_BIT_MASK (15,15)
#define ARINC_RX_CONTROL_DIV_MASK			CREATE_BIT_MASK (23,16)
#define ARINC_RX_CONTROL_RSV1_MASK			CREATE_BIT_MASK (31,24)

#define ARINC_RX_STATUS_DR_MASK				CREATE_BIT_MASK (0,0)
#define ARINC_RX_STATUS_ERR_MASK			CREATE_BIT_MASK (1,1)
#define ARINC_RX_STATUS_FF_MASK  			CREATE_BIT_MASK (2,2)
#define ARINC_RX_STATUS_HF_MASK  			CREATE_BIT_MASK (3,3)
#define ARINC_RX_STATUS_IRQ_DR_MASK  		CREATE_BIT_MASK (4,4)
#define ARINC_RX_STATUS_IRQ_ERR_MASK		CREATE_BIT_MASK (5,5)
#define ARINC_RX_STATUS_IRQ_FF_MASK  		CREATE_BIT_MASK (6,6)
#define ARINC_RX_STATUS_IRQ_HF_MASK  		CREATE_BIT_MASK (7,7)
#define ARINC_RX_STATUS_IRQ_RX_CH0_MASK  	CREATE_BIT_MASK (8,8)
#define ARINC_RX_STATUS_IRQ_RX_CH1_MASK  	CREATE_BIT_MASK (9,9)
#define ARINC_RX_STATUS_IRQ_RX_CH2_MASK  	CREATE_BIT_MASK (10,10)
#define ARINC_RX_STATUS_IRQ_RX_CH3_MASK  	CREATE_BIT_MASK (11,11)
#define ARINC_RX_STATUS_IRQ_RX_CH4_MASK  	CREATE_BIT_MASK (12,12)
#define ARINC_RX_STATUS_IRQ_RX_CH5_MASK  	CREATE_BIT_MASK (13,13)
#define ARINC_RX_STATUS_IRQ_RX_CH6_MASK  	CREATE_BIT_MASK (14,14)
#define ARINC_RX_STATUS_IRQ_RX_CH7_MASK  	CREATE_BIT_MASK (15,15)
#define ARINC_RX_STATUS_CHAN_WP_MASK  		CREATE_BIT_MASK (23,16)
#define ARINC_RX_STATUS_DATA_RP_MASK  		CREATE_BIT_MASK (31,24)

// ARINC TX REG MASK
#define ARINC_TX_CONTROL_CH_EN_MASK  		CREATE_BIT_MASK (0,0)
#define ARINC_TX_CONTROL_CLK_MASK  			CREATE_BIT_MASK (1,1)
#define ARINC_TX_CONTROL_EN_PAR_MASK  		CREATE_BIT_MASK (2,2)
#define ARINC_TX_CONTROL_ODD_MASK  			CREATE_BIT_MASK (3,3)
#define ARINC_TX_CONTROL_INTE_TXR_MASK  	CREATE_BIT_MASK (4,4)
#define ARINC_TX_CONTROL_INTE_FFT_MASK  	CREATE_BIT_MASK (5,5)
#define ARINC_TX_CONTROL_INTE_HFT_MASK  	CREATE_BIT_MASK (6,6)
#define ARINC_TX_CONTROL_ENSYNC_MASK  		CREATE_BIT_MASK (7,7)
#define ARINC_TX_CONTROL_DIV_MASK  			CREATE_BIT_MASK (15,8)
#define ARINC_TX_CONTROL_RSV_MASK 		 	CREATE_BIT_MASK (31,16)

#define ARINC_TX_STATUS_TX_R_MASK  			CREATE_BIT_MASK (0,0)
#define ARINC_TX_STATUS_BUSY_MASK  			CREATE_BIT_MASK (1,1)
#define ARINC_TX_STATUS_FFT_MASK  			CREATE_BIT_MASK (2,2)
#define ARINC_TX_STATUS_HFT_MASK  			CREATE_BIT_MASK (3,3)
#define ARINC_TX_STATUS_IRQ_TXR_MASK  		CREATE_BIT_MASK (4,4)
#define ARINC_TX_STATUS_RSV0_MASK			CREATE_BIT_MASK (5,5)
#define ARINC_TX_STATUS_IRQ_FFT_MASK  		CREATE_BIT_MASK (6,6)
#define ARINC_TX_STATUS_IRQ_HFT_MASK  		CREATE_BIT_MASK (7,7)
#define ARINC_TX_STATUS_IRQ_TX_CH0_MASK  	CREATE_BIT_MASK (8,8)
#define ARINC_TX_STATUS_IRQ_TX_CH1_MASK  	CREATE_BIT_MASK (9,9)
#define ARINC_TX_STATUS_IRQ_TX_CH2_MASK  	CREATE_BIT_MASK (10,10)
#define ARINC_TX_STATUS_IRQ_TX_CH3_MASK  	CREATE_BIT_MASK (11,11)
#define ARINC_TX_STATUS_RSV1_MASK  			CREATE_BIT_MASK (15,12)
#define ARINC_TX_STATUS_DATA_WP_MASK  		CREATE_BIT_MASK (23,16)
#define ARINC_TX_STATUS_CHAN_RP_MASK  		CREATE_BIT_MASK (31,24)

//----------------------------- EXTERNAL PORT --------------------------//
#define SYSCON_BNK0IDLE_P		0
#define SYSCON_BNK0WAIT0_P		1
#define SYSCON_BNK0WAIT1_P		2
#define SYSCON_BNK0PIPE0_P		3
#define SYSCON_BNK0PIPE1_P		4
#define SYSCON_BNK0SLOW_P		5
#define SYSCON_BNK1IDLE_P		6
#define SYSCON_BNK1WAIT0_P		7
#define SYSCON_BNK1WAIT1_P		8
#define SYSCON_BNK1PIPE0_P		9
#define SYSCON_BNK1PIPE1_P		10
#define SYSCON_BNK1SLOW_P		11
#define SYSCON_HOSTIDLE_P		12
#define SYSCON_HOSTWAIT0_P		13
#define SYSCON_HOSTWAIT1_P		14
#define SYSCON_HOSTPIPE0_P		15
#define SYSCON_HOSTPIPE1_P		16
#define SYSCON_HOSTSLOW_P		17
#define SYSCON_MEMWIDTH_P		19
#define SYSCON_EXTINBUF_P		24
#define SYSCON_EXTOUTBUF_P		25
#define SYSCON_SDRAM_ALIAS_P	27																	// SDRAM alias bit. If set, enables SDRAM mirroring from 0x10000000 address

#define SYSCON_SDRAM_ALIAS		(1 << SYSCON_SDRAM_ALIAS_P)

#define SD_REP_LOC				(0x8000009C)

// Conversion from UREG address to {group[5:0], reg[4:0]}
#define ADDR2GROUPREG(x) ( ((x & 0x10000) >> 6) | (x & 0x3FF) )
#define GROUPREG(group, reg) ( ((group & 0x3F) << 5) | (reg & 0x1F) )

// MPU register map
#define MS0_C_LOC		(0x1E03C0)
#define MS0_WT_LOC		(0x1E03C1)
#define MS0_CI_LOC		(0x1E03C2)
#define MS1_C_LOC		(0x1E03C8)
#define MS1_WT_LOC		(0x1E03C9)
#define MS1_CI_LOC		(0x1E03CA)
#define SDR_C_LOC		(0x1E03D0)
#define SDR_WT_LOC		(0x1E03D1)
#define SDR_CI_LOC		(0x1E03D2)
#define PU0_LOC			(0x1E03E0)
#define PU1_LOC			(0x1E03E1)
#define PU2_LOC			(0x1E03E2)
#define PU3_LOC			(0x1E03E3)
#define PU4_LOC			(0x1E03E4)
#define PU5_LOC			(0x1E03E5)
#define PU6_LOC			(0x1E03E6)
#define PU7_LOC			(0x1E03E7)
#define STS_PROT_LOC	(0x1E03E8)
#define MPU_CR_LOC		(0x1E03FC)
#define IDC_CMD_LOC		(0x1E03FD)

// Obsolete
#define MS0_C_CFG   	CACMD0
#define MS0_WT_CFG  	CCAIR0
#define MS0_CI_CFG   	CASTAT0

#define MS1_C_CFG   	CACMD2
#define MS1_WT_CFG  	CCAIR2
#define MS1_CI_CFG   	CASTAT2

#define SDR_C_CFG  		CACMD4
#define SDR_WT_CFG  	CCAIR4
#define SDR_CI_CFG   	CASTAT4

#define CWT_CR   		CACMDB
#define IDC_CR   		CCAIRB

#define PU_M0   		CACMD8
#define PU_M1   		CCAIR8



// Cache:
//
// xxx_C_CFG	<- controls data cache. If bit is 1, data cache for the memory page will be enabled.
// xxx_WT_CFG	<- controls write through option. If bit is 0, write operations will put data into the cache only.
//					If bit is 1, data will get in cache and memory both.
// xxx_WT_CI	<- controls instruction cache, If bit is 1, instruction cache for the memory page will be enabled.
//
// Every bit in these registers defines chaching strategy for a single page. Page size is following:
//	MS0/MS1: 128K words
//	SDRAM:	 512K words	
//

// CWT_CR is the global cache control register:
#define CWT_DC_ON_P		0		// If set, data cache is enabled
#define CWT_IC_ON_P		1		// If set, instruction cache is enabled
#define CWT_EN_2DQW_P	2		// If set, 2 quadwords will be loaded for data cache miss
#define CWT_EN_2IQW_P	3		// If set, 2 quadwords will be loaded for instruction cache miss

#define CWT_DC_ON		(1 << CWT_DC_ON_P)
#define CWT_IC_ON		(1 << CWT_IC_ON_P)
#define CWT_EN_2DQW		(1 << CWT_EN_2DQW_P)
#define CWT_EN_2IQW		(1 << CWT_EN_2IQW_P)


#define CACHE_ALL_PAGES				0xFFFFFFFF
#define CACHE_NONE					0x00

#define WRITE_THROUGH_ALL_PAGES		0xFFFFFFFF
#define WRITE_THROUGH_NONE			0x00

#define DCACHE_LOAD_1QW_ON_MISS		( CWT_DC_ON )
#define DCACHE_LOAD_2QW_ON_MISS		( CWT_DC_ON | CWT_EN_2DQW )
#define DCACHE_OFF					0x00

#define ICACHE_LOAD_1QW_ON_MISS		( CWT_IC_ON )
#define ICACHE_LOAD_2QW_ON_MISS		( CWT_IC_ON | CWT_EN_2IQW )
#define ICACHE_OFF					0x00
  

#define U8 \
    trap 16 
#define S8 \
    trap 17
#define PI8 \
    trap 20    
#define U16 \
    trap 18 
#define S16 \
    trap 19
#define PI8U \
    trap 21        
#define PI16 \
    trap 22    
#define PI16U \
    trap 23

#define to_U8 \
    trap 24     
#define to_U8R \
    trap 25    
#define to_U16 \
    trap 24     
#define to_U16R \
    trap 25             
#define to_Sign \
    trap 26
#define ZifNeg \
    trap 26				
#define bias \
    trap 26				
#define IF_EQ \
    trap 28    
#define IF_GE \
    trap 29    
#define IF_GT \
    trap 30

#define exe_RMW \
    trap 31


//-------------------------------------------------------//
// Interrupt
// This section expands ts201 definitions

// Mask bits
#define INT_GPIO_P			(1)
#define INT_UART0_P			(4)
#define INT_UART1_P			(5)
#define INT_NANDF_P			(10)
#define INT_MIL0_P			(11)
#define INT_MIL1_P			(12)
#define INT_DCOR_P			(13)
#define INT_ARINCRX_P		(18)
#define INT_ARINCTX_P		(20)
#define INT_ADDA0_P			(1)
#define INT_ADDA1_P			(2)
#define INT_ADDA2_P			(3)
#define INT_ADDA3_P			(4)
#define INT_LCD_P			(7)
#define INT_SPI_P			(13)
#define INT_SSI0_P			(14)
#define INT_SSI1_P			(15)
#define INT_VCAM_P			(17)
#define INT_H264_P			(19)
#define INT_ALARM_P			(22)
#define INT_TIC_P			(23)
#define INT_WDOG_P			(24)

// Low
#define INT_GPIO			(1<<INT_GPIO_P)		//Level
#define INT_UART0			(1<<INT_UART0_P)	//Level
#define INT_UART1			(1<<INT_UART1_P)	//Level
#define INT_NANDF			(1<<INT_NANDF_P)	//Level
#define INT_MIL0			(1<<INT_MIL0_P)		//E
#define INT_MIL1			(1<<INT_MIL1_P)		//E
#define INT_DCOR			(1<<INT_DCOR_P)		//Level - docs are wrong
#define INT_ARINCRX			(1<<INT_ARINCRX_P)	//Level
#define INT_ARINCTX			(1<<INT_ARINCTX_P)	//Level
// High
#define INT_ADDA0			(1<<INT_ADDA0_P)	//E
#define INT_ADDA1			(1<<INT_ADDA1_P)	//E
#define INT_ADDA2			(1<<INT_ADDA2_P)	//E
#define INT_ADDA3			(1<<INT_ADDA3_P)	//E
#define INT_LCD				(1<<INT_LCD_P)		//Level
#define INT_SPI				(1<<INT_SPI_P)		//Level
#define INT_SSI0			(1<<INT_SSI0_P)		//Level
#define INT_SSI1			(1<<INT_SSI1_P)		//Level
#define INT_VCAM			(1<<INT_VCAM_P)		//Level
#define INT_H264			(1<<INT_H264_P)		//Level
#define INT_ALARM			(1<<INT_ALARM_P)	//E
#define INT_TIC				(1<<INT_TIC_P)		//E
#define INT_WDOG			(1<<INT_WDOG_P)		//E



// Interrupt controller register map
#define IV_KERNEL_LOC		(IVT_BASE + 0x00)
#define IV_GPIO_LOC			(IVT_BASE + 0x01)
#define IV_TIMER0LP_LOC		(IVT_BASE + 0x02)
#define IV_TIMER1LP_LOC		(IVT_BASE + 0x03)
#define IV_UART0_LOC		(IVT_BASE + 0x04)
#define IV_UART1_LOC		(IVT_BASE + 0x05)
#define IV_LINK0_LOC		(IVT_BASE + 0x06)
#define IV_LINK1_LOC		(IVT_BASE + 0x07)
#define IV_LINK2_LOC		(IVT_BASE + 0x08)	// for compability
#define IV_LINK3_LOC		(IVT_BASE + 0x09)	// for compability
#define IV_NANDF_LOC		(IVT_BASE + 0x0A)
#define IV_MIL0_LOC			(IVT_BASE + 0x0B)	// Manchester 0
#define IV_MIL1_LOC			(IVT_BASE + 0x0C)	// Manchecter 1
#define IV_DCOR_LOC			(IVT_BASE + 0x0D)	// Digital correlator
#define IV_DMA0_LOC			(IVT_BASE + 0x0E)
#define IV_DMA1_LOC			(IVT_BASE + 0x0F)
#define IV_DMA2_LOC			(IVT_BASE + 0x10)
#define IV_DMA3_LOC			(IVT_BASE + 0x11)
#define IV_ARINCRX_LOC		(IVT_BASE + 0x12)
//#define IV_xxx_LOC		(IVT_BASE + 0x13)	// reserved
#define IV_ARINCTX_LOC		(IVT_BASE + 0x14)
//#define IV_xxx_LOC		(IVT_BASE + 0x15)	// reserved
#define IV_DMA4_LOC		(IVT_BASE + 0x16)
#define IV_DMA5_LOC		(IVT_BASE + 0x17)
#define IV_DMA6_LOC		(IVT_BASE + 0x18)
#define IV_DMA7_LOC		(IVT_BASE + 0x19)
//#define IV_xxx_LOC		(IVT_BASE + 0x1A)	// reserved
//#define IV_xxx_LOC		(IVT_BASE + 0x1B)	// reserved
//#define IV_xxx_LOC		(IVT_BASE + 0x1C)	// reserved
#define IV_DMA8_LOC		(IVT_BASE + 0x1D)
#define IV_DMA9_LOC		(IVT_BASE + 0x1E)
#define IV_DMA10_LOC	(IVT_BASE + 0x1F)
// 
#define IV_DMA11_LOC	(IVT_BASE + 0x20)
#define IV_ADDA0_LOC	(IVT_BASE + 0x21)
#define IV_ADDA1_LOC	(IVT_BASE + 0x22)
#define IV_ADDA2_LOC	(IVT_BASE + 0x23)
#define IV_ADDA3_LOC	(IVT_BASE + 0x24)
#define IV_DMA12_LOC	(IVT_BASE + 0x25)
#define IV_HOST_LOC		(IVT_BASE + 0x26)
#define IV_LCD_LOC		(IVT_BASE + 0x27)
//#define IV_xxx_LOC		(IVT_BASE + 0x28)	// reserved
#define IV_IRQ0_LOC		(IVT_BASE + 0x29)
#define IV_IRQ1_LOC		(IVT_BASE + 0x2A)
#define IV_IRQ2_LOC		(IVT_BASE + 0x2B)
#define IV_IRQ3_LOC		(IVT_BASE + 0x2C)
#define IV_SPI_LOC		(IVT_BASE + 0x2D)
#define IV_SSI0_LOC		(IVT_BASE + 0x2E)
#define IV_SSI1_LOC		(IVT_BASE + 0x2F)
#define IV_VECTOR_LOC	(IVT_BASE + 0x30)
#define IV_VCAM_LOC		(IVT_BASE + 0x31)
#define IV_BUSLOCK_LOC	(IVT_BASE + 0x32)
#define IV_H264_LOC		(IVT_BASE + 0x33)
#define IV_TIMER0HP_LOC	(IVT_BASE + 0x34)
#define IV_TIMER1HP_LOC	(IVT_BASE + 0x35)
#define IV_ALARM_LOC	(IVT_BASE + 0x36)
#define IV_TIC_LOC		(IVT_BASE + 0x37)
#define IV_WDOG_LOC		(IVT_BASE + 0x38)
#define IV_HWERR_LOC	(IVT_BASE + 0x39)
//#define IV_xxx_LOC		(IVT_BASE + 0x3A)	// reserved
//#define IV_xxx_LOC		(IVT_BASE + 0x3B)
//#define IV_xxx_LOC		(IVT_BASE + 0x3C)
//#define IV_xxx_LOC		(IVT_BASE + 0x3D)
//#define IV_xxx_LOC		(IVT_BASE + 0x3E)
//#define IV_xxx_LOC		(IVT_BASE + 0x3F)



#define uart_PUC   2
#define uart_PUR   5
#define uart_DR    0
#define uart_SR    8


//-------------------------------------------------------//
// RTC
#define RTC_CNT_offset		0x00
#define RTC_MR_offset		0x01
#define WDT_CNT_offset		0x02
#define RTC_TDIV_offset		0x03
#define RTC_CR_offset		0x04
#define RTC_SDIV_offset		0x05
#define TIC_VAL_offset		0x06
#define SEC_VAL_offset		0x07
#define RTC_BUSY_offset		0x08
#define RTC_CNT_LOC			(RTC_BASE + RTC_CNT_offset)
#define RTC_MR_LOC			(RTC_BASE + RTC_MR_offset)
#define WDT_CNT_LOC			(RTC_BASE + WDT_CNT_offset)
#define RTC_TDIV_LOC		(RTC_BASE + RTC_TDIV_offset)
#define RTC_CR_LOC			(RTC_BASE + RTC_CR_offset)
#define RTC_SDIV_LOC		(RTC_BASE + RTC_SDIV_offset)
#define TIC_VAL_LOC			(RTC_BASE + TIC_VAL_offset)
#define SEC_VAL_LOC			(RTC_BASE + SEC_VAL_offset)
#define RTC_BUSY_LOC		(RTC_BASE + RTC_BUSY_offset)

// RTC_CR register bits
#define RTC_CR_WDT_RESEN_P		2
#define RTC_CR_FREEZE_P			3
#define RTC_CR_WDT_SEL_P		4
#define RTC_CR_LOCK_P			7
#define RTC_CR_DIS_TICINTA_P	8
#define RTC_CR_DIS_DOGINTA_P	9
#define RTC_CR_DIS_MRINTA_P		10

#define RTC_CR_WDT_RESEN		(1<<RTC_CR_WDT_RESEN_P)
#define RTC_CR_FREEZE			(1<<RTC_CR_FREEZE_P)
#define RTC_CR_WDT_SEL			(0x7<<RTC_CR_WDT_SEL_P)
#define RTC_CR_LOCK				(1<<RTC_CR_LOCK_P)
#define RTC_CR_DIS_TICAINT		(1<<RTC_CR_DIS_TICINTA_P)
#define RTC_CR_DIS_DOGAINT		(1<<RTC_CR_DIS_DOGINTA_P)
#define RTC_CR_DIS_MRAINT		(1<<RTC_CR_DIS_MRINTA_P)





//-------------------------------------------------------//
// GPIO
// write 0x01 to LOAD location sets Portx = 0x01
// write 0x01 to SET location sets Portx[0]
// write 0x01 to CLEAR location clears Portx[0]

#define PiDR_LOAD_offset		0
#define PiDR_SET_offset			1
#define PiDR_CLEAR_offset		2
#define PiDR_INV_offset			3
#define PiDDR_LOAD_offset		4
#define PiDDR_SET_offset		5
#define PiDDR_CLEAR_offset		6
#define PiDDR_INV_offset		7
#define PiPEIE_LOAD_offset		8
#define PiPEIE_SET_offset		9
#define PiPEIE_CLEAR_offset		10
#define PiPEIE_INV_offset		11
#define PiNEIE_LOAD_offset		12
#define PiNEIE_SET_offset		13
#define PiNEIE_CLEAR_offset		14
#define PiNEIE_INV_offset		15
#define PiINVR_LOAD_offset		16
#define PiINVR_SET_offset		17
#define PiINVR_CLEAR_offset		18
#define PiINVR_INV_offset		19
#define PiIMR_LOAD_offset		20
#define PiIMR_SET_offset		21
#define PiIMR_CLEAR_offset		22
#define PiIMR_INV_offset		23
#define PiALT_LOAD_offset		24
#define PiALT_SET_offset		25
#define PiALT_CLEAR_offset		26
#define PiALT_INV_offset		27
#define PiPUR_LOAD_offset		28
#define PiPUR_SET_offset		29
#define PiPUR_CLEAR_offset		30
#define PiPUR_INV_offset		31
#define PiPXD_offset			32
#define PiINTREQ_offset			33
#define PiECLR_offset			35


// GPA
#define GPA_DR_LOAD_LOC			(GPA_BASE + PiDR_LOAD_offset)
#define GPA_DR_SET_LOC			(GPA_BASE + PiDR_SET_offset)
#define GPA_DR_CLEAR_LOC		(GPA_BASE + PiDR_CLEAR_offset)
#define GPA_DR_INV_LOC			(GPA_BASE + PiDR_INV_offset)
#define GPA_DDR_LOAD_LOC		(GPA_BASE + PiDDR_LOAD_offset)
#define GPA_DDR_SET_LOC			(GPA_BASE + PiDDR_SET_offset)
#define GPA_DDR_CLEAR_LOC		(GPA_BASE + PiDDR_CLEAR_offset)
#define GPA_DDR_INV_LOC			(GPA_BASE + PiDDR_INV_offset)
#define GPA_PEIE_LOAD_LOC		(GPA_BASE + PiPEIE_LOAD_offset)
#define GPA_PEIE_SET_LOC		(GPA_BASE + PiPEIE_SET_offset)
#define GPA_PEIE_CLEAR_LOC		(GPA_BASE + PiPEIE_CLEAR_offset)
#define GPA_PEIE_INV_LOC		(GPA_BASE + PiPEIE_INV_offset)
#define GPA_NEIE_LOAD_LOC		(GPA_BASE + PiNEIE_LOAD_offset)
#define GPA_NEIE_SET_LOC		(GPA_BASE + PiNEIE_SET_offset)
#define GPA_NEIE_CLEAR_LOC		(GPA_BASE + PiNEIE_CLEAR_offset)
#define GPA_NEIE_INV_LOC		(GPA_BASE + PiNEIE_INV_offset)
#define GPA_INVR_LOAD_LOC		(GPA_BASE + PiINVR_LOAD_offset)
#define GPA_INVR_SET_LOC		(GPA_BASE + PiINVR_SET_offset)
#define GPA_INVR_CLEAR_LOC		(GPA_BASE + PiINVR_CLEAR_offset)
#define GPA_INVR_INV_LOC		(GPA_BASE + PiINVR_INV_offset)
#define GPA_IMR_LOAD_LOC		(GPA_BASE + PiIMR_LOAD_offset)
#define GPA_IMR_SET_LOC			(GPA_BASE + PiIMR_SET_offset)
#define GPA_IMR_CLEAR_LOC		(GPA_BASE + PiIMR_CLEAR_offset)
#define GPA_IMR_INV_LOC			(GPA_BASE + PiIMR_INV_offset)
#define GPA_ALT_LOAD_LOC		(GPA_BASE + PiALT_LOAD_offset)
#define GPA_ALT_SET_LOC			(GPA_BASE + PiALT_SET_offset)
#define GPA_ALT_CLEAR_LOC		(GPA_BASE + PiALT_CLEAR_offset)
#define GPA_ALT_INV_LOC			(GPA_BASE + PiALT_INV_offset)
#define GPA_PUR_LOAD_LOC		(GPA_BASE + PiPUR_LOAD_offset)
#define GPA_PUR_SET_LOC			(GPA_BASE + PiPUR_SET_offset)
#define GPA_PUR_CLEAR_LOC		(GPA_BASE + PiPUR_CLEAR_offset)
#define GPA_PUR_INV_LOC			(GPA_BASE + PiPUR_INV_offset)
#define GPA_PXD_LOC				(GPA_BASE + PiPXD_offset)
#define GPA_INTREQ_LOC			(GPA_BASE + PiINTREQ_offset)
#define GPA_ECLR_LOC			(GPA_BASE + PiECLR_offset)
// Aliases
#define GPA_DR_LOC				GPA_DR_LOAD_LOC
#define GPA_DDR_LOC				GPA_DDR_LOAD_LOC
#define GPA_PEIE_LOC			GPA_PEIE_LOAD_LOC
#define GPA_NEIE_LOC			GPA_NEIE_LOAD_LOC
#define GPA_INVR_LOC			GPA_INVR_LOAD_LOC
#define GPA_IMR_LOC				GPA_IMR_LOAD_LOC
#define GPA_ALT_LOC				GPA_ALT_LOAD_LOC
#define GPA_PUR_LOC				GPA_PUR_LOAD_LOC


// GPB
#define GPB_DR_LOAD_LOC			(GPB_BASE + PiDR_LOAD_offset)
#define GPB_DR_SET_LOC			(GPB_BASE + PiDR_SET_offset)
#define GPB_DR_CLEAR_LOC		(GPB_BASE + PiDR_CLEAR_offset)
#define GPB_DR_INV_LOC			(GPB_BASE + PiDR_INV_offset)
#define GPB_DDR_LOAD_LOC		(GPB_BASE + PiDDR_LOAD_offset)
#define GPB_DDR_SET_LOC			(GPB_BASE + PiDDR_SET_offset)
#define GPB_DDR_CLEAR_LOC		(GPB_BASE + PiDDR_CLEAR_offset)
#define GPB_DDR_INV_LOC			(GPB_BASE + PiDDR_INV_offset)
#define GPB_PEIE_LOAD_LOC		(GPB_BASE + PiPEIE_LOAD_offset)
#define GPB_PEIE_SET_LOC		(GPB_BASE + PiPEIE_SET_offset)
#define GPB_PEIE_CLEAR_LOC		(GPB_BASE + PiPEIE_CLEAR_offset)
#define GPB_PEIE_INV_LOC		(GPB_BASE + PiPEIE_INV_offset)
#define GPB_NEIE_LOAD_LOC		(GPB_BASE + PiNEIE_LOAD_offset)
#define GPB_NEIE_SET_LOC		(GPB_BASE + PiNEIE_SET_offset)
#define GPB_NEIE_CLEAR_LOC		(GPB_BASE + PiNEIE_CLEAR_offset)
#define GPB_NEIE_INV_LOC		(GPB_BASE + PiNEIE_INV_offset)
#define GPB_INVR_LOAD_LOC		(GPB_BASE + PiINVR_LOAD_offset)
#define GPB_INVR_SET_LOC		(GPB_BASE + PiINVR_SET_offset)
#define GPB_INVR_CLEAR_LOC		(GPB_BASE + PiINVR_CLEAR_offset)
#define GPB_INVR_INV_LOC		(GPB_BASE + PiINVR_INV_offset)
#define GPB_IMR_LOAD_LOC		(GPB_BASE + PiIMR_LOAD_offset)
#define GPB_IMR_SET_LOC			(GPB_BASE + PiIMR_SET_offset)
#define GPB_IMR_CLEAR_LOC		(GPB_BASE + PiIMR_CLEAR_offset)
#define GPB_IMR_INV_LOC			(GPB_BASE + PiIMR_INV_offset)
#define GPB_ALT_LOAD_LOC		(GPB_BASE + PiALT_LOAD_offset)
#define GPB_ALT_SET_LOC			(GPB_BASE + PiALT_SET_offset)
#define GPB_ALT_CLEAR_LOC		(GPB_BASE + PiALT_CLEAR_offset)
#define GPB_ALT_INV_LOC			(GPB_BASE + PiALT_INV_offset)
#define GPB_PUR_LOAD_LOC		(GPB_BASE + PiPUR_LOAD_offset)
#define GPB_PUR_SET_LOC			(GPB_BASE + PiPUR_SET_offset)
#define GPB_PUR_CLEAR_LOC		(GPB_BASE + PiPUR_CLEAR_offset)
#define GPB_PUR_INV_LOC			(GPB_BASE + PiPUR_INV_offset)
#define GPB_PXD_LOC				(GPB_BASE + PiPXD_offset)
#define GPB_INTREQ_LOC			(GPB_BASE + PiINTREQ_offset)
#define GPB_ECLR_LOC			(GPB_BASE + PiECLR_offset)
// Aliases
#define GPB_DR_LOC				GPB_DR_LOAD_LOC
#define GPB_DDR_LOC				GPB_DDR_LOAD_LOC
#define GPB_PEIE_LOC			GPB_PEIE_LOAD_LOC
#define GPB_NEIE_LOC			GPB_NEIE_LOAD_LOC
#define GPB_INVR_LOC			GPB_INVR_LOAD_LOC
#define GPB_IMR_LOC				GPB_IMR_LOAD_LOC
#define GPB_ALT_LOC				GPB_ALT_LOAD_LOC
#define GPB_PUR_LOC				GPB_PUR_LOAD_LOC

// GPC
#define GPC_DR_LOAD_LOC			(base_GPC + PiDR_LOAD_offset)
#define GPC_DR_SET_LOC			(base_GPC + PiDR_SET_offset)
#define GPC_DR_CLEAR_LOC		(base_GPC + PiDR_CLEAR_offset)
#define GPC_DR_INV_LOC			(base_GPC + PiDR_INV_offset)
#define GPC_DDR_LOAD_LOC		(base_GPC + PiDDR_LOAD_offset)
#define GPC_DDR_SET_LOC			(base_GPC + PiDDR_SET_offset)
#define GPC_DDR_CLEAR_LOC		(base_GPC + PiDDR_CLEAR_offset)
#define GPC_DDR_INV_LOC			(base_GPC + PiDDR_INV_offset)
#define GPC_PEIE_LOAD_LOC		(base_GPC + PiPEIE_LOAD_offset)
#define GPC_PEIE_SET_LOC		(base_GPC + PiPEIE_SET_offset)
#define GPC_PEIE_CLEAR_LOC		(base_GPC + PiPEIE_CLEAR_offset)
#define GPC_PEIE_INV_LOC		(base_GPC + PiPEIE_INV_offset)
#define GPC_NEIE_LOAD_LOC		(base_GPC + PiNEIE_LOAD_offset)
#define GPC_NEIE_SET_LOC		(base_GPC + PiNEIE_SET_offset)
#define GPC_NEIE_CLEAR_LOC		(base_GPC + PiNEIE_CLEAR_offset)
#define GPC_NEIE_INV_LOC		(base_GPC + PiNEIE_INV_offset)
#define GPC_INVR_LOAD_LOC		(base_GPC + PiINVR_LOAD_offset)
#define GPC_INVR_SET_LOC		(base_GPC + PiINVR_SET_offset)
#define GPC_INVR_CLEAR_LOC		(base_GPC + PiINVR_CLEAR_offset)
#define GPC_INVR_INV_LOC		(base_GPC + PiINVR_INV_offset)
#define GPC_IMR_LOAD_LOC		(base_GPC + PiIMR_LOAD_offset)
#define GPC_IMR_SET_LOC			(base_GPC + PiIMR_SET_offset)
#define GPC_IMR_CLEAR_LOC		(base_GPC + PiIMR_CLEAR_offset)
#define GPC_IMR_INV_LOC			(base_GPC + PiIMR_INV_offset)
#define GPC_ALT_LOAD_LOC		(base_GPC + PiALT_LOAD_offset)
#define GPC_ALT_SET_LOC			(base_GPC + PiALT_SET_offset)
#define GPC_ALT_CLEAR_LOC		(base_GPC + PiALT_CLEAR_offset)
#define GPC_ALT_INV_LOC			(base_GPC + PiALT_INV_offset)
#define GPC_PUR_LOAD_LOC		(base_GPC + PiPUR_LOAD_offset)
#define GPC_PUR_SET_LOC			(base_GPC + PiPUR_SET_offset)
#define GPC_PUR_CLEAR_LOC		(base_GPC + PiPUR_CLEAR_offset)
#define GPC_PUR_INV_LOC			(base_GPC + PiPUR_INV_offset)
#define GPC_PXD_LOC				(base_GPC + PiPXD_offset)
#define GPC_INTREQ_LOC			(base_GPC + PiINTREQ_offset)
#define GPC_ECLR_LOC			(base_GPC + PiECLR_offset)
// Aliases
#define GPC_DR_LOC				GPC_DR_LOAD_LOC
#define GPC_DDR_LOC				GPC_DDR_LOAD_LOC
#define GPC_PEIE_LOC			GPC_PEIE_LOAD_LOC
#define GPC_NEIE_LOC			GPC_NEIE_LOAD_LOC
#define GPC_INVR_LOC			GPC_INVR_LOAD_LOC
#define GPC_IMR_LOC				GPC_IMR_LOAD_LOC
#define GPC_ALT_LOC				GPC_ALT_LOAD_LOC
#define GPC_PUR_LOC				GPC_PUR_LOAD_LOC

// GPIO port functions
#define PF_PORT	0
#define PF_ALT	1

// GPX (PxA and PxD) - FIXME
#define PXD_LOAD_offset			0
#define PXD_SET_offset			1
#define PXD_CLEAR_offset		2
#define PXD_DIR_offset			3
#define PXA_LOAD_offset			4
#define PXA_SET_offset			5
#define PXA_CLEAR_offset		6		// ToDo
#define PX_ALT_offset			8
#define PXD_PIN_offset			9
#define PXD_PU_offset			10

#define PXD_LOAD_LOC			(base_GPX + PXD_LOAD_offset)
#define PXD_DR_LOC				PXD_LOAD_LOC	// alias
#define PXD_SET_LOC				(base_GPX + PXD_SET_offset)
#define PXD_CLEAR_LOC			(base_GPX + PXD_CLEAR_offset)
#define PXD_DIR_LOC				(base_GPX + PXD_DIR_offset)

#define PXA_LOAD_LOC			(base_GPX + PXA_LOAD_offset)
#define PXA_DR_LOC				PXA_LOAD_LOC	// alias
#define PXA_SET_LOC				(base_GPX + PXA_SET_offset)
#define PXA_CLEAR_LOC			(base_GPX + PXA_CLEAR_offset)
// PXA only output


#define PX_ALT_LOC				(base_GPX + PX_ALT_offset)
#define PX_ALT_PDB0				(1<<0)
#define PX_ALT_PDB1				(1<<1)
#define PX_ALT_PDB2				(1<<2)
#define PX_ALT_PDB3				(1<<3)
#define PX_ALT_PAB0				(1<<4)
#define PX_ALT_PAB1				(1<<5)
#define PX_ALT_PAB2				(1<<6)
#define PX_ALT_PDB23F0			(1<<7)
#define PX_ALT_PDB23F1			(1<<8)

#define PXD_PIN_LOC				(base_GPX + PXD_PIN_offset)
#define PXD_PU_LOC				(base_GPX + PXD_PU_offset)

#define PA_BIT_MASK_SPI			(0x1FF)

/*--------------------------------  SPI REGISTERS  --------------------------------*/
#define base_SPI_SPCR0_offset						0
#define base_SPI_SPCR1_offset						1
#define base_SPI_SPDR_offset						2
#define base_SPI_SPSR_offset						3
#define base_SPI_SPRXCNT_offset						4

// SPCR0
#define SPCR0_DSS_4BIT								0x3
#define SPCR0_DSS_5BIT								0x4
#define SPCR0_DSS_6BIT								0x5
#define SPCR0_DSS_7BIT								0x6
#define SPCR0_DSS_8BIT								0x7
#define SPCR0_DSS_9BIT								0x8
#define SPCR0_DSS_10BIT								0x9
#define SPCR0_DSS_11BIT								0xA
#define SPCR0_DSS_12BIT								0xB
#define SPCR0_DSS_13BIT								0xC
#define SPCR0_DSS_14BIT								0xD
#define SPCR0_DSS_15BIT								0xE
#define SPCR0_DSS_16BIT								0xF
#define SPCR0_DSS_17BIT								0x10
#define SPCR0_DSS_18BIT								0x11
#define SPCR0_DSS_19BIT								0x12
#define SPCR0_DSS_20BIT								0x13
#define SPCR0_DSS_21BIT								0x14
#define SPCR0_DSS_22BIT								0x15
#define SPCR0_DSS_23BIT								0x16
#define SPCR0_DSS_24BIT								0x17
#define SPCR0_DSS_25BIT								0x18
#define SPCR0_DSS_26BIT								0x19
#define SPCR0_DSS_27BIT								0x1A
#define SPCR0_DSS_28BIT								0x1B
#define SPCR0_DSS_29BIT								0x1C
#define SPCR0_DSS_30BIT								0x1D
#define SPCR0_DSS_31BIT								0x1E
#define SPCR0_DSS_32BIT								0x1F
#define SPCR0_SPO_CLK_HIGH							(0<<6)
#define SPCR0_SPO_CLK_LOW							(1<<6)
#define SPCR0_SPH_CLK_FALLING						(0<<7)
#define SPCR0_SPH_CLK_RISING						(1<<7)
#define SPCR0_TWI_MODE_OFF							(0<<8)
#define SPCR0_TWI_MODE_ON							(1<<8)
#define SPCR0_TWI_MODE_READ							(0<<9)
#define SPCR0_TWI_MODE_WRITE						(1<<9)
#define SPCR0_MSB_FIRST								(0<<10)
#define SPCR0_LSB_FIRST								(1<<10)
#define SPCR0_CSN_DEV0								((0<<14) | (0<<13) | (0<<12))
#define SPCR0_CSN_DEV1								((0<<14) | (0<<13) | (1<<12))
#define SPCR0_CSN_DEV2								((0<<14) | (1<<13) | (0<<12))
#define SPCR0_CSN_DEV3								((0<<14) | (1<<13) | (1<<12))
#define SPCR0_CSN_DEV4								((1<<14) | (0<<13) | (0<<12))
#define SPCR0_CSN_DEV5								((1<<14) | (0<<13) | (1<<12))
#define SPCR0_CSN_DEV6								((1<<14) | (1<<13) | (0<<12))
#define SPCR0_CSN_DEV7								((1<<14) | (1<<13) | (1<<12))
#define SPCR0_SCR_MASK								0x0FFF0000

// SPCR1 bits
#define SPCR1_RIM_P									(0)
#define SPCR1_TIM_P									(1)
#define SPCR1_LBM_P									(2)
#define SPCR1_SPE_P									(3)
#define SPCR1_MS_P									(4)
#define SPCR1_TUM_P									(5)
#define SPCR1_ROM_P									(6)
#define SPCR1_R_RQM_P								(8)
#define SPCR1_T_RQM_P								(9)
#define SPCR1_TXO_P									(10)
#define SPCR1_RXO_P									(11)
#define SPCR1_CIM_P									(12)
#define SPCR1_HOLDCS_P								(14)
#define SPCR1_ROTL_P								(15)
#define SPCR1_CSAL0_P								(16)
#define SPCR1_CSAL1_P								(17)
#define SPCR1_CSAL2_P								(18)
#define SPCR1_CSAL3_P								(19)
#define SPCR1_CSAL4_P								(20)
#define SPCR1_CSAL5_P								(21)
#define SPCR1_DLY_T0_P								(24)
#define SPCR1_DLY_T1_P								(25)
#define SPCR1_DLY_T2_P								(26)
#define SPCR1_DLY_T3_P								(27)

// SPSR bits
#define SPSR_TFE_P									(0)
#define SPSR_TNF_P									(1)
#define SPSR_RNE_P									(2)
#define SPSR_BSY_P									(3)
#define SPSR_TFS_P									(4)
#define SPSR_RFS_P									(5)
#define SPSR_ROR_P									(6)
#define SPSR_TUR_P									(7)
#define SPSR_RFF_P									(8)
#define SPSR_TI_REQ_P								(9)
#define SPSR_RI_REQ_P								(10)

//-------------------------------------------------------//
// NAND Flash

#define NAND_IO_CFG_LOC		(NAND_BASE + 0x0)
#define NAND_WCT_CFG_LOC	(NAND_BASE + 0x1)
#define NAND_CFG_LOC		(NAND_BASE + 0x2)
#define NAND_WR_CFG_LOC		(NAND_BASE + 0x3)
#define NAND_RD_CFG_LOC		(NAND_BASE + 0x4)
//#define NAND_IOSR_LOC		(NAND_BASE + 0x5)
#define NAND_CR_LOC			(NAND_BASE + 0x8)
#define NAND_SR_LOC			(NAND_BASE + 0x9)
#define NAND_AR_LOC			(NAND_BASE + 0xA)
#define NAND_CNTR_LOC		(NAND_BASE + 0xB)
#define NAND_DR_LOC			(NAND_BASE + 0xC)

// NAND_IO_CFG register
#define NAND_IO_CFG_CSCA_P			1
#define NAND_IO_CFG_CA_P			3
#define NAND_IO_CFG_BWD_P			8
#define NAND_IO_CFG_BRT_P			11
#define NAND_IO_CFG_BHT_P			15
#define NAND_IO_CFG_MDT_P			18
#define NAND_IO_CFG_VGA_P			21
#define NAND_IO_CFG_CSKPL_P			23

// NAND_WCT_CFG register
#define NAND_WCT_CFG_ENWT_P			0
#define NAND_WCT_CFG_CCSE_P			4
#define NAND_WCT_CFG_WTOC_P			21
#define NAND_WCT_CFG_TOE_P			31

// NAND_CFG
#define NAND_CFG_VOLCOL10_P			0
#define NAND_CFG_ROWBT_P			3
#define NAND_CFG_COMCLW_P			4
#define NAND_CFG_COMCLR_P			6
#define NAND_CFG_ADRCL_P			8
#define NAND_CFG_ADRSC_P			12
#define NAND_CFG_DATSC_P			13
#define NAND_CFG_VOLCOL2_P			14
#define NAND_CFG_COMSC_P			15
#define NAND_CFG_RESBF_P			16
#define NAND_CFG_RESAF_P			21
#define NAND_CFG_ADDRH_P			28

#define NAND_CFG_ADRCL_ONECYCLE		(0<<NAND_CFG_ADRCL_P)
#define NAND_CFG_ADRCL_COLUMN		(1<<NAND_CFG_ADRCL_P)
#define NAND_CFG_ADRCL_ROW			(2<<NAND_CFG_ADRCL_P)
#define NAND_CFG_ADRCL_ROW_COLUMN	(3<<NAND_CFG_ADRCL_P)

#define NAND_CFG_COMCLR1			(0 << NAND_CFG_COMCLR_P)
#define NAND_CFG_COMCLR2			(1 << NAND_CFG_COMCLR_P)
#define NAND_CFG_COMCLW1			(0 << NAND_CFG_COMCLW_P)
#define NAND_CFG_COMCLW2			(1 << NAND_CFG_COMCLW_P)
#define NAND_CFG_COMCLW3			(2 << NAND_CFG_COMCLW_P)

#define NAND_CFG_ADRSC				(1<<NAND_CFG_ADRSC_P)
#define NAND_CFG_DATSC				(1<<NAND_CFG_DATSC_P)
#define NAND_CFG_COMSC				(1<<NAND_CFG_COMSC_P)

// NAND_WR_CFG
#define NAND_WR_CFG_COMW1_P			0
#define NAND_WR_CFG_COMW2_P			8
#define NAND_WR_CFG_COMW3_P			16

// NAND_RD_CFG
#define NAND_RD_CFG_COMR1_P			0
#define NAND_RD_CFG_COMR2_P			8
#define NAND_RD_CFG_COMR3_P			16

// NAND_IOSR
//#define NAND_IOSR_TOEX0_P			0
//#define NAND_IOSR_TOEX1_P			1
//#define NAND_IOSR_TOEX2_P			2
//#define NAND_IOSR_TOEX3_P			3
//#define NAND_IOSR_MWE_P				4
//#define NAND_IOSR_RnBF_P			5
//#define NAND_IOSR_RnB_P				31

// NAND_CR
#define NAND_CR_EN_P				0
#define NAND_CR_RW_P				1
//#define NAND_CR_LOCK_P				2
#define NAND_CR_SQE_P				3
#define NAND_CR_RIM_P				4
#define NAND_CR_TIM_P				5
#define NAND_CR_CIM_P				6
#define NAND_CR_SZ_P				8
#define NAND_CR_DBSZ_P				11
#define NAND_CR_ERI_EN_P			12
#define NAND_CR_RnBI_EN_P			13

#define NAND_CR_WRITE				(1 << NAND_CR_RW_P)
#define NAND_CR_SIZE_WORD			((0<<9) | (0<<8))
#define NAND_CR_SIZE_SHORT			((1<<9) | (0<<8))
#define NAND_CR_SIZE_BYTE			((1<<9) | (1<<8))

// NAND_SR
#define NAND_SR_EMPTY_P				0
#define NAND_SR_FULL_P				1
#define NAND_SR_TFS_P				2
#define NAND_SR_RFS_P				3
#define NAND_SR_IRQ_P				4
#define NAND_IOSR_TOEX_P			8
#define NAND_IOSR_TOEX0_P			8
#define NAND_IOSR_TOEX1_P			9
#define NAND_IOSR_TOEX2_P			10
#define NAND_IOSR_TOEX3_P			11
#define NAND_IOSR_RnBF_P			13
#define NAND_IOSR_RFSI_P			16
#define NAND_IOSR_TFSI_P			17
#define NAND_IOSR_CNTZI_P			18
#define NAND_IOSR_TOI_P				19
#define NAND_IOSR_RnBFI_P			20
#define NAND_IOSR_RnB_P				31


#define NAND_SR_EMPTY				(1<<NAND_SR_EMPTY_P)
#define NAND_SR_FULL				(1<<NAND_SR_FULL_P)
#define NAND_SR_TFS					(1<<NAND_SR_TFS_P)
#define NAND_SR_RFS					(1<<NAND_SR_RFS_P)
#define NAND_SR_IRQ					(1<<NAND_SR_IRQ_P)
#define NAND_SR_RnBF				(1<<NAND_IOSR_RnBF_P)


// NAND_AR
// NAND_CNTR
// NAND_DR


//-------------------------------------------------------//
// UART

#define UART_DR_offset				0
#define UART_STAT_offset			1
#define UART_UCR_LOAD_offset		2
#define UART_UCR_SET_offset			3
#define UART_UCR_CLEAR_offset		4
#define UART_UBRATE_offset			5
#define UART_UFLAG_offset			6
#define UART_UINTM_offset			7
#define UART_UINT_offset			8

#define UART0_DR_LOC				(UART0_BASE + UART_DR_offset)
#define UART0_STAT_LOC				(UART0_BASE + UART_STAT_offset)
#define UART0_UCR_LOAD_LOC			(UART0_BASE + UART_UCR_LOAD_offset)
#define UART0_UCR_SET_LOC			(UART0_BASE + UART_UCR_SET_offset)
#define UART0_UCR_CLEAR_LOC			(UART0_BASE + UART_UCR_CLEAR_offset)
#define UART0_UBRATE_LOC			(UART0_BASE + UART_UBRATE_offset)
#define UART0_UFLAG_LOC				(UART0_BASE + UART_UFLAG_offset)
#define UART0_INTM_LOC				(UART0_BASE + UART_UINTM_offset)
#define UART0_INT_LOC				(UART0_BASE + UART_UINT_offset)
// Aliases
#define UART0_UCR_LOC				UART0_UCR_LOAD_LOC


#define UCR_UARTEN_P				0
#define UCR_UTXDIS_P				1
#define UCR_URXDIS_P				2
#define UCR_DMAONERR_P				3
#define UCR_UTXFDIS_P				4
#define UCR_URXFDIS_P				5
#define UCR_UHBRE_P					6
#define UCR_BREAK_P					8
#define UCR_PRTEN_P					9
#define UCR_EVENPRT_P				10
#define UCR_XSTOP_P					11
#define UCR_UFIFOEN_P				12
#define UCR_WRDLEN_P				13
#define UCR_INV_P					15
#define UCR_TXINT_P					16
#define UCR_RXINT_P					17
#define UCR_RXERRINT_P				18
#define UCR_MSINT_P					19
#define UCR_UDINT_P					20
#define UCR_UTXEINT_P				21
#define UCR_URXTINT_P				22
#define UCR_LBM_P					31

#define UFLAG_UBUSY_P				3
#define UFLAG_URXFE_P				4
#define UFLAG_UTXFF_P				5

#define UINT_TXINT_P				0
#define UINT_RXINT_P				1
#define UINT_RXERRINT_P				2
#define UINT_MSINT_P				3
#define UINT_UDINT_P				4
#define UINT_UTXEINT_P				5
#define UINT_URXTINT_P				6

#define UART_RXSTAT_FRAME_P			0
#define UART_RXSTAT_PARITY_P		1
#define UART_RXSTAT_OVERRUN_P		2
#define UART_RXSTAT_ERROR_P			3




#define UART1_DR_LOC				(UART1_BASE + UART_DR_offset)
#define UART1_STAT_LOC				(UART1_BASE + UART_STAT_offset)
#define UART1_UCR_LOAD_LOC			(UART1_BASE + UART_UCR_LOAD_offset)
#define UART1_UCR_SET_LOC			(UART1_BASE + UART_UCR_SET_offset)
#define UART1_UCR_CLEAR_LOC			(UART1_BASE + UART_UCR_CLEAR_offset)
#define UART1_UBRATE_LOC			(UART1_BASE + UART_UBRATE_offset)
#define UART1_UFLAG_LOC				(UART1_BASE + UART_UFLAG_offset)
#define UART1_INTM_LOC				(UART1_BASE + UART_UINTM_offset)
#define UART1_INT_LOC				(UART1_BASE + UART_UINT_offset)
// Aliases
#define UART1_UCR_LOC				UART1_UCR_LOAD_LOC


// Values
#define UART_PARITY_NONE			0
#define UART_PARITY_ODD				(1 << UCR_PRTEN_P)
#define UART_PARITY_EVEN			((1 << UCR_PRTEN_P) | (1 << UCR_EVENPRT_P))

#define UART_ONE_STOP_BIT			0
#define UART_TWO_STOP_BIT			(1 << UCR_XSTOP_P)

#define UART_BIT_LENGTH_16X			0
#define UART_BIT_LENGTH_4X			(1 << UCR_UHBRE_P)
#define UART_BIT_LENGTH_4X_DIRECT	(2 << UCR_UHBRE_P)

#define UART_DATA_LENGTH_8BIT		0
#define UART_DATA_LENGTH_7BIT		(1 << UCR_WRDLEN_P)
#define UART_DATA_LENGTH_6BIT		(2 << UCR_WRDLEN_P)
#define UART_DATA_LENGTH_5BIT		(3 << UCR_WRDLEN_P)

#define UART_NO_RX_TX_FIFO			0
#define UART_USE_RX_TX_FIFO			(1 << UCR_UFIFOEN_P)




//-------------------------------------------------------//
// LCD
//LCD_BASE

#define LCD_CTRL_LOC				(LCD_BASE + 0)
#define LCD_STATUS_LOC				(LCD_BASE + 1)
#define LCD_HTIM_LOC				(LCD_BASE + 2)
#define LCD_VTIM_LOC				(LCD_BASE + 3)
#define LCD_HVLEN_LOC				(LCD_BASE + 4)
#define LCD_HDxTIM_LOC				(LCD_BASE + 5)
#define LCD_VDxTIM_LOC				(LCD_BASE + 6)
#define LCD_VSIZE_LOC				(LCD_BASE + 7)
#define LCD_BACKGND_LOC				(LCD_BASE + 8)
#define LCD_PXDV_LOC				(LCD_BASE + 9)
#define LCD_HDTIM_LOC				(LCD_BASE + 10)
#define LCD_VDTIM_LOC				(LCD_BASE + 11)
#define LCD_PANEL_CFG_LOC			(LCD_BASE + 12)
#define LCD_PWM_CR_LOC				(LCD_BASE + 13)
#define LCD_SLP_PERIOD_LOC			(LCD_BASE + 14)
#define LCD_TIM_GP0_LOC				(LCD_BASE + 16)
#define LCD_TIM_GP1_LOC				(LCD_BASE + 17)
#define LCD_TIM_GP2_LOC				(LCD_BASE + 18)
#define LCD_TIM_GP3_LOC				(LCD_BASE + 19)

#define LCD_CTRL_VEN_P				0
#define LCD_CTRL_VIE_P				1
#define LCD_CTRL_HIE_P				2
#define LCD_CTRL_VBIE_P				3
#define LCD_CTRL_SLPIE_P			4
#define LCD_CTRL_VBL_P				7
#define LCD_CTRL_CD_P				9
#define LCD_CTRL_HLDM_P				12
#define LCD_CTRL_HLDV_P				13
#define LCD_CTRL_BL_P				15
#define LCD_CTRL_VBGR_P				17
#define LCD_CTRL_SLP_MODE_P			20
#define LCD_CTRL_SLP_PCLK_P			21
#define LCD_CTRL_SLP_PXEN_P			22
#define LCD_CTRL_SLP_HOLD_P			23
#define LCD_CTRL_SLP_CLRF_P			24


#define LCD_STAT_SINT_P				0
#define LCD_STAT_LUINT_P			1
#define LCD_STAT_STA_SLEEP_P		2
#define LCD_STAT_FIN_SLEEP_P		3
#define LCD_STAT_VINT_P				4
#define LCD_STAT_HINT_P				5
#define LCD_STAT_VBSINT_P			6

#define LCD_HTIM_HPS_P				0
#define LCD_HTIM_HPL_P				15
#define LCD_HTIM_HPW_P				16

#define LCD_VTIM_VPS_P				0
#define LCD_VTIM_VPL_P				15
#define LCD_VTIM_VPW_P				16

#define LCD_HVLEN_HT_P				0
#define LCD_HVLEN_VT_P				16

#define LCD_PXDV_DIV_P				0
#define LCD_PXDV_EN_P				8

#define LCD_HDTIM_HDPS_P			0
#define LCD_HDTIM_HDP_P				16

#define LCD_VDTIM_VDPS_P			0
#define LCD_VDTIM_VDP_P				16

#define LCD_PANEL_TYPE_P			0
#define LCD_PANEL_FPSHI_P			6
#define LCD_PANEL_DVI_MODE_P		9
#define LCD_PANEL_DVI_CLK_P			10

#define LCD_PWM_CLKEN_P				0
#define LCD_PWM_FRSH_P				3
#define LCD_PWM_DV_P				4
#define LCD_PWM_DUTY_P				8
#define LCD_PWM_RELOAD_P			16

#define LCD_GP0_ST_P				0
#define LCD_GP0_HPL_P				15
#define LCD_GP0_SP_P				16

#define LCD_GP1_ST_P				0
#define LCD_GP1_HPL_P				15
#define LCD_GP1_SP_P				16

#define LCD_GP2_ST_P				0
#define LCD_GP2_HPL_P				15
#define LCD_GP2_SP_P				16

#define LCD_GP3_ST_P				0
#define LCD_GP3_HPL_P				15
#define LCD_GP3_SP_P				16

#define LCD_GP4_ST_P				0
#define LCD_GP4_SP_P				16

#define LCD_GP5_WDTH_P				0
#define LCD_GP5_LINE_P				16


//-------------------------------------------------------//
// Video (camera)
#define VIDEO_DR_LOC				(VIDEO_BASE + 0)
#define VIDEO_SR_LOC				(VIDEO_BASE + 4)
#define VIDEO_CR_LOC				(VIDEO_BASE + 5)

#define VIDEO_CR_VCON_P				0
#define VIDEO_CR_VCIE_P				1
#define VIDEO_CR_VCON				(1<<VIDEO_CR_VCON_P)
#define VIDEO_CR_VCIE				(1<<VIDEO_CR_VCIE_P)

#define VIDEO_SR_EMPTY_P			0
#define VIDEO_SR_FULL_P				1
#define VIDEO_SR_OVERF_P			2
#define VIDEO_SR_UNDERF_P			3
#define VIDEO_SR_EMPTY				(1<<VIDEO_SR_EMPTY_P)
#define VIDEO_SR_FULL				(1<<VIDEO_SR_FULL_P)
#define VIDEO_SR_OVERF				(1<<VIDEO_SR_OVERF_P)
#define VIDEO_SR_UNDERF				(1<<VIDEO_SR_UNDERF_P)


//-------------------------------------------------------//
// I2S (AC97)
//I2S0_BASE
#define AC97_SICR0_offset			0
#define AC97_SINT_offset			1
#define AC97_SICR2_offset			2
#define AC97_SISR_offset			3
#define AC97_SIRSR_offset			4
#define AC97_SIIER_offset			5
#define AC97_SIIDR_offset			6
#define AC97_SIICR_offset			7
#define AC97_SIADR_offset			8
#define AC97_SIMDR_offset			9
#define AC97_ACCAR_offset			10
#define AC97_ACCDR_offset			11
#define AC97_ACSAR_offset			12
#define AC97_ACSDR_offset			13
#define AC97_ACGDR_offset			14
#define AC97_ACGSR_offset			15
#define AC97_I2S_TCR_offset			16
#define AC97_I2S_RCR_offset			17
#define AC97_SICR3_offset			28

#define AC97_SICR2_EREC_P			0
#define AC97_SICR2_ERPL_P			1
#define AC97_SICR2_EINC_P			2
#define AC97_SICR2_EOUT_P			3
#define AC97_SICR2_EGPIO_P			4
#define AC97_SICR2_WKUP_P			5
#define AC97_SICR2_DRSTO_P			6
#define AC97_SICR2_REQLP_P			7


#define AC97_SISR_ATNE_P			5
#define AC97_SISR_ATNF_P			6
#define AC97_SISR_ARNE_P			7
#define AC97_SISR_ATFS_P			8
#define AC97_SISR_ARFS_P			9


#define I2S_TCR_TEN_P				0
#define I2S_TCR_MODE_P				1
#define I2S_TCR_SONY_P				2
#define I2S_TCR_MS_P				3
#define I2S_TCR_DSS_P				4
#define I2S_TCR_PNIS_P				10
#define I2S_TCR_PNOS_P				11
#define I2S_TCR_SWHW_P				12
#define I2S_TCR_PACKH_P				13
#define I2S_TCR_LRSP_P				14

#define I2S_RCR_REN_P				0
#define I2S_RCR_MODE_P				1
#define I2S_RCR_SONY_P				2
#define I2S_RCR_MS_P				3
#define I2S_RCR_DSS_P				4
#define I2S_RCR_PNIS_P				10
#define I2S_RCR_PNOS_P				11
#define I2S_RCR_SWHW_P				12
#define I2S_RCR_LRSP_P				14




//-------------------------------------------------------//
// CMU

#define CMU_CFG1_LOC				(base_CMU + 0)	// CFG_APB
#define CMU_CFG2_LOC				(base_CMU + 1)	// CFG_cPLL
#define CMU_CFG3_LOC				(base_CMU + 2)	// CFG_xPLL
#define CMU_CFG4_LOC				(base_CMU + 3)	// CFG4
#define CMU_CFG5_LOC				(base_CMU + 4)	// CFG_lPLL
#define CMU_SYS_STS_LOC				(base_CMU + 5)
#define CMU_CLKDIS_LOC				(base_CMU + 0x8)
#define CMU_CLKDIS_LOAD_LOC			(base_CMU + 0x8)
#define CMU_CLKDIS_SET_LOC			(base_CMU + 0x9)
#define CMU_CLKDIS_CLEAR_LOC		(base_CMU + 0xA)
#define CMU_CFG8_LOAD_LOC			(base_CMU + 0x8)
#define CMU_CFG8_SET_LOC			(base_CMU + 0x9)
#define CMU_CFG8_CLEAR_LOC			(base_CMU + 0xA)

#define CMU_CFG1_RSV0_MASK			CREATE_BIT_MASK (1,0)
#define CMU_CFG1_LINK_BW_MASK		CREATE_BIT_MASK (2,2)
#define CMU_CFG1_SYS_WE_MASK		CREATE_BIT_MASK (3,3)
#define CMU_CFG1_ARINC_T0_EN_MASK   CREATE_BIT_MASK (4,4)
#define CMU_CFG1_ARINC_T1_EN_MASK   CREATE_BIT_MASK (5,5)
#define CMU_CFG1_ARINC_T2_EN_MASK   CREATE_BIT_MASK (6,6)
#define CMU_CFG1_ARINC_T3_EN_MASK   CREATE_BIT_MASK (7,7)
#define CMU_CFG1_MIL_DIS_MASK       CREATE_BIT_MASK (8,8)
#define CMU_CFG1_RSV1_MASK          CREATE_BIT_MASK (11,9)
#define CMU_CFG1_DMA_HP_EN_MASK     CREATE_BIT_MASK (12,12)
#define CMU_CFG1_RSV2_MASK          CREATE_BIT_MASK (31,13)

#define CMU_CFG_PLL_DIVR_MASK       CREATE_BIT_MASK (3,0)
#define CMU_CFG_PLL_DIVF_MASK       CREATE_BIT_MASK (10,4)
#define CMU_CFG_PLL_DIVQ_MASK       CREATE_BIT_MASK (13,11)
#define CMU_CFG_PLL_RANGE_MASK      CREATE_BIT_MASK (16,14)
#define CMU_CFG_PLL_BYPASS_MASK     CREATE_BIT_MASK (20,20)
#define CMU_CFG_PLL_S_MASK          CREATE_BIT_MASK (22,21)
#define CMU_CFG_PLL_RSV_MASK        CREATE_BIT_MASK (31,23)

#define CMU_CFG2_DIVR_MASK          CMU_CFG_PLL_DIVR_MASK
#define CMU_CFG2_DIVF_MASK          CMU_CFG_PLL_DIVF_MASK
#define CMU_CFG2_DIVQ_MASK          CMU_CFG_PLL_DIVQ_MASK
#define CMU_CFG2_RANGE_MASK         CMU_CFG_PLL_RANGE_MASK
#define CMU_CFG2_BYPASS_MASK        CMU_CFG_PLL_BYPASS_MASK
#define CMU_CFG2_S_MASK             CMU_CFG_PLL_S_MASK
#define CMU_CFG2_RSV_MASK           CMU_CFG_PLL_RSV_MASK

#define CMU_CFG3_DIVR_MASK          CMU_CFG_PLL_DIVR_MASK
#define CMU_CFG3_DIVF_MASK          CMU_CFG_PLL_DIVF_MASK
#define CMU_CFG3_DIVQ_MASK          CMU_CFG_PLL_DIVQ_MASK
#define CMU_CFG3_RANGE_MASK         CMU_CFG_PLL_RANGE_MASK
#define CMU_CFG3_BYPASS_MASK        CMU_CFG_PLL_BYPASS_MASK
#define CMU_CFG3_S_MASK             CMU_CFG_PLL_S_MASK
#define CMU_CFG3_RSV_MASK           CMU_CFG_PLL_RSV_MASK

#define CMU_CFG5_DIVR_MASK          CMU_CFG_PLL_DIVR_MASK
#define CMU_CFG5_DIVF_MASK          CMU_CFG_PLL_DIVF_MASK
#define CMU_CFG5_DIVQ_MASK          CMU_CFG_PLL_DIVQ_MASK
#define CMU_CFG5_RANGE_MASK         CMU_CFG_PLL_RANGE_MASK
#define CMU_CFG5_BYPASS_MASK        CMU_CFG_PLL_BYPASS_MASK
#define CMU_CFG5_S_MASK             CMU_CFG_PLL_S_MASK
#define CMU_CFG5_RSV_MASK           CMU_CFG_PLL_RSV_MASK

#define CMU_CFG4_CPLL_SEL_MASK      CREATE_BIT_MASK (0,0)
#define CMU_CFG4_BPLL_SEL_MASK      CREATE_BIT_MASK (1,1)
#define CMU_CFG4_DIS_CC_MASK        CREATE_BIT_MASK (2,2)
#define CMU_CFG4_DIS_BC_MASK        CREATE_BIT_MASK (3,3)
#define CMU_CFG4_BCLK_SEL_MASK      CREATE_BIT_MASK (5,4)
#define CMU_CFG4_RSV0_MASK          CREATE_BIT_MASK (6,6)
#define CMU_CFG4_LPLL_SEL_MASK      CREATE_BIT_MASK (7,7)
#define CMU_CFG4_RSV1_MASK          CREATE_BIT_MASK (31,8)

#define CMU_SYS_STS_BOOT_0_MASK      CREATE_BIT_MASK (0,0)
#define CMU_SYS_STS_BOOT_1_MASK      CREATE_BIT_MASK (1,1)
#define CMU_SYS_STS_BOOT_2_MASK      CREATE_BIT_MASK (2,2)
#define CMU_SYS_STS_RSV0_MASK        CREATE_BIT_MASK (3,3)
#define CMU_SYS_STS_L0_BCMPO_MASK    CREATE_BIT_MASK (4,4)
#define CMU_SYS_STS_L1_BCMPO_MASK    CREATE_BIT_MASK (5,5)
#define CMU_SYS_STS_RST_MASK         CREATE_BIT_MASK (6,6)
#define CMU_SYS_STS_POR_MASK         CREATE_BIT_MASK (7,7)
#define CMU_SYS_STS_RSV1_MASK        CREATE_BIT_MASK (31,8)

#define CMU_CFG8_I2S0_EN_MASK        CREATE_BIT_MASK (0,0)
#define CMU_CFG8_I2S1_EN_MASK        CREATE_BIT_MASK (1,1)
#define CMU_CFG8_VCAM_EN_MASK        CREATE_BIT_MASK (2,2)
#define CMU_CFG8_SPI_EN_MASK         CREATE_BIT_MASK (3,3)
#define CMU_CFG8_NAND_EN_MASK        CREATE_BIT_MASK (4,4)
#define CMU_CFG8_ARINC_EN_MASK       CREATE_BIT_MASK (5,5)
#define CMU_CFG8_MIL0_EN_MASK        CREATE_BIT_MASK (6,6)
#define CMU_CFG8_MIL1_EN_MASK        CREATE_BIT_MASK (7,7)
#define CMU_CFG8_UDDC0_EN_MASK       CREATE_BIT_MASK (8,8)
#define CMU_CFG8_UDDC1_EN_MASK       CREATE_BIT_MASK (9,9)
#define CMU_CFG8_UDDC2_EN_MASK       CREATE_BIT_MASK (10,10)
#define CMU_CFG8_UDDC3_EN_MASK       CREATE_BIT_MASK (11,11)
#define CMU_CFG8_GPS0_EN_MASK        CREATE_BIT_MASK (12,12)
#define CMU_CFG8_GPS1_EN_MASK        CREATE_BIT_MASK (13,13)
#define CMU_CFG8_LCD_EN_MASK         CREATE_BIT_MASK (14,14)
#define CMU_CFG8_UART1_EN_MASK       CREATE_BIT_MASK (15,15)
#define CMU_CFG8_UART2_EN_MASK       CREATE_BIT_MASK (16,16)
#define CMU_CFG8_RSV_MASK            CREATE_BIT_MASK (31,17)

// CPU clock configuration register - alias
#define CPU_CLK_CONFIG_LOC		CMU_CFG4_LOC

// CFG1 (CFG_APB) bits
#define CFG_APB_SYS_WE_P		(3)		// enable multiple writes to SYSCON/SDRCON
#define CFG_APB_ARINC_T0_EN_P	(4)
#define CFG_APB_ARINC_T1_EN_P	(5)
#define CFG_APB_ARINC_T2_EN_P	(6)
#define CFG_APB_ARINC_T3_EN_P	(7)
#define CFG_APB_MIL_DIS_P		(8)

#define CFG_APB_SYS_WE			(1<<CFG_APB_SYS_WE_P)

// SYS_STS register bit description
#define SYS_STS_BOOT0	(1<<0)
#define SYS_STS_BOOT1	(1<<1)
#define SYS_STS_BOOT2	(1<<2)
#define SYS_STS_RST		(1<<6)
#define SYS_STS_POR		(1<<7)
#define SYS_STS_BOOT_MASK	(SYS_STS_BOOT0 | SYS_STS_BOOT1 | SYS_STS_BOOT2)
#define BOOT_MODE_EXTIRQ_BUS16		0
#define BOOT_MODE_EXTIRQ_BUS32		1
#define BOOT_MODE_PARALLEL_FLASH	2
#define BOOT_MODE_SPI_FLASH			3
#define BOOT_MODE_NAND_FLASH		4
#define BOOT_MODE_LINK_1BIT			5
#define BOOT_MODE_LINK_4BIT			6
#define BOOT_MODE_LINK_8BIT			7

// PLL address aliases
#define PLL_CORE_CFG_LOC	CMU_CFG2_LOC
#define PLL_BUS_CFG_LOC		CMU_CFG3_LOC
#define PLL_LINK_CFG_LOC	CMU_CFG5_LOC

// PLL bit positions
#define PLL_DIVR_P			0
#define PLL_DIVF_P			4
#define PLL_DIVQ_P			11
#define PLL_RANGE_P			14
#define PLL_IVCO_P			17
#define PLL_BYPASS_P		20

#define PLL_DIVR_MASK		0x0000000F
#define PLL_DIVF_MASK		0x000007F0
#define PLL_DIVQ_MASK		0x00003800
#define PLL_RANGE_MASK		0x0001C000
#define PLL_IVCO_MASK		0x000E0000
#define PLL_BYPASS_MASK		0x00100000

// CPU clock configuration register bits
#define CPU_CPLL_SEL_P		0
#define CPU_BPLL_SEL_P		1
#define CPU_DIS_CCLK_P		2
#define CPU_DIS_BCLK_P		3
#define CPU_BCLK_SEL_P		4

#define CPU_CPLL_SEL			(1<<CPU_CPLL_SEL_P)
#define CPU_BPLL_SEL			(1<<CPU_BPLL_SEL_P)
#define CPU_DIS_CC				(1<<CPU_DIS_CCLK_P)
#define CPU_DIS_BC				(1<<CPU_DIS_BCLK_P)
#define CPU_BCLK_SEL_BPLL		(0<<CPU_BCLK_SEL_P)
#define CPU_BCLK_SEL_APBDIV1	(1<<CPU_BCLK_SEL_P)
#define CPU_BCLK_SEL_APBDIV2	(2<<CPU_BCLK_SEL_P)
#define CPU_BCLK_SEL_APBDIV4	(4<<CPU_BCLK_SEL_P)

//-------------------------------------------------------//
// LINK

#define LTX_EN_P		0		// enable
#define LTX_VEN_P		1		// verification enable (CRC)
#define LTX_TOEN_P		2		// timeout check IRQ enable
#define LTX_BCMP_P		3		// block completition
#define LTX_DSIZE_P		4		// data size
#define LTX_DRATE_P		6		// data rate
#define LTX_CLKSRC_P	9		// clock source (0 - internal, 1 - external)
#define LTX_CLKINV_P	10		// inversion of clock
#define LTX_ACDC_P		11		// enable ADC / DAC mode 
#define LTX_ACKIGN_P	13		// ignore ACKI

#define LTX_EN			(1 << LTX_EN_P)
#define LTX_VEN			(1 << LTX_VEN_P)
#define LTX_TOEN		(1 << LTX_TOEN_P)
#define LTX_BCMP		(1 << LTX_BCMP_P)
#define LTX_DSIZE_1BIT	(0 << LTX_DSIZE_P)
#define LTX_DSIZE_4BIT	(1 << LTX_DSIZE_P)
#define LTX_DSIZE_8BIT	(2 << LTX_DSIZE_P)
#define LTX_DSIZE_16BIT	(3 << LTX_DSIZE_P)
#define LTX_EXTCLK		(1 << LTX_CLKSRC_P)
#define LTX_CLKINV		(1 << LTX_CLKINV_P)
#define LTX_ACDC		(1 << LTX_ACDC_P)
#define LTX_IGNORE_ACK	(1 << LTX_ACKIGN_P)


#define LRX_EN_P		0		// enable
#define LRX_VEN_P		1		// verification enable (CRC)
#define LRX_TOEN_P		2		// timeout check IRQ enable
#define LRX_BCMP_P		3		// block completition
#define LRX_DSIZE_P		4		// data size
#define LRX_OVRN_P		6		// overrun IRQ enable
#define LRX_GPSCLKEN_P	9		// Enable GPS clock generator
#define LRX_ACDC_P		11		// ADC / DAC mode
#define LRX_CLKSEL_P	16		// source for RX clock: 0 - link0, 1 - link1

#define LRX_EN			(1 << LRX_EN_P)
#define LRX_VEN			(1 << LRX_VEN_P)
#define LRX_TOEN		(1 << LRX_TOEN_P)
#define LRX_BCMP		(1 << LRX_BCMP_P)
#define LRX_DSIZE_1BIT	(0 << LRX_DSIZE_P)
#define LRX_DSIZE_4BIT	(1 << LRX_DSIZE_P)
#define LRX_DSIZE_8BIT	(2 << LRX_DSIZE_P)
#define LRX_DSIZE_16BIT	(3 << LRX_DSIZE_P)
#define LRX_OVRN		(1 << LRX_OVRN_P)
#define LRX_GPSCLKEN	(1 << LRX_GPSCLKEN_P)
#define LRX_ACDC		(1 << LRX_ACDC_P)
#define LRX_CLK_L0		(0 << LRX_CLKSEL_P)
#define LRX_CLK_L1		(1 << LRX_CLKSEL_P)

//-------------------------------------------------------//
// UDDC
#define UDDC0_CR_LOC			(UDDC0_BASE + 0)
#define UDDC0_SR_LOC			(UDDC0_BASE + 1)
#define UDDC0_STEP_LOC			(UDDC0_BASE + 2)
#define UDDC0_DR_LOC			(UDDC0_BASE + 4)
#define UDDC0_CR_FREQHOP_LOC	(UDDC0_BASE + 8)

#define UDDC1_CR_LOC			(UDDC1_BASE + 0)
#define UDDC1_SR_LOC			(UDDC1_BASE + 1)
#define UDDC1_STEP_LOC			(UDDC1_BASE + 2)
#define UDDC1_DR_LOC			(UDDC1_BASE + 4)
#define UDDC1_CR_FREQHOP_LOC	(UDDC1_BASE + 8)

#define UDDC2_CR_LOC			(UDDC2_BASE + 0)
#define UDDC2_SR_LOC			(UDDC2_BASE + 1)
#define UDDC2_STEP_LOC			(UDDC2_BASE + 2)
#define UDDC2_DR_LOC			(UDDC2_BASE + 4)
#define UDDC2_CR_FREQHOP_LOC	(UDDC2_BASE + 8)

#define UDDC3_CR_LOC			(UDDC3_BASE + 0)
#define UDDC3_SR_LOC			(UDDC3_BASE + 1)
#define UDDC3_STEP_LOC			(UDDC3_BASE + 2)
#define UDDC3_DR_LOC			(UDDC3_BASE + 4)
#define UDDC3_CR_FREQHOP_LOC	(UDDC3_BASE + 8)

#define UDDC_CR_EN_P			0
#define UDDC_CR_LINK_P			1
#define UDDC_CR_ROUND_P			2
#define UDDC_CR_SAT_P			3
#define UDDC_CR_ROUNDM_P		4
#define UDDC_CR_TBD_P			5
#define UDDC_CR_IQQI_P			6
#define UDDC_CR_DAM_P			7
#define UDDC_CR_KDELAY_P		8
#define UDDC_CR_SHFR_P			17
#define UDDC_CR_FLEN_P			28
#define UDDC_CR_FREQHOP_P		30
#define UDDC_CR_LINKUSE_P		31

#define UDDC_CR_EN				(1 << UDDC_CR_EN_P)
#define UDDC_CR_LINK			(1 << UDDC_CR_LINK_P)
#define UDDC_CR_ROUND			(1 << UDDC_CR_ROUND_P)
#define UDDC_CR_SAT				(1 << UDDC_CR_SAT_P)
#define UDDC_CR_ROUNDM			(1 << UDDC_CR_ROUNDM_P)
#define UDDC_CR_TBD				(1 << UDDC_CR_TBD_P)
#define UDDC_CR_QI				(1 << UDDC_CR_IQQI_P)
#define UDDC_CR_DAM				(1 << UDDC_CR_DAM_P)
#define UDDC_CR_FLEN3			(0 << UDDC_CR_FLEN_P)
#define UDDC_CR_FLEN5			(1 << UDDC_CR_FLEN_P)
#define UDDC_CR_FLEN7			(2 << UDDC_CR_FLEN_P)
#define UDDC_CR_FREQHOP			(1 << UDDC_CR_FREQHOP_P)
#define UDDC_CR_LINK0			(0 << UDDC_CR_LINKUSE_P)
#define UDDC_CR_LINK1			(1 << UDDC_CR_LINKUSE_P)

/*------------------------------------  LCD  -------------------------------------*/
#define LCD_CTRL_LOC							(LCD_BASE + 0)
#define LCD_STATUS_LOC							(LCD_BASE + 1)
#define LCD_HTIM_LOC							(LCD_BASE + 2)
#define LCD_VTIM_LOC							(LCD_BASE + 3)
#define LCD_HVLEN_LOC							(LCD_BASE + 4)
#define LCD_VSIZE_LOC							(LCD_BASE + 7)
#define LCD_PXDV_LOC							(LCD_BASE + 9)
#define LCD_HDTIM_LOC							(LCD_BASE + 10)
#define LCD_VDTIM_LOC							(LCD_BASE + 11)
#define LCD_PANEL_CFG_LOC						(LCD_BASE + 12)
#define LCD_PWM_CR_LOC							(LCD_BASE + 13)
#define LCD_SLP_PERIOD_LOC						(LCD_BASE + 14)
#define LCD_TIM_GP0_LOC							(LCD_BASE + 16)
#define LCD_TIM_GP1_LOC							(LCD_BASE + 17)
#define LCD_TIM_GP2_LOC							(LCD_BASE + 18)
#define LCD_TIM_GP3_LOC							(LCD_BASE + 19)

/*-----------------------------------  TIMER  ------------------------------------*/
/*-- TIMER_CNTRL: Timer Control Register ---------------------------*/
/* Bit field positions: */
#define TIMER_CNTRL_CNT_EN_Pos                  0
#define TIMER_CNTRL_ARRB_EN_Pos                 1
#define TIMER_CNTRL_WR_CMPL_Pos                 2
#define TIMER_CNTRL_DIR_Pos                     3
#define TIMER_CNTRL_FDTS_Pos                    4
#define TIMER_CNTRL_CNT_MODE_Pos                6
#define TIMER_CNTRL_EVENT_SEL_Pos               8

/* Bit field masks: */
#define TIMER_CNTRL_CNT_EN                      ((uint32_t)0x00000001)
#define TIMER_CNTRL_ARRB_EN                     ((uint32_t)0x00000002)
#define TIMER_CNTRL_WR_CMPL                     ((uint32_t)0x00000004)
#define TIMER_CNTRL_DIR                         ((uint32_t)0x00000008)
#define TIMER_CNTRL_FDTS_Msk                    ((uint32_t)0x00000030)
#define TIMER_CNTRL_CNT_MODE_Msk                ((uint32_t)0x000000C0)
#define TIMER_CNTRL_EVENT_SEL_Msk               ((uint32_t)0x00000F00)

/*-- TIMER_CH_CNTRL: Timer Channel Control Register ----------------*/
/* Bit field positions: */
#define TIMER_CH_CNTRL_CHFLTR_Pos               0
#define TIMER_CH_CNTRL_CHSEL_Pos                4
#define TIMER_CH_CNTRL_CHPSC_Pos                6
#define TIMER_CH_CNTRL_OCCE_Pos                 8
#define TIMER_CH_CNTRL_OCCM_Pos                 9
#define TIMER_CH_CNTRL_BRKEN_Pos                12
#define TIMER_CH_CNTRL_ETREN_Pos                13
#define TIMER_CH_CNTRL_WR_CMPL_Pos              14
#define TIMER_CH_CNTRL_CAP_NPWM_Pos             15

/* Bit field masks: */
#define TIMER_CH_CNTRL_CHFLTR_Msk               ((uint32_t)0x0000000F)
#define TIMER_CH_CNTRL_CHSEL_Msk                ((uint32_t)0x00000030)
#define TIMER_CH_CNTRL_CHPSC_Msk                ((uint32_t)0x000000C0)
#define TIMER_CH_CNTRL_OCCE                     ((uint32_t)0x00000100)
#define TIMER_CH_CNTRL_OCCM_Msk                 ((uint32_t)0x00000E00)
#define TIMER_CH_CNTRL_BRKEN                    ((uint32_t)0x00001000)
#define TIMER_CH_CNTRL_ETREN                    ((uint32_t)0x00002000)
#define TIMER_CH_CNTRL_WR_CMPL                  ((uint32_t)0x00004000)
#define TIMER_CH_CNTRL_CAP_NPWM                 ((uint32_t)0x00008000)

/*-- TIMER_CH_CNTRL1: Timer Channel Control1 Register ----------------*/
/* Bit field positions: */
#define TIMER_CH_CNTRL1_SELOE_Pos               0
#define TIMER_CH_CNTRL1_SELO_Pos                2
#define TIMER_CH_CNTRL1_INV_Pos                 4
#define TIMER_CH_CNTRL1_NSELOE_Pos              8
#define TIMER_CH_CNTRL1_NSELO_Pos               10
#define TIMER_CH_CNTRL1_NINV_Pos                12

/* Bit field masks: */
#define TIMER_CH_CNTRL1_SELOE_Msk               ((uint32_t)0x00000003)
#define TIMER_CH_CNTRL1_SELO_Msk                ((uint32_t)0x0000000C)
#define TIMER_CH_CNTRL1_INV                     ((uint32_t)0x00000010)
#define TIMER_CH_CNTRL1_NSELOE_Msk              ((uint32_t)0x00000300)
#define TIMER_CH_CNTRL1_NSELO_Msk               ((uint32_t)0x00000C00)
#define TIMER_CH_CNTRL1_NINV                    ((uint32_t)0x00001000)

/*-- TIMER_CH_DTG: Timer Channel DTG Register ----------------------*/
/* Bit field positions: */
#define TIMER_CH_DTGX_Pos                       0
#define TIMER_CH_DTG_EDTS_Pos                   4
#define TIMER_CH_DTG_Pos                        8

/* Bit field masks: */
#define TIMER_CH_DTGX_Msk                       ((uint32_t)0x0000000F)
#define TIMER_CH_DTG_EDTS                       ((uint32_t)0x00000010)
#define TIMER_CH_DTG_Msk                        ((uint32_t)0x0000FF00)

/*-- TIMER_BRKETR_CNTRL: Timer BRK/ETR Control Register ------------*/
/* Bit field positions: */
#define TIMER_BRKETR_CNTRL_BRK_INV_Pos          0
#define TIMER_BRKETR_CNTRL_ETR_INV_Pos          1
#define TIMER_BRKETR_CNTRL_ETR_PSC_Pos          2
#define TIMER_BRKETR_CNTRL_ETR_FILTER_Pos       4

/* Bit field masks: */
#define TIMER_BRKETR_CNTRL_BRK_INV              ((uint32_t)0x00000001)
#define TIMER_BRKETR_CNTRL_ETR_INV              ((uint32_t)0x00000002)
#define TIMER_BRKETR_CNTRL_ETR_PSC_Msk          ((uint32_t)0x0000000C)
#define TIMER_BRKETR_CNTRL_ETR_FILTER_Msk       ((uint32_t)0x000000F0)

/*-- TIMER_STATUS: Timer Status Register ---------------------------*/
/* Bit field positions: */
#define TIMER_STATUS_CNT_ZERO_EVENT_Pos         0
#define TIMER_STATUS_CNT_ARR_EVENT_Pos          1
#define TIMER_STATUS_ETR_RE_EVENT_Pos           2
#define TIMER_STATUS_ETR_FE_EVENT_Pos           3
#define TIMER_STATUS_BRK_EVENT_Pos              4
#define TIMER_STATUS_CCR_CAP_EVENT_Pos          5
#define TIMER_STATUS_CCR_REF_EVENT_Pos          9
#define TIMER_STATUS_CCR1_CAP_EVENT_Pos         13

/* Bit field masks: */
#define TIMER_STATUS_CNT_ZERO_EVENT             ((uint32_t)0x00000001)
#define TIMER_STATUS_CNT_ARR_EVENT              ((uint32_t)0x00000002)
#define TIMER_STATUS_ETR_RE_EVENT               ((uint32_t)0x00000004)
#define TIMER_STATUS_ETR_FE_EVENT               ((uint32_t)0x00000008)
#define TIMER_STATUS_BRK_EVENT                  ((uint32_t)0x00000010)
#define TIMER_STATUS_CCR_CAP_EVENT_Msk          ((uint32_t)0x000001E0)
#define TIMER_STATUS_CCR_REF_EVENT_Msk          ((uint32_t)0x00001E00)
#define TIMER_STATUS_CCR1_CAP_EVENT_Msk         ((uint32_t)0x0001E000)

/*-- TIMER_IE: Timer Interrupt Enable Register ---------------------*/
/* Bit field positions: */
#define TIMER_IE_CNT_ZERO_EVENT_IE_Pos          0
#define TIMER_IE_CNT_ARR_EVENT_IE_Pos           1
#define TIMER_IE_ETR_RE_EVENT_IE_Pos            2
#define TIMER_IE_ETR_FE_EVENT_IE_Pos            3
#define TIMER_IE_BRK_EVENT_IE_Pos               4
#define TIMER_IE_CCR_CAP_EVENT_IE_Pos           5
#define TIMER_IE_CCR_REF_EVENT_IE_Pos           9
#define TIMER_IE_CCR1_CAP_EVENT_IE_Pos          13

/* Bit field masks: */
#define TIMER_IE_CNT_ZERO_EVENT_IE              ((uint32_t)0x00000001)
#define TIMER_IE_CNT_ARR_EVENT_IE               ((uint32_t)0x00000002)
#define TIMER_IE_ETR_RE_EVENT_IE                ((uint32_t)0x00000004)
#define TIMER_IE_ETR_FE_EVENT_IE                ((uint32_t)0x00000008)
#define TIMER_IE_BRK_EVENT_IE                   ((uint32_t)0x00000010)
#define TIMER_IE_CCR_CAP_EVENT_IE_Msk           ((uint32_t)0x000001E0)
#define TIMER_IE_CCR_REF_EVENT_IE_Msk           ((uint32_t)0x00001E00)
#define TIMER_IE_CCR1_CAP_EVENT_IE_Msk          ((uint32_t)0x0001E000)

/*-- TIMER_DMA_RE: Timer DMA Request Enable Register ---------------*/
/* Bit field positions: */
#define TIMER_DMA_RE_CNT_ZERO_EVENT_RE_Pos      0
#define TIMER_DMA_RE_CNT_ARR_EVENT_RE_Pos       1
#define TIMER_DMA_RE_ETR_RE_EVENT_RE_Pos        2
#define TIMER_DMA_RE_ETR_FE_EVENT_RE_Pos        3
#define TIMER_DMA_RE_BRK_EVENT_RE_Pos           4
#define TIMER_DMA_RE_CCR_CAP_EVENT_RE_Pos       5
#define TIMER_DMA_RE_CCR_REF_EVENT_RE_Pos       9
#define TIMER_DMA_RE_CCR1_CAP_EVENT_RE_Pos      13

/* Bit field masks: */
#define TIMER_DMA_RE_CNT_ZERO_EVENT_RE          ((uint32_t)0x00000001)
#define TIMER_DMA_RE_CNT_ARR_EVENT_RE           ((uint32_t)0x00000002)
#define TIMER_DMA_RE_ETR_RE_EVENT_RE            ((uint32_t)0x00000004)
#define TIMER_DMA_RE_ETR_FE_EVENT_RE            ((uint32_t)0x00000008)
#define TIMER_DMA_RE_BRK_EVENT_RE               ((uint32_t)0x00000010)
#define TIMER_DMA_RE_CCR_CAP_EVENT_RE_Msk       ((uint32_t)0x000001E0)
#define TIMER_DMA_RE_CCR_REF_EVENT_RE_Msk       ((uint32_t)0x00001E00)
#define TIMER_DMA_RE_CCR1_CAP_EVENT_RE_Msk      ((uint32_t)0x0001E000)

/*-- TIMER_CH_CNTRL2: Timer Channel Control2 Register --------------*/
/* Bit field positions: */
#define TIMER_CH_CNTRL2_CHSEL1_Pos              0
#define TIMER_CH_CNTRL2_CCR1_EN_Pos             2
#define TIMER_CH_CNTRL2_CCRRLD_Pos              3

/* Bit field masks: */
#define TIMER_CH_CNTRL2_CHSEL1_Msk              ((uint32_t)0x00000003)
#define TIMER_CH_CNTRL2_CCR1_EN                 ((uint32_t)0x00000004)
#define TIMER_CH_CNTRL2_CCRRLD                  ((uint32_t)0x00000008)

#endif
